/****************************************************************************

 TGA.H

 Targa header file for shandy program

 Structures for Targa files used in SHANDY

 Andrew Cheung 7/96

 ***************************************************************************/

#ifndef _TGA_H
#define _TGA_H
#include "defines.h"

#define BYTE unsigned char
#ifdef WATCOM32
	#define WORD short
#else
	#define WORD int
#endif

struct tga_header
{
	BYTE ID_length;
	BYTE color_map_type;
	BYTE image_type;
	WORD first_color_map_entry;
	WORD color_map_length;
	BYTE color_map_entry_size;
	WORD image_x_origin;
	WORD image_y_origin;
	WORD image_width;
	WORD image_height;
	BYTE bits_per_pixel;
	BYTE image_descriptor_bits;
};

struct tga_struct
{
	tga_header header;				 // The tga header
	char *ID;                      // Optional ID string
	unsigned char *image;          // The image
	unsigned char palette[256*3];  // The image palette (256 rgb values)
};

int loadtga(char *filename,tga_struct *tga);
int load_image(int tgafile,tga_struct *tga);
void load_palette(int tgafile,tga_struct *tga);

#endif
