/*  object.h
 *
 *  Definitions for the object manipulation code.
 *
 *  Written and copyright (c) 1994 by Steve Madsen.
 */

#ifndef _OBJECT_H
#define _OBJECT_H

#include "project.h"

#define SOLID        0
#define TEXTURED     1
#define SHADED_RED   2
#define SHADED_GREEN 3
#define SHADED_BLUE  4
#define SHADED_GREY  5
#define WIREFRAME    6

#define MAX_POINTS_PER_OBJECT 100
#define MAX_POINTS_PER_SURFACE 20
#define MAX_SURFACES_PER_OBJECT 50
#define MAX_OBJECTS_PER_WORLD 20

#define swap(a,b) { a ^= b; b ^= a; a ^= b; }

typedef struct {
  int height;
  int width;
  char *data;
  char *fname;
} BITMAP;

typedef struct OBJ_NODE OBJECT;
typedef struct SURF_NODE SURFACE;
typedef struct SURF_NODE {
  int num_points;
  int points[MAX_POINTS_PER_SURFACE];
  int style;
  int color;
  BITMAP *bmap;
  OBJECT *partof;
  VECTOR normal;
  VECTOR cur_normal;
  SURFACE *next;
} SURFACE;

typedef struct OBJ_NODE {
  POINT center;
  int num_surfaces;
  SURFACE *surfaces;
  int num_points;
  POINT points[MAX_POINTS_PER_OBJECT];
  POINT cur_points[MAX_POINTS_PER_OBJECT];
  byte xcangle, ycangle, zcangle;
  byte xcdelta, ycdelta, zcdelta;
  OBJECT *next;
} OBJECT;

typedef struct {
  int num_objects;
  OBJECT *objects;
} WORLD;

void AddPoint(SURFACE *, POINT *);
void DestroyObject(OBJECT *);
void DestroySurface(SURFACE *);
void DestroyWorld(WORLD *);
void DrawObject(OBJECT *);
void DrawSurface(SURFACE *);
void DrawWorld(WORLD *);
void LoadGifBitmap(SURFACE *, char *, int);
void LoadPxmBitmap(SURFACE *, char *);
OBJECT *NewObject(WORLD *);
SURFACE *NewSurface(OBJECT *);
WORLD *NewWorld(void);
void UpdateObject(OBJECT *);
void UpdateWorld(WORLD *);

#endif /* _OBJECT_H */

