/*  stars.c
 *
 *  Generates and animates a starfield.
 *
 *  Written and copyright (c) 1994 by Steve Madsen.  All rights reserved.
 */

#include <stdlib.h>
#include <xlib_all.h>
#include "project.h"
#include "gfx.h"
#include "stars.h"
#include "random.inc"

POINT stars[MAX_STARS];
int max = 0;

int ran(void)
{
  static next = 0;

  if (next >= 2048)
    next = 0;
  return (randtable[next++]);
}

void AnimateStars(void)
{
  POINT_2D p;
  int index;

  if (max == 0)
    return;

  x_rect_fill(0, 0, 320, screenheight, HiddenPageOffs, backcolor);

  /* move the stars forward, replacing as necessary */

  for (index = 0; index < max; index++) {
    stars[index].z += INT_TO_FIXED(1);
    Project(&stars[index], &p);
    while (abs(p.x) > 160 || abs(p.y) > (screenheight >> 1) || stars[index].z - eye.z == INT_TO_FIXED(-1)) {
      MakePoint(ran() - 10, ran() - 10, -25, &stars[index]);
      Project(&stars[index], &p);
    }
    x_put_pix(p.x + 160, p.y + (screenheight >> 1), HiddenPageOffs, STAR_COLOR);
  }
}

void SeedStars(int maxstars)
{
  int index;

  if ((max = maxstars) > 0) {
    background = NONE;
    if (max > MAX_STARS)
      max = MAX_STARS;
    for (index = 0; index < max; index++)
      MakePoint(ran() - 10, ran() - 10, -25, &stars[index]);
  }
}

