/*
**  DBLROUND.C - Rounds a double to the nearest whole number
**  public domain by Ross Cottrell
*/

#include <float.h>
#include <limits.h>
#include <assert.h>

typedef enum {FALSE, TRUE} boolean;
double round(double x)
{
      boolean flag;

      if (TRUE == (flag = (x < 0.0)))
            x = -x;
      assert(1 == FLT_ROUNDS);
      x += 1.0 / DBL_EPSILON;
      x -= 1.0 / DBL_EPSILON;
      return ((flag) ? -x : x);
}

#ifdef TEST

#include <stdio.h>
#include <stdlib.h>

main(int argc, char *argv[])
{
      double val;
      char *dummy;

      while (--argc)
      {
            val = strtod((const char *)(*(++argv)), &dummy);
            printf("round(%g) = ", val);
            printf("%.12g\n", round(val));
      }
      return EXIT_SUCCESS;
}

#endif /* TEST */
