Program Modeler;

{ This program uses 3 dimensional lines to represent figures drawn
  by a combination of modeling, color mapping, and bump mapping  }

Uses crt,spx_img,spx_vga,spx_key,spx_obj,spx_t3d,spx_txt,spx_fnc,
     spx_gui,mouse;
     { These units are used because they are superior in speed to
       the BGI units that come with turbo pascal.  Many thanks to
       the author of the units, Scott Ramseys. }

const
  pbeg : plist = nil;
  pend : plist = nil;
  path = '';    { default work path }
  recx1 = 40;  recx2 = 250;  recy1 = 20;  recy2 = 180;
  sw = 4; { 1/2 sprite width from center }
  jump = 10; { number of units to jump when rotating and scaling }
  windx1 = 40; windy1 = 40;  { window used to dimension bumped surface }
  windx2 = 180; windy2 = 160;
  spacing = 3; { distance between sampled points in bump mapping }

type
  Ppoint = ^Tpoint;
  Tpoint = object(Tobjs)
             color      : integer;
             x,y,z      : integer;
             x2,y2,z2      : integer;
             x3,y3,z3      : integer;
             x4,y4,z4      : integer;
             dx,dx2,dx3,dx4 : integer;
             dy,dy2,dy3,dy4 : integer;
             vx,vy,vz      : integer;
             motion        : boolean;
             hide          : boolean;  { hide objects in the background }
             linetype      : byte;  { 1=surface, 2=line, 3=point 4=poly }
             timeout       : integer;
             constructor init(ltype: byte;
                         nx,ny,nz,
                         nx2,ny2,nz2,
                         nx3,ny3,nz3,
                         nx4,ny4,nz4,
                         c:integer);
           end;
       ptarray = array[1..100] of integer;
var
  timeo               : integer;
  oldexit   : pointer;
  d,m,q,r     : integer;
  pal   : RGBlist;
  xpos,ypos,zpos        : integer;
  xa,ya,za              : integer;
  dir                   : integer;
  butn, dum             : integer;    { test for mouse }
  mx,my,vmx,vmy,mdown   : integer;
  xrot,yrot,zrot        : integer;
  avgx,avgy,avgz,avgvx,avgvy,avgvz  : integer;


procedure checkmouseerr;
{ check if mouse exist, display message if not found }
begin
     if mousereset<>0           { reset mouse driver }
       then writeln('No mouse is installed')
       else
         begin
           normalizemx; { set skl variable according to driver }
           getmouse(m2,m3,m4); { get the mouse position }
         end;
     setdefptr;
end;

procedure cleanup;far;
begin
  clean_plist(pbeg,pend);
  closemode;
  exitproc := oldexit;
  { turn off mouse if available }
  mouseoff;
end;

procedure newpal(palfile: string);
begin
  if palfile <> '' then begin
    loadcolors('vpres.pal',pal,256);
    fsetcolors(pal);  { palette }
  end;
end;


procedure addlinesegment(x1,y1,z1,x2,y2,z2,color: integer);
var x,y                        : integer;
    p                          : plist;
begin
  new(p);
  p^.item := new(ppoint,init(2,x1,y1,z1,x2,y2,z2,0,0,0,0,0,0,color));
  p^.item^.powner := p;
  addp(pbeg,pend,p);
end;


procedure addxysegment(x1,y1,z1,x2,y2,z2,x3,y3,z3,color: integer);
var x,y                        : integer;
    p                          : plist;
    ltype                      : byte;
begin
    ltype:=1;
    new(p);
    p^.item := new(ppoint,init(ltype,x1,y1,z1,x2,y2,z2,
           x3,y3,z3,0,0,0,color));
    p^.item^.powner := p;
    addp(pbeg,pend,p);
end;

procedure loadmaps;
var    bf,cf    : string; { bump and color }
begin
   bf:='vpres';
   cf:='vpres';
   setpageactive(2);
   { grey scale image to derive depth }
   loadpcx(bf+'.pcx');   { load pcx file on page }
   { color image to derive color }
   setpageactive(3);
   loadpcx(cf+'.pcx');
   newpal(bf);
end;


procedure twodimto3d(lx1,lx2,ly1,ly2,page: integer);
var x,y                        : integer;
    p1,p2,p3,p4                : integer; { point color of 4 dirs }
    e1,e2,e3,e4                : integer; { extrudes of 4 dirs }
    xx,yy,zz                   : integer;
    p                          : plist;
    xstep,ystep                : integer;

begin
   xstep:=lx1;
   while (xstep<lx2) do begin
      ystep:=ly1;
      while (ystep<ly2) do begin 

         e1:=point(xstep,ystep,2);  { bump map depth for line }
         e2:=point(xstep,ystep+spacing,2);
         e3:=point(xstep+spacing,ystep,2);

         p1:=point(xstep,ystep,3); { get the color for the poly }

         if (p1>10)  then begin

         { create an object that represents change of z dimension }
         { in by creating a horizontal and vertical 3d line       }

         addxysegment(xstep-(160),ystep-(100),(e1 div 6),
                   xstep-(160),ystep+spacing-(100),(e2 div 6),
                   xstep+spacing-(160),ystep-(100),(e3 div 6),p1);


         end;
         ystep:=ystep+spacing;
       end; {while}
       xstep:=xstep+spacing;
   end; {while 2}
   {pcopy(3,1);}                { show color map }
end;

procedure makepoly(x1,y1,z1,x2,y2,z2,x3,y3,z3,x4,y4,z4,color: integer);
{ construct a polygon }
var       p           : plist;
begin
  new(p);
  p^.item := new(ppoint,init(4,x1,y1,z1,x2,y2,z2,x3,y3,z3,x4,y4,z4,color));
  p^.item^.powner := p;
  addp(pbeg,pend,p);
end;

procedure makeaxis;
{ construct an axis on x,y,z=0 }
var       p           : plist;
begin
  addlinesegment(-10,0,0,10,0,0,100);
  addlinesegment(0,-10,0,0,10,0,120);
  addlinesegment(0,0,-10,0,0,10,140);
end;

procedure bezier(extr,xp0,yp0, xp1,yp1 ,xp2,yp2, xp3,yp3,n,color: integer);
{ construct a bezier curve shape }
var       i           : integer;
          t,delta     : real;
          curveptx    : integer;
          curvepty    : integer;
          oldptx      : integer;
          oldpty      : integer;
          p           : plist;
          depth       : integer;

begin
  for depth:=1 to extr do begin
   oldptx:=xp0;
   oldpty:=yp0;
   delta:=1.0/n;
   for i:=1 to n do begin
       t:=i*delta;
       curveptx:=round(xp0 * (1.0-t) * (1.0-t) * (1.0-t)
          + xp1 * 3.0 * t * (1.0-t) * (1.0-t)
          + xp2 * 3.0 * t * t * (1.0-t)
          + xp3 * t * t * t);

       curvepty:=round(yp0 * (1.0-t) * (1.0-t) * (1.0-t)
          + yp1 * 3.0 * t * (1.0-t) * (1.0-t)
          + yp2 * 3.0 * t * t * (1.0-t)
          + yp3 * t * t * t);

           new(p);
           p^.item := new(ppoint,init(2,oldptx-(1),oldpty-(1),depth,
                   curveptx-(1),curvepty-(1),depth,
                   0,0,0,0,0,0,255));
           p^.item^.powner := p;
           addp(pbeg,pend,p);

       oldptx:=curveptx;
       oldpty:=curvepty;
   end;
 end;
end;

procedure extrudebezier(extr,  xp0,yp0, xp1,yp1 ,xp2,yp2, xp3,yp3,
                              mapcorner1, mapcorner2, n,color: integer);
{ construct an extruded color mapped bezier curve }
var       i           : integer;
          t,delta     : real;
          curveptx    : integer;
          curvepty    : integer;
          oldptx      : integer;
          oldpty      : integer;
          p           : plist;
          depth       : integer;

begin
  for depth:=1 to extr do begin
   oldptx:=xp0;
   oldpty:=yp0;
   delta:=1.0/n;
   for i:=1 to n do begin
       t:=i*delta;
       curveptx:=round(xp0 * (1.0-t) * (1.0-t) * (1.0-t)
          + xp1 * 3.0 * t * (1.0-t) * (1.0-t)
          + xp2 * 3.0 * t * t * (1.0-t)
          + xp3 * t * t * t);

       curvepty:=round(yp0 * (1.0-t) * (1.0-t) * (1.0-t)
          + yp1 * 3.0 * t * (1.0-t) * (1.0-t)
          + yp2 * 3.0 * t * t * (1.0-t)
          + yp3 * t * t * t);

           color:=point(mapcorner1+curveptx,mapcorner2+depth,3);

           new(p);
           p^.item := new(ppoint,init(2,oldptx-(1),oldpty-(1),-depth,
                   curveptx-(1),curvepty-(1),-depth,
                   0,0,0,0,0,0,color));
           p^.item^.powner := p;
           addp(pbeg,pend,p);

       oldptx:=curveptx;
       oldpty:=curvepty;
   end;
 end;
end;

procedure mapsurf
          (xp11,yp11,zp11, xp21,yp21,zp21 ,xp31,yp31,zp31, xp41,yp41,zp41,
           xp12,yp12,zp12, xp22,yp22,zp22 ,xp32,yp32,zp32, xp42,yp42,zp42,
           xp13,yp13,zp13, xp23,yp23,zp23 ,xp33,yp33,zp33, xp43,yp43,zp43,
           xp14,yp14,zp14, xp24,yp24,zp24 ,xp34,yp34,zp34, xp44,yp44,zp44,
           ns,nt,n: integer);

{ construct a color mapped bezier curve }
var       i,j                     : integer;
          s,t,del, dels, delt     : real;
          curveptx    : integer;
          curvepty    : integer;
          curveptz    : integer;
          oldptx      : integer;
          oldpty      : integer;
          oldptz      : integer;
          p           : plist;
          depth       : integer;
          color       : integer;        { color of the line of the curve }
          colorx, colory : integer;     { location of point to get color map }

begin
   { move control points from 4th quadrant to center of screen } 
   xp11:=xp11-160; xp12:=xp12-160; xp13:=xp13-160; xp14:=xp14-160;
   xp21:=xp21-160; xp22:=xp22-160; xp23:=xp23-160; xp24:=xp24-160;
   xp31:=xp31-160; xp32:=xp32-160; xp33:=xp33-160; xp34:=xp34-160;
   xp41:=xp41-160; xp42:=xp42-160; xp43:=xp43-160; xp44:=xp44-160;
   yp11:=yp11-100; yp12:=yp12-100; yp13:=yp13-100; yp14:=yp14-100;
   yp21:=yp21-100; yp22:=yp22-100; yp23:=yp23-100; yp24:=yp24-100;
   yp31:=yp31-100; yp32:=yp32-100; yp33:=yp33-100; yp34:=yp34-100;
   yp41:=yp41-100; yp42:=yp42-100; yp43:=yp43-100; yp44:=yp44-100;


   del:=1.0/n;
   dels:=1.0/(ns-1);
   delt:=1.0/(nt-1);

   for i:=0 to ns do begin
     s:=i*dels;
     oldptx:=xp11; { assign a start point } 
     oldpty:=yp11;
     oldptz:=zp11;

     for j:=0 to nt do begin
       t:=j*delt;
       curveptx:=round(
       ((1-s)*(1-s)*(1-s)) * ( xp11*((1-t)*(1-t)*(1-t)) +
         (3*xp12*((1-t)*(1-t)*t)) + (3*xp13*(1-t)*t*t) + (xp14*t*t*t)) +
       3*((1-s)*(1-s)*(s)) * ( xp21*((1-t)*(1-t)*(1-t)) +
         (3*xp22*((1-t)*(1-t)*t)) + (3*xp23*(1-t)*t*t) + (xp24*t*t*t)) +
       3*((1-s)*(s)*(s)) * ( xp31*((1-t)*(1-t)*(1-t)) +
         (3*xp32*((1-t)*(1-t)*t)) + (3*xp33*(1-t)*t*t) + (xp34*t*t*t)) +
       ((s)*(s)*(s)) * ( xp41*((1-t)*(1-t)*(1-t)) +
         (3*xp42*((1-t)*(1-t)*t)) + (3*xp43*(1-t)*t*t) + (xp44*t*t*t)) );

       curvepty:=round(
       ((1-s)*(1-s)*(1-s)) * ( yp11*((1-t)*(1-t)*(1-t)) +
         (3*yp12*((1-t)*(1-t)*t)) + (3*yp13*(1-t)*t*t) + (yp14*t*t*t)) +
       3*((1-s)*(1-s)*(s)) * ( yp21*((1-t)*(1-t)*(1-t)) +
         (3*yp22*((1-t)*(1-t)*t)) + (3*yp23*(1-t)*t*t) + (yp24*t*t*t)) +
       3*((1-s)*(s)*(s)) * ( yp31*((1-t)*(1-t)*(1-t)) +
         (3*yp32*((1-t)*(1-t)*t)) + (3*yp33*(1-t)*t*t) + (yp34*t*t*t)) +
       ((s)*(s)*(s)) * ( yp41*((1-t)*(1-t)*(1-t)) +
         (3*yp42*((1-t)*(1-t)*t)) + (3*yp43*(1-t)*t*t) + (yp44*t*t*t)) );

       curveptz:=round(
       ((1-s)*(1-s)*(1-s)) * ( zp11*((1-t)*(1-t)*(1-t)) +
         (3*zp12*((1-t)*(1-t)*t)) + (3*zp13*(1-t)*t*t) + (zp14*t*t*t)) +
       3*((1-s)*(1-s)*(s)) * ( zp21*((1-t)*(1-t)*(1-t)) +
         (3*zp22*((1-t)*(1-t)*t)) + (3*zp23*(1-t)*t*t) + (zp24*t*t*t)) +
       3*((1-s)*(s)*(s)) * ( zp31*((1-t)*(1-t)*(1-t)) +
         (3*zp32*((1-t)*(1-t)*t)) + (3*zp33*(1-t)*t*t) + (zp34*t*t*t)) +
       ((s)*(s)*(s)) * ( zp41*((1-t)*(1-t)*(1-t)) +
         (3*zp42*((1-t)*(1-t)*t)) + (3*zp43*(1-t)*t*t) + (zp44*t*t*t)) );


         setpoints(curveptx,curvepty,curveptz,colorx,colory);
         color:=point(colorx,colory,3);
        if color >5 then begin { don't add stuff off of color map }
           new(p);

           { this is for drawing single 3d lines }
           {p^.item := new(ppoint,init(2,oldptx-(1),oldpty-(1),oldptz-(1),}

           { this is for drawing 2 paralell 3d lines }
           {p^.item := new(ppoint,init(1,oldptx-(1),oldpty-(1),oldptz-(1),}

           { this is for drawing squares }
           {p^.item := new(ppoint,init(5,oldptx-(1),oldpty-(1),oldptz-(1),}

           { this is for points }
           p^.item := new(ppoint,init(3,oldptx-(1),oldpty-(1),oldptz-(1),
                   curveptx-(1),curvepty-(1),curveptz-(1),
                   0,0,0,0,0,0,color));

           p^.item^.powner := p;
           addp(pbeg,pend,p);
        end;
       oldptx:=curveptx;
       oldpty:=curvepty;
       oldptz:=curveptz;
     end;
 end;
end;


procedure dispmapsurf
{ draw a bezier surface computing the equation each draw }
          (xp11,yp11,zp11, xp21,yp21,zp21 ,xp31,yp31,zp31, xp41,yp41,zp41,
           xp12,yp12,zp12, xp22,yp22,zp22 ,xp32,yp32,zp32, xp42,yp42,zp42,
           xp13,yp13,zp13, xp23,yp23,zp23 ,xp33,yp33,zp33, xp43,yp43,zp43,
           xp14,yp14,zp14, xp24,yp24,zp24 ,xp34,yp34,zp34, xp44,yp44,zp44,
           ns,nt,n: integer);

{ display a color mapped bezier curve }
var       i,j                     : integer;
          s,t,del, dels, delt     : real;
          curveptx    : integer;
          curvepty    : integer;
          curveptz    : integer;
          oldptx      : integer;
          oldpty      : integer;
          oldptz      : integer;
          p           : plist;
          depth       : integer;
          color       : integer;        { color of the line of the curve }
          colorx, colory : integer;     { location of point to get color map }

begin
   { move control points from 4th quadrant to center of screen } 
   xp11:=xp11-160; xp12:=xp12-160; xp13:=xp13-160; xp14:=xp14-160;
   xp21:=xp21-160; xp22:=xp22-160; xp23:=xp23-160; xp24:=xp24-160;
   xp31:=xp31-160; xp32:=xp32-160; xp33:=xp33-160; xp34:=xp34-160;
   xp41:=xp41-160; xp42:=xp42-160; xp43:=xp43-160; xp44:=xp44-160;
   yp11:=yp11-100; yp12:=yp12-100; yp13:=yp13-100; yp14:=yp14-100;
   yp21:=yp21-100; yp22:=yp22-100; yp23:=yp23-100; yp24:=yp24-100;
   yp31:=yp31-100; yp32:=yp32-100; yp33:=yp33-100; yp34:=yp34-100;
   yp41:=yp41-100; yp42:=yp42-100; yp43:=yp43-100; yp44:=yp44-100;

   rotate256xyz(xp11,yp11,zp11,xrot,yrot,r);
   rotate256xyz(xp21,yp21,zp21,xrot,yrot,r);
   rotate256xyz(xp31,yp31,zp31,xrot,yrot,r);
   rotate256xyz(xp41,yp41,zp41,xrot,yrot,r);
   rotate256xyz(xp12,yp12,zp12,xrot,yrot,r);
   rotate256xyz(xp22,yp22,zp22,xrot,yrot,r);
   rotate256xyz(xp32,yp32,zp32,xrot,yrot,r);
   rotate256xyz(xp42,yp42,zp42,xrot,yrot,r);
   rotate256xyz(xp13,yp13,zp13,xrot,yrot,r);
   rotate256xyz(xp23,yp23,zp23,xrot,yrot,r);
   rotate256xyz(xp33,yp33,zp33,xrot,yrot,r);
   rotate256xyz(xp43,yp43,zp43,xrot,yrot,r);
   rotate256xyz(xp14,yp14,zp14,xrot,yrot,r);
   rotate256xyz(xp24,yp24,zp24,xrot,yrot,r);
   rotate256xyz(xp34,yp34,zp34,xrot,yrot,r);
   rotate256xyz(xp44,yp44,zp44,xrot,yrot,r);


   del:=1.0/n;
   dels:=1.0/(ns-1);
   delt:=1.0/(nt-1);

   for i:=0 to ns do begin
     s:=i*dels;
     oldptx:=xp11; { assign a start point } 
     oldpty:=yp11;
     oldptz:=zp11;

     for j:=0 to nt do begin
       t:=j*delt;
       curveptx:=round(
       ((1-s)*(1-s)*(1-s)) * ( xp11*((1-t)*(1-t)*(1-t)) +
         (3*xp12*((1-t)*(1-t)*t)) + (3*xp13*(1-t)*t*t) + (xp14*t*t*t)) +
       3*((1-s)*(1-s)*(s)) * ( xp21*((1-t)*(1-t)*(1-t)) +
         (3*xp22*((1-t)*(1-t)*t)) + (3*xp23*(1-t)*t*t) + (xp24*t*t*t)) +
       3*((1-s)*(s)*(s)) * ( xp31*((1-t)*(1-t)*(1-t)) +
         (3*xp32*((1-t)*(1-t)*t)) + (3*xp33*(1-t)*t*t) + (xp34*t*t*t)) +
       ((s)*(s)*(s)) * ( xp41*((1-t)*(1-t)*(1-t)) +
         (3*xp42*((1-t)*(1-t)*t)) + (3*xp43*(1-t)*t*t) + (xp44*t*t*t)) );

       curvepty:=round(
       ((1-s)*(1-s)*(1-s)) * ( yp11*((1-t)*(1-t)*(1-t)) +
         (3*yp12*((1-t)*(1-t)*t)) + (3*yp13*(1-t)*t*t) + (yp14*t*t*t)) +
       3*((1-s)*(1-s)*(s)) * ( yp21*((1-t)*(1-t)*(1-t)) +
         (3*yp22*((1-t)*(1-t)*t)) + (3*yp23*(1-t)*t*t) + (yp24*t*t*t)) +
       3*((1-s)*(s)*(s)) * ( yp31*((1-t)*(1-t)*(1-t)) +
         (3*yp32*((1-t)*(1-t)*t)) + (3*yp33*(1-t)*t*t) + (yp34*t*t*t)) +
       ((s)*(s)*(s)) * ( yp41*((1-t)*(1-t)*(1-t)) +
         (3*yp42*((1-t)*(1-t)*t)) + (3*yp43*(1-t)*t*t) + (yp44*t*t*t)) );

       curveptz:=round(
       ((1-s)*(1-s)*(1-s)) * ( zp11*((1-t)*(1-t)*(1-t)) +
         (3*zp12*((1-t)*(1-t)*t)) + (3*zp13*(1-t)*t*t) + (zp14*t*t*t)) +
       3*((1-s)*(1-s)*(s)) * ( zp21*((1-t)*(1-t)*(1-t)) +
         (3*zp22*((1-t)*(1-t)*t)) + (3*zp23*(1-t)*t*t) + (zp24*t*t*t)) +
       3*((1-s)*(s)*(s)) * ( zp31*((1-t)*(1-t)*(1-t)) +
         (3*zp32*((1-t)*(1-t)*t)) + (3*zp33*(1-t)*t*t) + (zp34*t*t*t)) +
       ((s)*(s)*(s)) * ( zp41*((1-t)*(1-t)*(1-t)) +
         (3*zp42*((1-t)*(1-t)*t)) + (3*zp43*(1-t)*t*t) + (zp44*t*t*t)) );

          line3d(oldptx,oldpty,oldptz+m,curveptx,curvepty,curveptz+m,255,true);

       oldptx:=curveptx;
       oldpty:=curvepty;
       oldptz:=curveptz;
     end;
 end;
end;


procedure makenpts(xp,yp, color: integer);
{ construct a network of control points }
var       p           : plist;
          addx,addy   : integer;
begin

  for addy:=1 to 5 do begin    { add top row then second then... }
    for addx:=1 to 4 do begin
     new(p);
     { points will be of linetype 10 - movable dots }
     p^.item := new(ppoint,init(10, xp+(20*addx),yp+(20*addy),0,
                                    0,0,0, 0,0,0, 0,0,0,color));
     p^.item^.powner := p;
     addp(pbeg,pend,p);
    end;

  end;
end;


procedure nettolist;
{ take the net of control points and make a 3d bezier surface }
var
  p        : plist;
  m2,m3,m4 : integer;
  dum,d2      : integer;
  cx,cy,cz : array[1..20] of integer;

begin
  dum:=0;
  for dum:=1 to 20 do cx[dum]:=0;
  for dum:=1 to 20 do cy[dum]:=0;
  for dum:=1 to 20 do cz[dum]:=0;
  p := pbeg;
  d2:=0;
  while p<>nil do
    with ppoint(p^.item)^ do
      begin
        if p<>pbeg then begin
             if linetype=10 then begin
                d2:=d2+1;
                cx[d2]:=x;
                cy[d2]:=y;
                cz[d2]:=0;
             end;
        end;
        p := p^.next;
      end;
   mapsurf(cx[1],cy[1],cz[1],  cx[2],cy[2],cz[2], cx[3],cy[3],cz[3], cx[4],cy[4],cz[4],
          cx[5],cy[5],cz[5],  cx[6],cy[6],cz[6], cx[7],cy[7],cz[7], cx[8],cy[8],cy[8],
          cx[9],cy[9],cz[9],  cx[10],cy[10],cz[10], cx[11],cy[11],cz[12], cx[12],cy[12],cz[12],
          cx[13],cy[13],cz[13], cx[14],cy[14],cz[14], cx[15],cy[15],cz[15],cx[16],cy[16],cy[16], 
          40,20,10);
end;



procedure volpoly(dx,dy,dx2,dy2,dx3,dy3,dx4,dy4,color : integer);
var
  p : tPoly;
begin
      p.init;
      p.addpoint(dx,dy);
      p.addpoint(dx2,dy2);
      p.addpoint(dx3,dy3);
      p.addpoint(dx4,dy4);
      p.addpoint(dx,dy);
      FillPoly(dx,dy,p,color);
end;

procedure explode;
var
  p        : plist;
begin
  p := pbeg;
  while p<>nil do
    with ppoint(p^.item)^ do
      begin
        if p<>pbeg then motion:=true;
       p := p^.next;
      end;
end;

procedure testdepth;
var
  p,pp        : plist;
  xx,yy,zz : integer;

begin
  p := pbeg;
  while p<>nil do
    with ppoint(p^.item)^ do
      begin
      xx:=x; yy:=y; zz:=z;
      begin
        pp := pbeg;
        while p<>nil do
        with ppoint(p^.item)^ do if (abs(xx-x)<10) and (abs(yy-y)<10) then begin
           if zz>z then hide:=true else hide:=false;
        end;
        pp := p^.next;
      end;
      p := p^.next;
      end;
end;

procedure rangecheckall;
var
  p        : plist;
begin
  p := pbeg;
  while p<>nil do
    with ppoint(p^.item)^ do
      begin
        if p<>pbeg then begin
           if (dx<10) or (dx>310) or (dy<10) or (dy>190) or
              (dx2<10) or (dx2>310) or (dy2<10) or (dy2>190)
               then hide:=true else hide:=false;
        end;
       p := p^.next;
      end;
end;

procedure drawcrosshairs(crx,cry,color : integer);

begin
  line(crx-2,cry,crx-1,cry,color);
  line(crx+2,cry,crx+1,cry,color);
  line(crx,cry+2,crx,cry+1,color);
  line(crx,cry-2,crx,cry-1,color);
  pset(crx,cry,color-70);
end;

procedure mousepresslist(mx,my : integer);
var
  p        : plist;
  m2,m3,m4 : integer;

begin
  { draw a different crosshairs to show mousepress }
  drawcrosshairs(mx,my,200);

  p := pbeg;
  while p<>nil do
    with ppoint(p^.item)^ do
      begin
        if p<>pbeg then begin
           if (abs(x-mx) < 10) and (abs(y-my) < 10) then begin
             if linetype=10 then begin
               x:=mx;
               y:=my;
             end;
           end;
        end;
        p := p^.next;
      end;
end;


procedure calcaverage;
var
  p        : plist;
  tx,ty,tz,tvx,tvy,tvz   : integer;
  numobs          : integer;
begin
  p := pbeg;
  while p<>nil do
    with ppoint(p^.item)^ do
      begin
        if p<>pbeg then begin
          tx:=tx+x;  ty:=ty+y;  tz:=tz+z;
          tvx:=tvx+vx;  tvy:=tvy+vy; tvz:=tvz+vz;
          numobs:=numobs+1;
        end;
       p := p^.next;
      end;
  avgx:=tx div numobs;
  avgy:=ty div numobs;
  avgz:=tz div numobs;
  avgvx:=tvx div numobs;
  avgvy:=tvy div numobs;
  avgvz:=tvz div numobs;
end;


procedure transformlist;
var
  tx,ty,tz,
  tx2,ty2,tz2,
  tx3,ty3,tz3,
  tx4,ty4,tz4,

  ox,oy,oz : integer;
  p        : plist;
  w       : integer; { width of polygon in mesh }
  l       : integer;

begin
  p := pbeg;
  while p<>nil do
    with ppoint(p^.item)^ do
      begin
       if hide=false then begin
        tx := x; ty := y; tz := z;
        tx2 := x2; ty2 := y2; tz2 := z2;
        tx3 := x3; ty3 := y3; tz3 := z3;

        rotate256xyz(tx,ty,tz,xrot,yrot,r);
        rotate256xyz(tx2,ty2,tz2,xrot,yrot,r);
        rotate256xyz(tx3,ty3,tz3,xrot,yrot,r);


        { * draw horizontal and vertical lines to represent surface * }
        if {(motion=false) and} (linetype=1) then begin

          {** main drawing routine **}
          { draw initial vertical line segment }
          line3d(tx,ty,tz+m,tx2,ty2,tz2+m,color,false);

          { draw paralell vertical line segments }
          line3d(tx+1,ty,tz+m,tx2+1,ty2,tz2+m,color,false);
          line3d(tx+2,ty,tz+m,tx2+2,ty2,tz2+m,color,false);

          { draw initial horizontal line segment }
          {line3d(tx,ty,tz+m,tx3,ty3,tz3+m,color,true);}

          { draw lines to fill in any gaps due to spacing difference }
          { for l:=1 to spacing-1 do begin
            line3d(tx+l,ty,tz+m,tx2+l,ty2,tz2+m,color,true);
            line3d(tx,ty+l,tz+m,tx3,ty3+l,tz3+m,color,true);
           end;}
        end


        { * draw single 3d lines * }
        else if (linetype=2) then begin
          line3d(tx,ty,tz+m,tx2,ty2,tz2+m,color,true);
          {line3d(tx+1,ty,tz+m,tx2+1,ty2,tz2+m,color,true);
          line3d(tx+2,ty,tz+m,tx2+2,ty2,tz2+m,color,true);}
       end

       { * draw point * }
       else if (linetype=3) then pset3d(tx,ty,tz+m,color)

       { * draw polygon *}
       else if (linetype=4) then begin
          setpoints((tx),(ty),(tz+m-200),dx,dy);
          setpoints((tx2),(ty2),(tz2+m-200),dx2,dy2);
          setpoints((tx3),(ty3),(tz3+m-200),dx3,dy3);
          setpoints((tx4),(ty4),(tz4+m-200),dx4,dy4);
          putletter(20,20,255,st(tx)+' '+st(ty));
          volpoly(dx,dy,dx2,dy2,dx3,dy3,dx4,dy4,color);
       end

       { * draw rectangle *}
       else if (linetype=5) then begin
          setpoints((tx),(ty),(tz+m),dx,dy);
          { use the larger squares for terrain modelling }
          {bar(dx,dy,dx+5+(m div 20),dy+5+(m div 20),color);}

          { this was for detail modeling }
          bar(dx,dy,dx+2,dy+2,color);
       end

       { * draw control net * }
       else if (linetype=10) then begin
          pset(x,y,color);
       end;


       { explosion }
        if p<>pbeg
         then
          begin
          if motion=true then begin  { send the pieces flying off }
            { only show the smaller pieces }
          setpoints((tx),(ty),(tz+m),dx,dy);
          setpoints((tx2),(ty2),(tz2+m),dx2,dy2);

               { this is swarm motion acc to velocity }
               if x>avgx then vx:=vx-1 else if x<avgx then vx:=vx+1;
               if y>avgy then vy:=vy-1 else if x<avgy then vy:=vy+1;
               if z>avgz then vz:=vz-1 else if z<avgz then vz:=vz+1;

               { this is swarm motion acc to position }
               {if x>avgx then x:=x-1 else if x<avgx then x:=x+1;
               if y>avgy then y:=y-1 else if x<avgy then y:=y+1;
               if z>avgz then z:=z-1 else if z<avgz then z:=z+1;}

               { this is simple explosion motion }
               x:=x+vx;
               y:=y+vy;
               z:=z+vz;
               {x2:=x2+vx;
               y2:=y2+vy;
               z2:=z2+vz;}

               { this is to destroy timed out particles }
               timeout:=timeout-1;  if timeout<1 then hide:=true;
            end;
          end;
       end;  {timeout}
       p := p^.next;

      end;
end;


procedure getmouse3d;
begin

  getmouse(butn,mx,my);

  if (butn=0) and (mx<214)
    then r := (r+1)mod 256
    else
     if (butn=0) and (mx>350)
       then r := (r+255)mod 256;

         if np[4,2] and (xv>-300)
    then dec(xv,5)
    else
      if np[6,2] and (xv<300)
        then inc(xv,5);
  if np[4,1] and (m>-200)
    then dec(m,5)
    else
      if np[6,1] and (m<135)
        then inc(m,5);
  if np[8,2] and (yv>-300)
    then dec(yv,5)
    else
      if np[2,2] and (yv<300)
        then inc(yv,5);

  {left or right}
  if (mx<214) and (xv>-300)
    then begin
      dec(xv,5);
      dir:=4;
    end
    else
      if (mx>350) and (xv<300)
        then begin
          inc(xv,5);
          dir:=2;
        end

  {up or down}
  else if (butn=0) and (my<65) and (yv>-300)
    then begin
      dec(m,5);
      dir:=3;
    end
    else
      if (butn=0) and (my>130) and (yv<300)
        then begin
        dir:=1;
      end
  else dir:=0;

  {in or out}
  if (my<65)
    then inc(m,10)
    else
      if (my>130)
        then dec(m,10);

  { jump is amount to move sprites }
  if dir=1 then         inc(yv,jump)
     else if dir=2 then inc(xv,jump)
     else if dir=3 then dec(yv,jump)
     else if dir=4 then dec(xv,jump);
end;

procedure getkey;
begin
  if space then nettolist;

  if tab then explode;

  if plus
    then r := (r+1)mod 256
    else
     if minus
       then r := (r+255)mod 256;

  {left or right}
  if np[4,2] {and (xv>-300)}
    then begin
      dir:=4;
    end
    else
      if np[6,2] {and (xv<300)}
        then begin
          dir:=2;
        end

  {up or down}
  else if np[8,2] {and (yv>-300)}
    then begin
      dir:=3;
    end
    else
      if np[2,2] {and (yv<300)}
        then begin
        dir:=1;
      end
  else dir:=0;

  {in or out}
  if np[4,1] {and (m>-200) }
    then dec(m,5)
    else
      if np[6,1] {and (m<135)}
        then inc(m,5);
  if np[1,1] then inc(q,5) else
     if np[3,1] then inc(q,5);

  { jump is amount to move sprites }
  if dir=1 then begin
    inc(xrot,jump);
    {if (xrot>360) then xrot:=xrot-360;}
  end
     else if dir=2 then begin
       inc(yrot,jump);
       {if (yrot>360) then yrot:=yrot-360;}
     end
       else if dir=3 then begin
         dec(xrot,jump);
         {if (xrot<0) then xrot:=360+xrot;}
       end
          else if dir=4 then begin
            dec(yrot,jump);
            {if (yrot<0) then yrot:=360+yrot;}
          end;
end;

procedure automove;
begin
  timeo:=timeo-1;
  if timeo=0 then explode;
  if (timeo mod 10) =0 then dir:=4;
  {if timeo mod 10 =0 then inc(xrot,jump);}

  if timeo mod 8 =0 then inc(m,5);

  { jump is amount to move sprites }
  if dir=1 then begin
    inc(xrot,jump);
    {if (xrot>360) then xrot:=xrot-360;}
  end
     else if dir=2 then begin
       inc(yrot,jump);
       {if (yrot>360) then yrot:=yrot-360;}
     end
       else if dir=3 then begin
         dec(xrot,jump);
         {if (xrot<0) then xrot:=360+xrot;}
       end
          else if dir=4 then begin
            dec(yrot,jump);
            {if (yrot<0) then yrot:=360+yrot;}
          end;

end;

{
procedure drawsurface(color: integer;
          arx,ary,arz : array[1..10] of ptarray);
var  l,l2                          : integer;
     oldptx, oldpty, oldptz        : integer;
begin
  for l:=1 to 10 do begin
     oldptx:=arx[1];
     oldpty:=ary[1];
     oldptz:=arz[1];
     for l2:=1 to 10 do begin
       line3d(oldptx,oldpty,oldptz,
              arx[l2],ary[l2],arz[l2],color,true);
    arx[l],ary[l],arz[l]);
  end;
end;
}

procedure drawall(draw:boolean);
begin
  pcopy(3,2);
  {CopyRect(recx1,recy1,recx2,recy2,pages[3]^,pages[2]^);}
  setpageactive(2);
  transformlist;
  calcaverage;
  {rangecheckall;}
  {getmouse(butn,mx,my);}
  {if butn=1 then mousepresslist(mx div skl,my)
     else drawcrosshairs(mx div skl,my,255);}
end;

procedure Animate3d;
begin
  zv := 300; m := 0; r := 0; q:=0;
  repeat
    {getmouse3d;}
    {getkey;}
    automove;
    drawall(true);
    {dispmapsurf  (138,31,0, 145,33,4, 152,35,4, 158,37,0,
            136,49,0, 141,50,6, 146,52,6, 160,53,0,
            135,67,0, 144,67,8, 155,69,8, 161,69,0,
            134,80,0, 143,80,10, 151,80,10, 162,80,0,
            30,20,12);}
    {drawnet;}
    pcopy(2,1);
    {CopyRect(recx1,recy1,recx2,recy2,pages[2]^,pages[1]^);}
  until (timeo=-20) or space;
end;

(**) { tpoint methods }
constructor tpoint.init(ltype: byte;
            nx,ny,nz,
            nx2,ny2,nz2,
            nx3,ny3,nz3,
            nx4,ny4,nz4,
            c:integer);
begin
  linetype:=ltype;
  x := nx; y := ny; z := nz; color:=c;
  x2 := nx2; y2 := ny2; z2 := nz2;
  x3:=nx3; y3:=ny3; z3:=nz3;
  x4:=nx4; y4:=ny4; z4:=nz4;
  vx:=random(4)-2; vy:=random(4)-2; vz:=random(4)-2;
  timeout:=random(20)+1;
  motion:=false;
  hide:=false;
end;

procedure setup;
var loop  : integer;
begin
  timeo:=150;
  openmode(3);
  {checkmouseerr;}
  {mouseon;} { turn on mouse if available }
  oldexit := exitproc; exitproc := @cleanup;
  xrot:=0; yrot:=0; zrot:=0;
  m:=-40;
  { make 3d objects }
  {makesurface;}
  loadmaps;
  {twodimto3d(windx1,windx2,windy1,windy2,2);}
  {setupnet;}
  {makenpts(145,85,255);}

  { bezier surface stats }

  {mapsurf (78,80,0, 135,80,30, 192,80,30, 249,80,0,
           78,104,0, 135,104,30, 192,104,30, 249,104,0,
           78,128,0, 135,128,30, 192,128,30, 249,128,0,
           78,152,0, 135,152,30, 192,152,30, 249,152,0,
           191,10,5);}

  mapsurf (84,86,0, 137,86,30, 190,86,30, 244,86,0,
           84,89,0, 137,89,30, 190,89,30, 244,89,0,
           84,92,0, 137,92,30, 190,92,30, 244,92,0,
           84,95,0, 137,95,30, 190,95,30, 244,95,20,
           190,10,5);

{  mapsurf  (172,103,0, 180,111,0, 188,109,0, 197,103,0,
            173,117,10, 181,172,10, 180,128,10, 199,118,10,
            173,131,20, 182,133,20, 192,137,20, 201,133,20,
            173,144,0, 183,145,0, 193,146,0, 204,147,0,
            60,20,6);}


  {makeaxis;}
  {makepoly(10,10,5,40,10,3,40,40,3,10,40,5,200);}
  setpageactive(3); cls(0);  { hide color map }

end;


begin
  setup;
  Animate3d;
end.