/*
   This is my first tutorial, is a starfield demo write in DJGPP C,
   the source is completly free, and everyone can modify my project

   Sorry for My english, I'm Italian ! :-)

   mailto: lanet2@mbox.lanet.it

   Bignotti Alberto
*/

#include <sys/nearptr.h>
#include <go32.h>
#include <dos.h>
#include <stdlib.h>

#define VGA             0x013
#define TEXT            0x03

#define STARS 100    // number of stars

#define PALETTE_MASK        0x3c6
#define PALETTE_WR          0x3c8
#define PALETTE_DATA        0x3c9

//the body of stars
struct str{
			short int x;
         short int y;
         unsigned char z;     // z position, color, velocity
         short int ox;        // old x
         short int oy;        // old y
         } star[STARS];

typedef struct rgb_color_type {
	unsigned char red;
	unsigned char green;
	unsigned char blue;
} rgb;

char *video_buffer = (char *)0xa0000;

void set_video_mode(int mode)
{
        union REGS regs;
        regs.x.ax = mode;
        int86(0x10, &regs, &regs);
}

// far put_pixel
void put_pixel(short int x, short int y, char color)
{
	_farpokeb(_dos_ds,video_buffer + (y << 8) + (y << 6) + x, color);
}

// set the color 'color' in register 'index' ('color' is rgb type)
void set_color(unsigned char index, rgb *color)
{
        outportb(PALETTE_MASK,0xff);
        outportb(PALETTE_WR,index);
        outportb(PALETTE_DATA,color->red);
        outportb(PALETTE_DATA,color->green);
        outportb(PALETTE_DATA,color->blue);
}

// wait for vertical retrace
void vsync(void)
{
        while (inportb(0x3da) & 0x08); // vga is in retrace
        while (!(inportb(0x3da) & 0x08)); // wait for start of retrace
}

// make the 4 colors of the stars
void make_colors()
{
   rgb black =   { 0,   0,  0 }; // black
   rgb white =   { 63, 63, 63 }; // white
   rgb dk_grey = { 16, 16, 16 }; // dark grey
   rgb grey  =   { 32, 32, 32 }; // grey

   set_color(0,&black);          // color 0
   set_color(1,&dk_grey);        // color 1
   set_color(2,&grey);           // color 2
   set_color(3,&white);          // color 3
}

// fils the array 'star' with the caratteristics of the stars
void make_str()
{
int i;
   make_colors();
	for (i=0;i<STARS;i++)
   {
      star[i].x=rand()%320;          // x -> random value
      star[i].y=rand()%200;          // y -> random value
      star[i].ox=star[i].x;          // ox -> x
      star[i].oy=star[i].y;          // oy -> y
      star[i].z=rand()%3+1;          // z -> random value (1 or 2 or 3)
   }
}

// show the stars on the screen
void show_str()
{
int i;
short int x,y;
unsigned char color;
	for (i=0;i<STARS;i++)
   {
      x=star[i].ox;y=star[i].oy;
      put_pixel(x,y,0);   // erase the stars at the old position
   }
   vsync();

	for (i=0;i<STARS;i++)
   {
      x=star[i].x;y=star[i].y;
      color=star[i].z;
      put_pixel(x,y,color); //show the stars on the new position
   }
}

// refresh the stars (move stars)
void move_str()
{
int i;
	for (i=0;i<STARS;i++)
   {
      star[i].ox=star[i].x;                     //refresh the old x
      star[i].oy=star[i].y;                     //refresh the old y
      // for the orizzontal traslation
   	star[i].x+=star[i].z;                     //refresh the x
      if(star[i].x>319)star[i].x-=319;          //if it go out make it in

      // for the vertical traslation
//   	star[i].y+=star[i].z;
//    if(star[i].y>199)star[i].y-=199;
   }
}

void main()
{
int i;
short int x,y;
unsigned char color;

    set_video_mode(VGA);

   make_str();
   do
   {
     	show_str();
   	move_str();
      delay(30);
   }
	while(!kbhit());

   set_video_mode(TEXT);
}
