#include "svga.hh"
#include <dos.h> //REGS...
#include <mem.h> //memcpy...

SVGA::SVGA(void)
{
	screenBase = (unsigned char*)0xA0000; //Video memory start address
	activePage = 0;
	height = 0;
	width = 0;
}

SVGA::~SVGA(void)
{
}

unsigned char SVGA::SetResolution(char theMode)
{
	union REGS r;

	switch(theMode)
	{
		case 0:	r.x.eax = 0x0003;
			int386(0x10, &r, &r); //Set text mode
			height = 0;
			width = 0;
			return 1;
			break;

		case 1:	r.w.bx = 0x0101; //640x480
			height = 480;
			width = 640;
			break;

		case 2:	r.w.bx = 0x0103; //800x600
			height = 600;
			width = 800;
			break;

		case 3:	r.w.bx = 0x0105; //1024x768
			height = 768;
			width = 1024;
			break;

		case 4:	r.w.bx = 0x0107; //1024x1024
			height = 1024;
			width = 1024;
			break;
	}

	r.h.ah = 0x4F;
	r.h.al = 2;

	int386(0x10, &r, &r);

	//Before we start, work out how many pages are required, and how many bytes
	//are needed in the last page.
	nrOfPages = (width * height) / 65536;
	lastPage = (width * height) - (nrOfPages * 65536);

	if (r.h.ah == 0)
		return(1); //Fine!
	else
		return(0); //Do not support the resolution
}

short int SVGA::GetWidth(void)
{
	return width;
}

short int SVGA::GetHeight(void)
{
	return height;
}

void SVGA::ClearScreen(unsigned char theColor)
{
	short int j = 0; //Our counter

	//update the screen
	while(j < nrOfPages)
	{
		this->SetPage(j++);
		memset(screenBase,theColor,65536);
	}

	if (lastPage != 0)
	{
		this->SetPage(j);
		memset(screenBase,theColor,lastPage);
	}
}

//Bank sizes requires many pages to fill up the whole screen.
//Set active page (bank) on screen
void SVGA::SetPage(short int thePage)
{
	union REGS r;

	r.h.ah = 0x4F;
	r.h.al = 5;
	r.w.bx = 0;
	r.w.dx = thePage;

	int386(0x10, &r, &r);

	activePage = thePage; //Set the current active page
}

//Find out what page (bank) to start with depending on the x and y values
short int SVGA::GetPage(short int x, short int y)
{
	return ((y * width + x) / 65536);
}

void SVGA::PutPixel(short int x, short int y, unsigned char color)
{
	short int page = this->GetPage(x,y); //Find the correct start page

	if(page != activePage) //Do we want to use the active page?
		this->SetPage(page); //If not, switch bank
	y = y - (page * (65536/width)); //Find the correct y-pos on screen
	x = x - (page * (65536 % width)); //Find correct x-pos
	screenBase[y * width + x] = color; //Put the sucker on the screen
}

unsigned char SVGA::GetPixel(short int x, short int y)
{
	short int page = this->GetPage(x,y); //Find the correct start page

	if(page != activePage) //Do we want to use the active page?
		this->SetPage(page); //If not, switch bank
	y = y - (page * (65536/width)); //Find the correct y-pos on screen
	x = x - (page * (65536 % width)); //Find correct x-pos
	return screenBase[y * width + x]; //Get the sucker from the screen
}
