#include "svga.hh"
#include <dos.h> //REGS...
#include <mem.h> //memcpy...

SVGA::SVGA(void)
{
        screenBase = (unsigned char*)0xA0000;
        offsetX = 0;
        offsetY = 0;
	activePage = 0;
	height = 0;
	width = 0;
	rowY = 0;
}

SVGA::~SVGA(void)
{
	if(rowY != 0)
		delete rowY; //Delete our pre-calculated row list
        if(offsetX != 0)
                delete offsetX;
        if(offsetY != 0)
                delete offsetY;
}

unsigned char SVGA::SetResolution(char theMode)
{
	union REGS r;

	switch(theMode)
	{
		case 0:	r.x.eax = 0x0003;
			int386(0x10, &r, &r); //Set text mode
			height = 0;
			width = 0;
			return 1;
			break;

		case 1:	r.w.bx = 0x0101; //640x480
			height = 480;
			width = 640;
			break;

		case 2:	r.w.bx = 0x0103; //800x600
			height = 600;
			width = 800;
			break;

		case 3:	r.w.bx = 0x0105; //1024x768
			height = 768;
			width = 1024;
			break;

		case 4:	r.w.bx = 0x0107; //1024x1024
			height = 1024;
			width = 1024;
			break;
	}

	r.h.ah = 0x4F;
	r.h.al = 2;

	int386(0x10, &r, &r);

	// Before we start, work out how many pages are required, and how many bytes
	//	are needed in the last page.
	nrOfPages = (width * height) / 65536;
	lastPage = (width * height) - (nrOfPages * 65536);

        rowY = new int[height];

	//Pre-calculate the offsets of the rows used in current resolution
	for(int i = 0;i < height;i++)
		rowY[i] = i * width;

        offsetX = new int[nrOfPages + 1]; //+1 is for an eventual last page not equal to the bank size
        //Pre-calculate new x-offsets, because of bank switching
        for(int j = 0;j < nrOfPages + 1; j++)
                offsetX[j] = (j * (65536 % width));

        offsetY = new int[nrOfPages + 1];
        //Pre-calculate new y-offsets, because of bank switching
        for(int k = 0;k < nrOfPages + 1; k++)
                offsetY[k] = (k * (65536 / width));

	if (r.h.ah == 0)
		return(1); //Fine!
	else
		return(0); //Do not support the resolution
}

short int SVGA::GetWidth(void)
{
	return width;
}

short int SVGA::GetHeight(void)
{
	return height;
}

void SVGA::ClearScreen(unsigned char theColor)
{
	short int j = 0; //Our counter

	while(j < nrOfPages)
	{
		this->SetPage(j++);
		memset(screenBase,theColor,65536);
	}

	if (lastPage != 0)
	{
		this->SetPage(j);
		memset(screenBase,theColor,lastPage);
	}
}

//Bank sizes requires many pages to fill up the whole screen.
//Set active page (bank) on screen
void SVGA::SetPage(short int thePage)
{
	union REGS r;

	r.h.ah = 0x4F;
	r.h.al = 5;
	r.w.bx = 0;
	r.w.dx = thePage;

	int386(0x10, &r, &r);

	activePage = thePage; //Set the current active page
}

void SVGA::PutPixel(short int x, short int y, unsigned char color)
{
        //Find out what page (bank) to start with depending on the x and y values
	//Same as: page = ((y * width + x) / 65536)
	short int page = ((*(rowY+y) + x) >> 16); //Find the correct start page

	if(page != activePage) //Do we want to use the active page?
		this->SetPage(page); //If not, switch bank

        //Same as: y = y - (page * (65536 / width));
        y = y - *(offsetY + page); //Find the correct y-pos on screen

        //Same as: x = x - (page * (65536 % width));
        x = x - *(offsetX + page); //Find the correct x-pos on screen

	*(screenBase + *(rowY+y) + x) = color; //Put the sucker on the screen
}

unsigned char SVGA::GetPixel(short int x, short int y)
{
        //Find out what page (bank) to start with depending on the x and y values
	//Same as: page = ((y * width + x) / 65536)
	short int page = ((*(rowY+y) + x) >> 16); //Find the correct start page

	if(page != activePage) //Do we want to use the active page?
		this->SetPage(page); //If not, switch bank

        //Same as: y = y - (page * (65536 / width));
        y = y - *(offsetY + page); //Find the correct y-pos on screen

        //Same as: x = x - (page * (65536 % width));
        x = x - *(offsetX + page); //Find the correct x-pos on screen

	return *(screenBase + (*(rowY+y)) + x); //Get the sucker from the screen
}
