// Copyright 1996 by Janne Lf
#ifndef FBUFFER_H
#define FBUFFER_H


#define TEXMAP_SIZEX	64	// texture map width
#define	TEXMAP_SIZEY	64	// texture map height

struct XYPoint {
	int x,y;
};

class FrameBuffer {
	struct Edge {
		int x,tx,ty;
	};

	int	sizex,sizey,size;
	unsigned char	*fbuf;
	Edge		*fwd;
	Edge		*bwd;

	// interpolate edge->x values form point a to point b, a.y must be greater than b.y
	void scanedge(Edge *edge, const XYPoint  &a, const XYPoint  &b);
	// interpolate edge values form point a to point b, a.y must be greater than b.y
	void scanedge(Edge *edge, const XYPoint  &a, const XYPoint  &b, const XYPoint &ta, const XYPoint &tb);

	// draw a solid horizontal line
	void hline(unsigned char *dst, const Edge &min, const Edge &max, int color);
	// draw a textured horizontal line
	void hline(unsigned char *dst, const Edge &min, const Edge &max, const unsigned char *bmap);

public:
	int SizeX() const { return sizex; }		// width of framebuffer in pixels
	int SizeY() const { return sizey; }		// height of framebuffer in pixels

	// write a pixel to framebuffer
	void WritePixel(const XYPoint &p, int color);

	// fill ambient polygon
	void FillPoly(const XYPoint  *point, int cnt, int color);

	// fill textured polygon
	void FillPoly(const XYPoint  *point, const XYPoint *tex_point, int cnt, const unsigned char *bmap);

	void Clear(int color = 0);
	void Show(int x, int y);

	 FrameBuffer(int w, int h);
	~FrameBuffer();
};


#endif
