// Copyright 1996 by Janne Lf
#include <stdio.h>
#include <stdlib.h>
#include <vga.h>

#include "view.h"

#define VGAMODE	G320x200x256

void loadbitmap(const char *filename, void *buf)
{
    FILE *f;
    void *bufp;
    if (!(f = fopen(filename, "rb"))) {
        printf("error: can't open file '%s'.\n", filename);
        exit(1);
    }
    
    bufp = buf;
    for (;;) {
	int count = fread(bufp, 1, 8192, f);
	if (count == 0)
	    break;
	if (feof(f))
	    break;
	bufp += count;
    }
    fclose(f);
}
void setcustompalette(void)
{
    /* colors 0-31 are an RGB mix (bits 0 and 1 red, 2 green, 3 and 4 blue) */
    /* 32-63    black to red */
    /* 64-95    black to green */
    /* 96-127   black to yellow */
    /* 128-159  black to blue */
    /* 160-191  black to magenta */
    /* 192-223  black to cyan */
    /* 224-255  black to white */
    int i;
    for (i = 0; i < 256; i++) {
	int r, g, b;
	r = g = b = 0;
	if ((i & 32) > 0)
	    r = (i & 31) << 1;
	if ((i & 64) > 0)
	    g = (i & 31) << 1;
	if ((i & 128) > 0)
	    b = (i & 31) << 1;
	if (i < 32) {
	    r = (i & 3) << 4;	/* 2 bits */
	    g = (i & 4) << 3;	/* 1 bit */
	    b = (i & 24) << 1;	/* 2 bits */
	}
	vga_setpalette(i, r, g, b);
    }
}

#define LOGONAME	"logo.bmp"
#define LOGOWIDTH	201
#define LOGOHEIGHT	85
unsigned char bitmap[TEXMAP_SIZEX*TEXMAP_SIZEY];
unsigned char logobitmap[LOGOWIDTH*LOGOHEIGHT];
void loadtexture()
{
	// Create bitmap
	loadbitmap(LOGONAME, logobitmap);
	// scale it to right size
	for (int y=0; y<TEXMAP_SIZEY; y++) {
		for (int x=0; x<TEXMAP_SIZEX; x++) {
			bitmap[x+y*TEXMAP_SIZEX] = logobitmap[ ((x*LOGOWIDTH)/TEXMAP_SIZEX) + ((y*LOGOHEIGHT)/TEXMAP_SIZEY)*LOGOWIDTH ];
		}
	}
}


void help()
{
	printf("Textured polygon test by Janne Lf\n");
	printf(" runtime commands:\n");
	printf("  q       quit\n");
	printf("  t       texture map on/off\n");
	printf("  w       waitretrace on/off\n");
	printf("press return to continue:\n");
	getchar();
}


int main()
{
	help();
	vga_init();
	vga_setmode(VGAMODE);
	setcustompalette();
	loadtexture();

	FrameBuffer fb(vga_getxdim()*2/3,vga_getydim()*2/3);
	View	view(fb);

	XYPoint	 t[4];
	t[0].x =              0; t[0].y =              0;
	t[1].x = TEXMAP_SIZEX-1; t[1].y =              0;
	t[2].x = TEXMAP_SIZEX-1; t[2].y = TEXMAP_SIZEY-1;
	t[3].x =              0; t[3].y = TEXMAP_SIZEY-1;

	vector	v[4];
	v[0].x() = -500; v[0].y() = -500; v[0].z() = 0;
	v[1].x() =  500; v[1].y() = -500; v[1].z() = 0;
	v[2].x() =  500; v[2].y() =  500; v[2].z() = 0;
	v[3].x() = -500; v[3].y() =  500; v[3].z() = 0;

	double a = 0;
	double b = 0;
	bool texmapped = true;
	bool waitretrace = true;
	bool running = true;
	while (running) {
		XYPoint p[4];
		for (int i=0; i<4; i++) {
			view.Project(p[i], rotY(a) * rotZ(b) * v[i] + vector(0,0,-1500) );
		}
		a += PI/90;
		b += PI/95;

		fb.Clear(1);
		if (texmapped)
			fb.FillPoly(p, t, 4, bitmap);
		else
			fb.FillPoly(p, 4, 2);

		if (waitretrace)
			vga_waitretrace();
		fb.Show((vga_getxdim()-fb.SizeX())/2, (vga_getydim()-fb.SizeY())/2);

		switch (vga_getkey()) {
		case 'q':
			running = false;
			break;
		 case 't':
		 	texmapped = !texmapped;
			break;
		 case 'w':
		 	waitretrace = !waitretrace;
		 	break;
		}
	}
	vga_setmode(TEXT);
	return 0;
}
