// Copyright 1996 by Janne Lf
#ifndef MATRIX_H
#define MATRIX_H
#pragma interface

#include "vector.h"

extern class matrix unit;
extern class matrix zero;

class matrix {
	vector m[3];
public:

	inline matrix operator*(const matrix &b) const;
	inline matrix operator+(const matrix &b) const;
	inline matrix operator-(const matrix &b) const;
	inline matrix operator-() const;

	inline matrix operator/(const double d) const;
	inline matrix operator*(const double d) const;
	inline vector operator*(const vector &v) const;

	inline matrix T() const;

	      vector &operator[](const int i)       { return m[i]; }
	const vector &operator[](const int i) const { return m[i]; }

	matrix &operator=(const matrix &b) { m = b.m; return *this; }

	matrix(const matrix &b):m(b.m)  { }
	matrix(	const double a11, const double a12, const double a13,
		const double a21, const double a22, const double a23,
		const double a31, const double a32, const double a33)
	{
		m[0][0]=a11; m[0][1]=a12; m[0][2]=a13;
		m[1][0]=a21; m[1][1]=a22; m[1][2]=a23;
		m[2][0]=a31; m[2][1]=a32; m[2][2]=a33;
	}
	 matrix() {}
	~matrix() {}
};

inline matrix matrix::operator*(const matrix &b) const return r
{
	for (int i=0; i<3; i++)
		for (int j=0; j<3; j++) {
			r[i][j] = m[i][0]*b[0][j]+
				  m[i][1]*b[1][j]+
				  m[i][2]*b[2][j];
		}
}

inline matrix matrix::operator+(const matrix &b) const return r
{
	r[0] = m[0]+b[0];
	r[1] = m[1]+b[1];
	r[2] = m[2]+b[2];
}
inline matrix matrix::operator-(const matrix &b) const return r
{
	r[0] = m[0]-b[0];
	r[1] = m[1]-b[1];
	r[2] = m[2]-b[2];
}
inline matrix matrix::operator-() const return r
{
	r[0] = -m[0];
	r[1] = -m[1];
	r[2] = -m[2];
}


// scalar
inline matrix operator*(const double d, const matrix &a) return r
{
	r[0] = a[0]*d;
	r[1] = a[1]*d;
	r[2] = a[2]*d;
}
inline matrix matrix::operator/(const double d) const return r
{
	r[0] = m[0]/d;
	r[1] = m[1]/d;
	r[2] = m[2]/d;
}
inline matrix matrix::operator*(const double d) const return r
{
	r[0] = m[0]*d;
	r[1] = m[1]*d;
	r[2] = m[2]*d;
}
inline vector matrix::operator*(const vector &v) const return r
{
	r[0] = dotprod(m[0],v);
	r[1] = dotprod(m[1],v);
	r[2] = dotprod(m[2],v);
}

// other
inline matrix matrix::T() const return r
{
	r[0][0] = m[0][0];
	r[0][1] = m[1][0];
	r[0][2] = m[2][0];

	r[1][0] = m[0][1];
	r[1][1] = m[1][1];
	r[1][2] = m[2][1];

	r[2][0] = m[0][2];
	r[2][1] = m[1][2];
	r[2][2] = m[2][2];
}

// non member

inline double det(const matrix &b)
{
	return
	  b[0][0]*b[1][1]*b[2][2]
	+ b[0][1]*b[1][2]*b[2][0]
	+ b[0][2]*b[1][0]*b[2][1]
	- b[0][2]*b[1][1]*b[2][0]
	- b[0][0]*b[1][2]*b[2][1]
	- b[0][1]*b[1][0]*b[2][2];
}

inline matrix rotX(const double theta)
{
	const double c = cos(theta);
	const double s = sin(theta);
	return matrix(	 1, 0, 0,
			 0, c, s,
			 0,-s, c);
}
inline matrix rotY(const double theta)
{
	const double c = cos(theta);
	const double s = sin(theta);
	return matrix(	 c, 0,-s,
			 0, 1, 0,
			 s, 0, c);
}
inline matrix rotZ(const double theta)
{
	const double c = cos(theta);
	const double s = sin(theta);
	return matrix(	 c, s, 0,
			-s, c, 0,
			 0, 0, 1);
}
inline matrix scale(const vector &s)
{
	return matrix(s[0],   0,  0,
			 0,s[1],  0,
		   	 0,   0,s[2]);
}




#endif
