// Copyright 1996 by Janne Lf
#ifndef VECTOR_H
#define VECTOR_H
#pragma interface

#include <math.h>

class vector {
	double v[3];
public:

	inline double &x() { return v[0]; }
	inline double &y() { return v[1]; }
	inline double &z() { return v[2]; }
	inline const double &x() const { return v[0]; }
	inline const double &y() const { return v[1]; }
	inline const double &z() const { return v[2]; }

	inline vector operator+(const vector &a) const;
	inline vector operator-(const vector &a) const;
	inline vector operator-() const;

	inline vector operator%(const vector &a) const;	// cross
	inline double operator*(const vector &a) const;	// dot

	inline vector operator*(const double d) const;
	inline vector operator/(const double d) const;

	inline vector &operator+=(const vector &a);
	inline vector &operator-=(const vector &a);
	inline vector &operator*=(const double d);
	inline vector &operator/=(const double d);

	      double &operator[](const int i)       { return v[i]; }
	const double &operator[](const int i) const { return v[i]; }

	inline bool operator==(const vector &a) const;
	inline bool operator!=(const vector &a) const;

	vector &operator=(const vector &a)
	{
		v[0] = a.v[0];
		v[1] = a.v[1];
		v[2] = a.v[2];
		return *this;
	}
	 vector(const double X, const double Y, const double Z) { v[0]=X; v[1]=Y; v[2]=Z; }
	 vector(const vector &a)
	 {
	 	v[0] = a.v[0];
	 	v[1] = a.v[1];
		v[2] = a.v[2];
	 }
	 vector() {}
	~vector() {}
};

inline vector vector::operator+(const vector &a) const return r
{
	r[0] = v[0] + a[0];
	r[1] = v[1] + a[1];
	r[2] = v[2] + a[2];
}
inline vector vector::operator-(const vector &a) const return r
{
	r[0] = v[0] - a[0];
	r[1] = v[1] - a[1];
	r[2] = v[2] - a[2];
}
inline vector vector::operator-() const return r
{
	r[0] = -v[0];
	r[1] = -v[1];
	r[2] = -v[2];
}
inline vector vector::operator%(const vector &a) const return r
{
	r[0] = v[1] * a[2] - v[2] * a[1];
	r[1] = v[2] * a[0] - v[0] * a[2];
	r[2] = v[0] * a[1] - v[1] * a[0];
}
inline double vector::operator*(const vector &a) const
{
	return v[0]*a[0] + v[1]*a[1] + v[2]*a[2];
}
inline vector vector::operator*(const double d) const return r
{
	r[0] = v[0] * d;
	r[1] = v[1] * d;
	r[2] = v[2] * d;
}
inline vector vector::operator/(const double d) const return r
{
	r[0] = v[0] / d;
	r[1] = v[1] / d;
	r[2] = v[2] / d;
}

inline vector &vector::operator+=(const vector &a)
{
	v[0] += a[0];
	v[1] += a[1];
	v[2] += a[2];
	return *this;
}
inline vector &vector::operator-=(const vector &a)
{
	v[0] -= a[0];
	v[1] -= a[1];
	v[2] -= a[2];
	return *this;
}
inline vector &vector::operator*=(const double d)
{
	v[0] *= d;
	v[1] *= d;
	v[2] *= d;
	return *this;
}
inline vector &vector::operator/=(const double d)
{
	v[0] /= d;
	v[1] /= d;
	v[2] /= d;
	return *this;
}
inline bool vector::operator==(const vector &a) const
{
	return v[0]==a[0] && v[1]==a[1] && v[2]==a[2];
}

inline bool vector::operator!=(const vector &a) const
{
	return v[0]!=a[0] || v[1]!=a[1] || v[2]!=a[2];
}

inline vector operator*(const double d, const vector &a)
{
	return a*d;
}


inline vector cross(const vector &a, const vector &b) return r
{
	r[0] = a[1] * b[2] - a[2] * b[1];
	r[1] = a[2] * b[0] - a[0] * b[2];
	r[2] = a[0] * b[1] - a[1] * b[0];
}
inline double dotprod(const vector &a, const vector &b)
{
	return	a[0]*b[0] + a[1]*b[1] + a[2]*b[2];
}
inline double mod(const vector &a)
{
	return sqrt(a[0]*a[0] + a[1]*a[1] + a[2]*a[2]);
}



#endif

