#include "vga.h"
#include <pc.h>
#include <dpmi.h>
#include <go32.h>
#include <sys/movedata.h>


int	initialized = 0;
int	vga_sizex = 0;
int	vga_sizey = 0;
int	vga_colors = 0;

int vga_init()
{
	if (initialized) return -1;
	return 0;
}

int vga_setmode(int mode)
{
	__dpmi_regs r;

	if (!initialized)
		vga_init();

	switch (mode) {
	 case TEXT:
		r.x.ax = 0x3;
		vga_sizex = 80;
		vga_sizey = 25;
		vga_colors = 0;
		break;
	 case G320x200x256:
		r.x.ax = 0x13;
		vga_sizex = 320;
		vga_sizey = 200;
		vga_colors = 256;
		break;
	  default:
		return -1;
	}
	__dpmi_int(0x10,&r);
	return 0;
}
int vga_hasmode(int mode)
{
	switch (mode) {
	 case TEXT:
	 case G320x200x256:
		return 1;
	 default:
		return 0;
	}
}

int vga_getxdim(void)
{
	return vga_sizex;
}

int vga_getydim(void)
{
	return vga_sizey;
}

int vga_getcolors(void)
{
	return vga_colors;
}

int vga_setpalette(int i, int r, int g, int b)
{
	int j;
	outportb(0x3c8, i); for (j=0; j<10; j++);
	outportb(0x3c9, r); for (j=0; j<10; j++);
	outportb(0x3c9, g); for (j=0; j<10; j++);
	outportb(0x3c9, b);
	return 0;
}

void vga_waitretrace(void)
{
	while (!(inportb(0x3da) & 8));
	while ( (inportb(0x3da) & 8));
}
int vga_drawscansegment(unsigned char *colors, int x, int y, int length)
{
	movedata(_my_ds(), (int)colors, _dos_ds, 0xa0000 + x + y*vga_sizex, length);
	return 0;
}

int vga_getkey(void)
{
	if (kbhit())
		return getkey();
	else
		return 0;
}

int vga_getch(void)
{
	return getkey();
}
