#ifndef VGA_H
#define VGA_H

#if defined __cplusplus
extern "C" {
#endif

#define TEXT	     0
#define G320x200x16  1
#define G640x200x16  2
#define G640x350x16  3
#define G640x480x16  4
#define G320x200x256 5
#define G320x240x256 6
#define G320x400x256 7
#define G360x480x256 8
#define G640x480x2   9

int vga_setmode(int mode);
int vga_hasmode(int mode);
int vga_getxdim(void);
int vga_getydim(void);
int vga_setpalette(int index, int red, int green, int blue);
int vga_drawscansegment(unsigned char *colors, int x, int y, int length);
void vga_waitretrace(void);

int vga_init();
int vga_getkey();
int vga_getch();

#if defined __cplusplus
}
#endif

#endif

