// Copyright 1996 by Janne Lf
#ifndef VIEW_H
#define VIEW_H

#include <math.h>
#include "vector.h"
#include "matrix.h"
#include "fbuffer.h"

#define	DEFAULT_FOV	0.8

class View {
public:
	FrameBuffer	&fb;			// frame buffer
	vector		pos;			// eye position
	matrix		rot;			// eye rotation
	double		xscale,yscale;		// 3D -> 2D perspective scalings

	void Project(XYPoint &xypoint, const vector &point) const	// worldspace -> viewspace -> window transformation
	{
		vector v = rot * ( point - pos );
		const double zrecip = 1.0 / point.z();
		xypoint.x = int( fb.SizeX()/2 + v.x() * zrecip * xscale );
		xypoint.y = int( fb.SizeY()/2 - v.y() * zrecip * yscale );
	}

	 View(FrameBuffer &_fb);
	~View();
};

#endif
