/*    --- triplas.cpp ---
  A variation on the original plasma algorithm by Bret Mulvey.
  Copyright (c) 1995 David Johnston

  Last modified March 1st, 1995.

    The Story: I got sick and tired of the plain old plasma, because it
  always introduced artifacts into its creation in the form of virticle
  and horizontal definition lines.  This was especially apparent when
  the plasma screen was projected three dimentionally.  So I decided to
  write a plasma based on a triangle, in stead of the traditional
  rectangle.  Here is the end product.  I hope you like it :)

    This program was written for Turbo C++ v3.0.  With little modification
  it should compile all right under other compilers.  It should compile
  flawlessly under Borland C++.
*/

#include <dos.h>
#include <stdlib.h>
#include <conio.h>
#include <math.h>
#include <mem.h>

#define INITWIDTH 300
#define INITHEIGHT 199
#define F 2.0
#define xadj (width/2)
#define yadj (height/2)
#define round(q) ((long)(q)+0.5)

REGPACK r;
unsigned char far *veep=(unsigned char far *)MK_FP(0xa000,0);

//----------------------------------------------------------------------------

void setpalette(unsigned char *p)
{
  unsigned o=FP_OFF(p),s=FP_SEG(p);
  r.r_ax=0x1012;
  r.r_bx=0;
  r.r_cx=256;
  r.r_dx=o;
  r.r_es=s;
  intr(0x10,&r);
}

//----------------------------------------------------------------------------

inline unsigned char getpixel(int x, int y)
{
  return veep[x+y*320];
}

//----------------------------------------------------------------------------

inline void setpixel(int x, int y,unsigned char c)
{
  if(!getpixel(x,y))
    veep[x+y*320]=c;
}

//----------------------------------------------------------------------------

inline void adjust(float x1,float y1,float x2,float y2)
{
  float color,c;
  int a,b;
  a=getpixel(round(x1),round(y1));
  b=getpixel(round(x2),round(y2));
  color=(a+b)/2+
    ((((float)random(32000))/32000.0)-0.5)*F*sqrt(pow(x2-x1,2)+pow(y2-y1,2));
  a=(int)(color-0.5);
  if (a<1) a=1;
  if (a>192) a=191;
  setpixel(round(x1+(x2-x1)/2),round(y1+(y2-y1)/2),a);
}

//----------------------------------------------------------------------------

void subdivide(float topx, float topy, float height, float width,
               unsigned char flag)
{
  if(width<1.0 && height<1.0) return;
  adjust(topx,topy,topx+xadj,topy+height);
  adjust(topx,topy,topx-xadj,topy+height);
  adjust(topx-xadj,topy+height,topx+xadj,topy+height);
  subdivide(topx,topy,height/2,width/2,flag);
  subdivide(topx-xadj/2,topy+yadj,height/2,width/2,flag);
  subdivide(topx+xadj/2,topy+yadj,height/2,width/2,flag);
  subdivide(topx,topy+height,-height/2,width/2,flag^1);
}

//----------------------------------------------------------------------------

void rotatepalette(unsigned char p[][3])
{
  movmem(p[1],p[2],192*3);
  p[1][0]=p[193][0];
  p[1][1]=p[193][1];
  p[1][2]=p[193][2];
  setpalette(&p[0][0]);
}

//===========================================================================

void main()
{
  unsigned char p[256][3];
  int x,y;
  float width,height;

  r.r_ax=0x13;
  intr(0x10,&r);

  p[0][0]=0;
  p[0][1]=0;
  p[0][2]=0;

  for (x=0;x<64;x++)
  {
    p[x+1][0]=0;      p[x+1][1]=x;      p[x+1][2]=63-x;
    p[x+65][0]=x;     p[x+65][1]=63-x;  p[x+65][2]=0;
    p[x+129][0]=63-x; p[x+129][1]=0;    p[x+129][2]=x;
  }
  setpalette(&p[0][0]);

  randomize();
  setpixel(160, 0,          0);
  setpixel(160+INITWIDTH/2, INITHEIGHT, 64);
  setpixel(160-INITWIDTH/2,  INITHEIGHT, 128);

  subdivide(160,0,INITHEIGHT,INITWIDTH,0);
  while(!kbhit())
    rotatepalette(p);
  getch();
  r.r_ax=0x13;
  intr(0x10,&r);
}

