/****************************************************************
** UCF.H
**
** Universal Configuration File (UCF) Library Version 0.2 header file
**
**  Copyright (C) 1999 Blint Balogh <balintb@iname.com>
**
**  This library is free software; you can redistribute it and/or modify it
**  under the terms of the GNU Library General Public License as published by
**  the Free Software Foundation; either version 2 of the License, or (at
**  your option) any later version.
**
**  This library is distributed in the hope that it will be useful, but
**  WITHOUT ANY WARRANTY; without even the implied warranty of
**  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
**  Library General Public License for more details.
**
**  You should have received a copy of the GNU Library General Public License
**  along with this library (the file "COPYING.LIB"); if not, write to the
**  Free Software Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
**/

#ifndef __UCF_H__
#define __UCF_H__

#include <stdio.h>

#ifdef __cplusplus
    extern "C" {
#endif

typedef enum
{
    UCFTempty=0,
    UCFTint=1,      /* UCFTint and UCFTfloat are the same, except ... */
    UCFTfloat=2,    /* ... in their representation in UCFVariable */
    UCFTnum=3,
    UCFTstring=4,
    UCFTblock=8
} UCFType;

struct __UCFVariable__;

typedef struct __UCFBlock__
{
    unsigned int FieldNum;
    struct __UCFVariable__ *Fields;
    unsigned int ArraySize;
    struct __UCFBlock__ *Parent;
} UCFBlock;

typedef struct
{
    UCFType Type;
    union
    {
        long int intv;
        double floatv;
        char *stringv;
        UCFBlock blockv;
    } v;
} UCFValue;

typedef struct __UCFVariable__
{
    char *ID;
    UCFValue V;
} UCFVariable;

typedef struct
{
    UCFBlock Vars;
    UCFBlock *Current;
} UCFContext;

typedef struct
{
    UCFBlock *Block;
    unsigned int Index;
} UCFFNContext;

void InitUCFContext( UCFContext *C );
int QuitUCFContext( UCFContext *C );
int GetUCFVariable( UCFContext *C, const char *ID, UCFValue *V );
int ChangeUCFVariable( UCFContext *C, const char *ID, UCFValue *V );
int ConvertUCFValueToString( UCFValue *V );
int UCFCreateBlock( UCFContext *C, const char *ID );
int UCFSelectBlock( UCFContext *C, const char *ID );
int UCFSelectBlockForce( UCFContext *C, const char *ID );
int UCFSelectParent( UCFContext *C );
int UCFSelectRoot( UCFContext *C);
unsigned int UCFNumberOfFields( UCFContext *C );
int InitFindUCFVariable( UCFContext *C, UCFFNContext *N );
int FindNextUCFVariable( UCFContext *C, UCFFNContext *N, char **ID,
    UCFValue *V );
int UCFReadConfigFile( UCFContext *C, FILE *F );

#ifdef __cplusplus
    } /* extern "C" */
#endif

#endif /* __UCF_H__ */

