UNIT ANSI;

INTERFACE

 CONST
   Black=0;      Gray=8;
   Red=1;        LightRed=9;
   Green=2;      LightGreen=10;
   Brown=3;      Yellow=11;
   Blue=4;       LightBlue=12;
   Magenta=5;    Pink=13;
   Cyan=6;       LightCyan=14;
   LightGray=7;  White=15;

 VAR
   TClr,SClr:BYTE;

 PROCEDURE GotoPos(X,Y:INTEGER);
 PROCEDURE CursorUp(Nr:INTEGER);
 PROCEDURE CursorDown(Nr:INTEGER);
 PROCEDURE CursorRight(Nr:INTEGER);
 PROCEDURE CursorLeft(Nr:INTEGER);
 PROCEDURE SavePosition;
 PROCEDURE RestorePosition;
 PROCEDURE ClearScreen;
 PROCEDURE EraseLine;
 PROCEDURE ScreenMode(Int:INTEGER);
 PROCEDURE ReverseVideo;
 PROCEDURE BlinkingText;
 PROCEDURE IntenseText;
 PROCEDURE DefaultVideo;
 PROCEDURE ConcealedVideo;
 PROCEDURE SetColor(Fore,Back:INTEGER);
 PROCEDURE TextColor(Fore:INTEGER);
 PROCEDURE ScreenColor(Back:INTEGER);
 PROCEDURE Mode80x50;
 PROCEDURE UseIntense;
 PROCEDURE SetBorder(Color:BYTE);

IMPLEMENTATION

 PROCEDURE GotoPos(X,Y:INTEGER);
  BEGIN
    WRITE('[',Y,';',X,'H');
  END;

 PROCEDURE CursorUp(Nr:INTEGER);
  BEGIN
    WRITE('[',Nr,'A');
  END;

 PROCEDURE CursorDown(Nr:INTEGER);
  BEGIN
    WRITE('[',Nr,'B');
  END;

 PROCEDURE CursorRight(Nr:INTEGER);
  BEGIN
    WRITE('[',Nr,'C');
  END;

 PROCEDURE CursorLeft(Nr:INTEGER);
  BEGIN
    WRITE('[',Nr,'D');
  END;

 PROCEDURE SavePosition;
  BEGIN
    WRITE('[s');
  END;

 PROCEDURE RestorePosition;
  BEGIN
    WRITE('[u');
  END;

 PROCEDURE ClearScreen;
  BEGIN
    WRITE('[2J');
  END;

 PROCEDURE EraseLine;
  BEGIN
    WRITE('[K');
  END;

 PROCEDURE ScreenMode(Int:INTEGER);
  BEGIN
    WRITE('[=',Int,'h');
  END;

 PROCEDURE ReverseVideo;
  BEGIN
    WRITE('[7m');
  END;
 
 PROCEDURE BlinkingText;
  BEGIN
    WRITE('[5m');
  END;
 
 PROCEDURE IntenseText;
  BEGIN
    WRITE('[1m');
  END;
  
 PROCEDURE DefaultVideo;
  BEGIN
    WRITE('[0m');
  END;

 PROCEDURE ConcealedVideo;
  BEGIN
    WRITE('[8m');
  END;

 PROCEDURE SetColor(Fore,Back:INTEGER);
  VAR
   S,T:STRING;
  BEGIN
    TClr:=Fore; SClr:=Back;
    T:='[0';
    IF (Fore>=8) AND (Fore<16) THEN
     BEGIN Str((22+Fore):0,S); T:=T+';1;'+S; END;
    IF (Fore>=0) AND (Fore<=7) THEN
     BEGIN Str((30+Fore):0,S); T:=T+';'+S; END;
    IF (Back>=0) AND (Back<=7) THEN
     BEGIN Str((40+Back):0,S); T:=T+';'+S; END;
    IF (Back>=8) AND (Back<16) THEN
     BEGIN Str((32+Back):0,S); T:=T+';5;'+S; END;
    T:=T+'m'; WRITE(T);
  END;
 PROCEDURE TextColor(Fore:INTEGER);
  BEGIN
    SetColor(Fore,SClr);
  END;

 PROCEDURE ScreenColor(Back:INTEGER);
  BEGIN
    SetColor(TClr,Back);
  END;

 PROCEDURE Mode80x50;
  BEGIN
    INLINE(184/2/18/179/48/205/16/184/3/0/205/16/184/18/17/179/0/205/16/184/18/17/179/0/205/16/184/0/76);
  END;

 PROCEDURE UseIntense;
  BEGIN
     ASM
       MOV AL,$10
       MOV DX,$03D9
       OUT DX,AL
       MOV AX,$1003
       MOV BL,$0
       INT $10
     END;
  END;

 PROCEDURE SetBorder(Color:BYTE);
  BEGIN
     ASM
       MOV AH,$0B
       MOV BX,$0F
       AND BL,Color
       INT $10
     END;
  END;

BEGIN
END.
