UNIT EgaDraw;

INTERFACE

CONST   Ega640x350=000; Black  =0; DarkGray  = 8; Buttons   =004;
        Ega640x200=001; Blue   =1; LightBlue = 9; Horizontal=003;
        Ega320x200=002; Green  =2; LightGreen=10; Vertical  =002;
	Vga640x480=003; Cyan   =3; LightCyan =11; Keyboard  =001;
        Unknown   =255; Red    =4; LightRed  =12; NoEvent   =000;
        CapsLock  =064; Magenta=5; Pink      =13; ON        =TRUE;
        NumLock   =032; Brown  =6; Yellow    =14; OFF       =FALSE;
        ScrollLock=016; Gray   =7; White     =15;
        Toggle    =002; Light  =1; Dark      = 0;

TYPE    Button=OBJECT
          Xa,Ya,Xb,Yb:WORD; Fg,Bg,Hl,Sd:BYTE; Title,Oldtt:STRING; Paa:BOOLEAN;
          PROCEDURE Draw;
          PROCEDURE Remove;
          PROCEDURE Init(Ax,Ay,Bx,By:WORD; F,B,H,S:BYTE; T:STRING);
          FUNCTION  Pressed:BOOLEAN;
          FUNCTION  Switched:BOOLEAN;
        END;

	Window=OBJECT
	  Xa,Ya,Xb,Yb,Xl,Yl:INTEGER; Fg,Bg,Hl,Sd,Sc:BYTE; Title:STRING; Seen:BOOLEAN;
          PROCEDURE Draw;
          PROCEDURE Remove;
          PROCEDURE Init(A,B,C,D:WORD; E,F,G,H:BYTE; I:STRING; J:BYTE);
          PROCEDURE WriteLine(A,B:WORD; C:STRING);
          PROCEDURE Line(A,B,C,D,E:INTEGER);
          PROCEDURE SetPix(X,Y:WORD; C:BYTE);
          FUNCTION  GetPix(X,Y:WORD):BYTE;
	  FUNCTION  Test:BOOLEAN;
        END;

VAR     Colors,Mode,TheEvent,ScanCode,Fh:BYTE;
        xMax,yMax,Video,Mb,Mx,My	:WORD;
        Sound                           :BOOLEAN;
        MousePtr                        :ARRAY[0..33] OF WORD;

{---------------------------------------------------------------------------}
PROCEDURE Klick(F,L:WORD);
PROCEDURE BackToText;
FUNCTION  CurKey:CHAR;
FUNCTION  GetKey:CHAR;
FUNCTION  Event:BOOLEAN;
FUNCTION  KeyPressed:BOOLEAN;
PROCEDURE DefLed(Led,Mtd:BYTE);
{---------------------------------------------------------------------------}
PROCEDURE EgaMode(Md:BYTE);
FUNCTION  GetPix(X,Y:WORD):BYTE;
PROCEDURE SetPix(X,Y:WORD; Color:BYTE);
PROCEDURE Clear(Color:BYTE);
PROCEDURE Line(X1,Y1,X2,Y2:INTEGER; Col:BYTE);
PROCEDURE Hline(Xa,Xb,Y:WORD; Color:BYTE);
PROCEDURE Vline(Ya,Yb,X:WORD; Color:BYTE);
PROCEDURE FBox(Xa,Ya,Xb,Yb:WORD; Color:BYTE);
PROCEDURE Box(Xa,Ya,Xb,Yb:WORD; Color:BYTE);
{---------------------------------------------------------------------------}
PROCEDURE InitMouseIntr;
PROCEDURE EndMouseIntr;
FUNCTION  MouseReset:BOOLEAN;
PROCEDURE Mouse(Vs:BOOLEAN);
PROCEDURE SaveMouse;
PROCEDURE RestoreMouse;
PROCEDURE SetMousePos(X,Y:WORD);
PROCEDURE SetMousePtr;
PROCEDURE Arrow;
PROCEDURE Waiting;
{---------------------------------------------------------------------------}
PROCEDURE UseFont(Ptr:POINTER);
PROCEDURE PlotChar(X,Y:INTEGER; Ch:BYTE; Color,Bg:BYTE);
PROCEDURE DrawChar(X,Y:INTEGER; Ch:BYTE; Color:BYTE);
PROCEDURE WriteLine(X,Y:INTEGER; S:STRING; C,B:BYTE);

IMPLEMENTATION

USES      Dos;
VAR       OldInt1C:PROCEDURE;
          SaveVs,Visible:BOOLEAN;

FUNCTION  CurKey:CHAR; ASSEMBLER;
 ASM
        MOV     AX,$0040
        MOV     ES,AX
        MOV     AX,$0000
        MOV     BX,ES:[$001A]
        CMP     BX,ES:[$001C]
        JE      @Slt
        MOV     AX,ES:[BX]
        MOV     ScanCode,AH
@Slt:
 END;

FUNCTION  GetKey:CHAR; ASSEMBLER;
 ASM
        MOV     AX,$0040
        MOV     ES,AX
        MOV     AX,$0000
        MOV     BX,ES:[$001A]
        CMP     BX,ES:[$001C]
        JE      @Vdr
        MOV     AX,ES:[BX]
        MOV     ScanCode,AH
@Vdr:   CMP     BX,ES:[$0082]
        JE      @Spc
        INC     BX
        INC     BX
        JMP     @Slt
@Spc:   MOV     BX,ES:[$0080]
@Slt:   MOV     ES:[$001A],BX
 END;

PROCEDURE DefLed(Led,Mtd:BYTE); ASSEMBLER;
 ASM
        MOV     AX,$0040
        MOV     ES,AX
        MOV     AH,Led
        CMP     Mtd,0
        JE      @Tgl
        CMP     Mtd,1
        JE      @On
        NOT     AH
        AND     ES:[$0017],AH
        JMP     @Slt
@On:    OR      ES:[$0017],AH
        JMP     @Slt
@Tgl:   XOR     ES:[$0017],AH
        JMP     @Slt
@Slt:   MOV     AH,1
        INT     $16
 END;

PROCEDURE Klick(F,L:WORD); ASSEMBLER;
 ASM
	CMP	Sound,ON
	JNE	@End
	IN      AL,$61
	OR      AL,3
	OUT     $61,AL
	MOV     AL,182
	OUT     $43,AL
	MOV     AX,F
	NOT     AX
	SHR     AX,2
	OUT     $42,AL
	MOV     AL,AH
	OUT     $42,AL
	MOV     AX,L
@oop1:  MOV     BX,1020
@oop2:  DEC     BX
	CMP     BX,0
	JNE     @oop2
	DEC     AX
	CMP     AX,0
	JNE     @oop1
	IN      AL,$61
	AND     AL,252
	OUT     $61,AL
@End:
 END;

PROCEDURE BackToText; ASSEMBLER;
 ASM
          MOV     AX,$0003
          INT     $10
 END;


FUNCTION  KeyPressed:BOOLEAN; ASSEMBLER;
 ASM
          MOV     AX,$0040
          MOV     ES,AX
          MOV     AL,$00
          MOV     BX,ES:[$001A]
          CMP     BX,ES:[$001C]
          JE      @Slt
          MOV     AL,$FF
@Slt:
 END;

FUNCTION  Event:BOOLEAN; ASSEMBLER;
 ASM
          MOV     AX,$3
          INT     $33
          MOV     AX,$0040            { Keybuffer empty?    }
          MOV     ES,AX
          MOV     AL,TRUE             { Return TRUE exiting }
          MOV     BX,ES:[$001A]
          MOV     TheEvent,KeyBoard
          CMP     BX,ES:[$001C]
          JNE     @Slt
          MOV     TheEvent,Buttons
          CMP     Mb,0                { Buttons pressed?    }
          JNE     @Slt
          PUSH    CX                  { Get Mouse Data      }
          PUSH    DX
          MOV     AX,$3
          INT     $33
          POP     BX
          POP     AX
          MOV     TheEvent,Horizontal
          CMP     CX,AX               { Has Mx changed?     }
          JNE     @Slt
          MOV     TheEvent,Vertical
          CMP     DX,BX               { Has My changed?     }
          JNE     @Slt
          MOV     AL,FALSE            { No, return FALSE    }
          MOV     TheEvent,NoEvent
@Slt:
 END;

{---------------------------------------------------------------------------}

PROCEDURE EgaMode(Md:BYTE); ASSEMBLER;
 ASM
          MOV     AL,Md
          CMP     AL,Mode
          JE      @Slutt
	  CMP     Md,Vga640x480
          JE	  @480
          CMP     Md,Ega640x350
          JE      @350
          CMP     Md,Ega640x200
          JE      @200
          CMP     Md,Ega320x200
          JE      @320
          JMP     @Slutt
@480:     MOV     Colors,15
          MOV     xMax,639
          MOV     yMax,479
          MOV     Video,$A000
          MOV     Mode,AL
          MOV     AX,$0012
          INT     $10
          JMP     @Slutt
@350:     MOV     Colors,15
          MOV     xMax,639
          MOV     yMax,349
          MOV     Video,$A000
          MOV     Mode,AL
          MOV     AX,$0010
          INT     $10
          JMP     @Slutt
@200:     MOV     Colors,15
          MOV     xMax,639
          MOV     yMax,199
          MOV     Video,$A000
          MOV     Mode,AL
          MOV     AX,$000E
          INT     $10
          JMP     @Slutt
@320:     MOV     Colors,15
          MOV     xMax,319
          MOV     yMax,199
          MOV     Video,$A000
          MOV     Mode,AL
          MOV     AX,$000D
          INT     $10
          JMP     @Slutt
@Slutt:
 END;


FUNCTION  GetPix(X,Y:WORD):BYTE; ASSEMBLER;
 ASM;
          MOV     AX,Y
          MOV     DX,80
          CMP     Mode,Ega320x200
          JNE     @Next
          MOV     DX,40
@Next:    MUL     DX
          MOV     SI,X
          MOV     CX,SI
          SHR     SI,3
          ADD     SI,AX
          AND     CL,7
          XOR     CL,7
          MOV     CH,1
          SHL     CH,CL
          MOV     AX,Video
          MOV     ES,AX
          MOV     DX,$3Ce
          MOV     AX,(3 SHL 8)+4
          XOR     BL,BL
@gp1:     OUT     DX,AX
          MOV     BH,ES:[SI]
          AND     BH,CH
          NEG     BH
          ROL     BX,1
          DEC     AH
          JGE     @gp1
          MOV     AL,BL
 END;

PROCEDURE SetPix(X,Y:WORD; Color:BYTE); ASSEMBLER;
 ASM
          MOV     CH,Color
          MOV     AX,Y
          MOV     DX,80
          CMP     Mode,Ega320x200
          JNE     @Next
          MOV     DX,40
@Next:    MUL     DX
          MOV     BX,X
          MOV     CL,BL
          SHR     BX,3
          ADD     BX,AX
          AND     CL,7
          MOV     AH,128
          SHR     AH,CL
          MOV     DX,$3CE
          MOV     AL,8
          OUT     DX,AX
          MOV     AX,$0205
          OUT     DX,AX
          MOV     AX,Video
          MOV     ES,AX
          MOV     AL,ES:[BX]
          MOV     ES:[BX],CH
 END;

PROCEDURE Line(X1,Y1,X2,Y2:INTEGER; Col:BYTE);
 VAR D,Dx,Dy,Ai,Bi,Xi,Yi,X,Y:INTEGER;
 BEGIN                          
   IF (ABS(X2-X1)<ABS(Y2-Y1)) THEN
    BEGIN
     IF Y1>Y2 THEN
      ASM
          MOV     AX,Y1
          MOV     BX,Y2
          MOV     Y1,BX
          MOV     Y2,AX
          MOV     AX,X1
          MOV     BX,X2
          MOV     X1,BX
          MOV     X2,AX
      END;
      IF (X2>X1) THEN Xi:=1 ELSE Xi:=-1;
      Dy:=Y2-Y1; Dx:=ABS(X2-X1); D:=Dx*2-Dy; Ai:=2*(Dx-Dy);
      Bi:=Dx*2; X:=X1; Y:=Y1;
      IF (X>=0) AND (Y>=0) AND (X<=xMax) AND (Y<=yMax) THEN SetPix(X,Y,Col);
      FOR Y:=Y1+1 TO Y2 DO
       BEGIN
         IF (D>=0) THEN
          ASM
            MOV AX,X
            ADD AX,Xi
            MOV X,AX
            MOV AX,D
            ADD AX,Ai
            MOV D,AX
          END ELSE ASM
            MOV AX,D
            ADD AX,Bi
            MOV D,AX
          END;
         IF (X>=0) AND (Y>=0) AND (X<=xMax) AND (Y<=yMax) THEN SetPix(X,Y,Col);
       END;
    END ELSE BEGIN             
      IF (X1>X2) THEN
       ASM
         MOV AX,X1
         MOV BX,X2
         MOV X1,BX
         MOV X2,AX
         MOV AX,Y1
         MOV BX,Y2
         MOV Y1,BX
         MOV Y2,AX
       END;
      IF (Y2>Y1) THEN Yi:=1 ELSE Yi:=-1;
      Dx:=X2-X1; Dy:=ABS(Y2-Y1); D:=Dy*2-Dx; Ai:=2*(Dy-Dx);
      Bi:=Dy*2; X:=X1; Y:=Y1;
      IF (X>=0) AND (Y>=0) AND (X<=xMax) AND (Y<=yMax) THEN SetPix(X,Y,Col);
      FOR X:=X1+1 TO X2 DO
       BEGIN
         IF (D>=0) THEN
          ASM
            MOV AX,Y
            ADD AX,Yi
            MOV Y,AX
            MOV AX,D
            ADD AX,Ai
            MOV D,AX
          END ELSE ASM
            MOV AX,D
            ADD AX,Bi
            MOV D,AX
          END;
         IF (X>=0) AND (Y>=0) AND (X<=xMax) AND (Y<=yMax) THEN SetPix(X,Y,Col);
       END;                     
    END;                        
 END;                           

PROCEDURE Hline(Xa,Xb,Y:WORD; Color:BYTE); ASSEMBLER;
ASM
          MOV     AX,Video
          MOV     ES,AX
          MOV     SI,Xa
          MOV     AX,Xb
          MOV     BX,Y
          MOV     CH,Color
@Loop:    PUSHA
          MOV     AX,BX
          MOV     DX,80
          CMP     Mode,Ega320x200
          JNE     @Next
          MOV     DX,40
@Next:    MUL     DX
          MOV     BX,SI
          MOV     CL,BL
          SHR     BX,3
          ADD     BX,AX
          AND     CL,7
          MOV     AH,128
          SHR     AH,CL
          MOV     DX,$3CE
          MOV     AL,8
          OUT     DX,AX
          MOV     AX,$0205
          OUT     DX,AX
          MOV     AL,ES:[BX]
          MOV     ES:[BX],CH
          POPA
          INC     SI
          CMP     SI,AX
          JLE     @Loop
END;

PROCEDURE Vline(Ya,Yb,X:WORD; Color:BYTE); ASSEMBLER;
ASM
          MOV     AX,Video
          MOV     ES,AX
          MOV     SI,X
          MOV     BX,Ya
          MOV     DX,Yb
          MOV     CH,Color
@Loop:    PUSHA
          MOV     AX,BX
          MOV     DX,80
          CMP     Mode,Ega320x200
          JNE     @Next
          MOV     DX,40
@Next:    MUL     DX
          MOV     BX,SI
          MOV     CL,BL
          SHR     BX,3
          ADD     BX,AX
          AND     CL,7
          MOV     AH,128
          SHR     AH,CL
          MOV     DX,$3CE
          MOV     AL,8
          OUT     DX,AX
          MOV     AX,$0205
          OUT     DX,AX
          MOV     AL,ES:[BX]
          MOV     ES:[BX],CH
          POPA
          INC     BX
          CMP     BX,DX
          JLE     @Loop
END;

PROCEDURE FBox(Xa,Ya,Xb,Yb:WORD; Color:BYTE); ASSEMBLER;
 ASM
          MOV     AX,Video
          MOV     ES,AX
          MOV     SI,Xa
          MOV     AX,Xb
          MOV     BX,Ya
          MOV     DX,Yb
          MOV     CH,Color
@Loop:    PUSHA
          MOV     AX,BX
          MOV     DX,80
          CMP     Mode,Ega320x200
          JNE     @Next
          MOV     DX,40
@Next:    MUL     DX
          MOV     BX,SI
          MOV     CL,BL
          SHR     BX,3
          ADD     BX,AX
          AND     CL,7
          MOV     AH,128
          SHR     AH,CL
          MOV     DX,$3CE
          MOV     AL,8
          OUT     DX,AX
          MOV     AX,$0205
          OUT     DX,AX
          MOV     AL,ES:[BX]
          MOV     ES:[BX],CH
          POPA
          INC     SI
          CMP     SI,AX
          JLE     @Loop
          MOV     SI,Xa
          INC     BX
          CMP     BX,DX
          JLE     @Loop
 END;

PROCEDURE Clear(Color:BYTE);
 BEGIN
   FBox(0,0,xMax,yMax,Color);
 END;

PROCEDURE Box(Xa,Ya,Xb,Yb:WORD; Color:BYTE);
 BEGIN
   Hline(Xa,Xb,Ya,Color); Hline(Xa,Xb,Yb,Color);
   Vline(Ya,Yb,Xa,Color); Vline(Ya,Yb,Xb,Color);
 END;

{---------------------------------------------------------------------------}

PROCEDURE MouseInterrupt; INTERRUPT; ASSEMBLER;
 ASM
          MOV     AX,$3
          INT     $33
          CMP     Mode,Ega320x200
          JNE     @Next
          SHR     CX,1
@Next:    MOV     Mb,BX
          MOV     Mx,CX
          MOV     My,DX
          PUSHF
 END;

PROCEDURE InitMouseIntr;
 BEGIN
   GetIntVec($1C,@OldInt1C);
   SetIntVec($1C,Addr(MouseInterrupt));
 END;

PROCEDURE EndMouseIntr;
 BEGIN
   SetIntVec($1C,@OldInt1C);
 END;

FUNCTION  MouseReset:BOOLEAN; ASSEMBLER;
 ASM
          MOV     AX,$0000
          INT     $33
          CMP     AX,$0000
          JE      @False
          MOV     AL,TRUE
          JMP     @TheEnd
@False:   MOV     AL,FALSE
@TheEnd:
 END;

PROCEDURE Mouse(Vs:BOOLEAN); ASSEMBLER;
 ASM
          MOV     BL,Vs
          CMP     BL,Visible
          JE      @TheEnd
          MOV     Visible,BL
          MOV     AX,$0001
          CMP     Vs,ON
          JE      @SetCrs
          MOV     AX,$0002
@SetCrs:  INT     $33
@TheEnd:
 END;

PROCEDURE SaveMouse; ASSEMBLER;
 ASM
          CMP     SaveVs,ON
          JE      @TheEnd
          MOV     BL,Visible
          MOV     SaveVs,BL
          MOV     Visible,OFF
          MOV     AX,$0002
          INT     $33
@TheEnd:
 END;

PROCEDURE RestoreMouse; ASSEMBLER;
 ASM
          MOV     AX,$0001
          CMP     SaveVs,ON
          JE      @SetCrs
          MOV     AX,$0002
@SetCrs:  INT     $33
          MOV     AL,SaveVs
          MOV     Visible,AL
          MOV     SaveVs,OFF
 END;

PROCEDURE SetMousePos(X,Y:WORD); ASSEMBLER;
 ASM
          MOV     AX,$0004
          MOV     CX,X
          MOV     DX,Y
          INT     $33
 END;

PROCEDURE SetMousePtr; ASSEMBLER;
 ASM
          MOV     AX,SEG MousePtr
          MOV     ES,AX
          MOV     SI,OFFSET MousePtr
          MOV     BX,ES:[SI]
          MOV     CX,ES:[SI+2]
          ADD     SI,4
          MOV     DX,SI
          MOV     AX,$0009
          INT     $33
 END;

PROCEDURE Waiting; ASSEMBLER;
 ASM
          MOV     AX,SEG MousePtr
          MOV     ES,AX
          MOV     DI,OFFSET MousePtr
          MOV     AX,0000000000000000b; STOSW
          MOV     AX,0000000000000000b; STOSW

          MOV     AX,1111100000111111b; STOSW
          MOV     AX,1110000000001111b; STOSW
          MOV     AX,1100000000000111b; STOSW
          MOV     AX,1000000000000011b; STOSW
          MOV     AX,1000000000000011b; STOSW
          MOV     AX,0000000000000001b; STOSW
          MOV     AX,0000000000000001b; STOSW
          MOV     AX,0000000000000001b; STOSW
          MOV     AX,0000000000000001b; STOSW
          MOV     AX,0000000000000001b; STOSW
          MOV     AX,1000000000000011b; STOSW
          MOV     AX,1000000000000011b; STOSW
          MOV     AX,1100000000000111b; STOSW
          MOV     AX,1110000000001111b; STOSW
          MOV     AX,1111100000111111b; STOSW
          MOV     AX,1111111111111111b; STOSW

          MOV     AX,0000000000000000b; STOSW
          MOV     AX,0000011011000000b; STOSW
          MOV     AX,0001011111010000b; STOSW
          MOV     AX,0011111011111000b; STOSW
          MOV     AX,0011111011111000b; STOSW
          MOV     AX,0101111011110100b; STOSW
          MOV     AX,0111111011111100b; STOSW
          MOV     AX,0011110000011000b; STOSW
          MOV     AX,0111111011111100b; STOSW
          MOV     AX,0101111111110100b; STOSW
          MOV     AX,0011111111111000b; STOSW
          MOV     AX,0011111111111000b; STOSW
          MOV     AX,0001011111010000b; STOSW
          MOV     AX,0000011011000000b; STOSW
          MOV     AX,0000000000000000b; STOSW
          MOV     AX,0000000000000000b; STOSW
 END;

PROCEDURE Arrow; ASSEMBLER;
 ASM
          MOV     AX,SEG MousePtr
          MOV     ES,AX
          MOV     DI,OFFSET MousePtr
          MOV     AX,0000000000000000b; STOSW
          MOV     AX,0000000000000000b; STOSW

          MOV     AX,0011111111111111b; STOSW { oo           }
          MOV     AX,0101111111111111b; STOSW { o o          }
          MOV     AX,0110111111111111b; STOSW { o  o         }
          MOV     AX,0111011111111111b; STOSW { o   o        }
          MOV     AX,0111101111111111b; STOSW { o    o       }
          MOV     AX,0111110111111111b; STOSW { o     o      }
          MOV     AX,0111111011111111b; STOSW { o      o     }
          MOV     AX,0111111101111111b; STOSW { o       o    }
          MOV     AX,0111111110111111b; STOSW { o        o   }
          MOV     AX,0111110000011111b; STOSW { o     ooooo  }
          MOV     AX,0110110111111111b; STOSW { o  o  o      }
          MOV     AX,0101011011111111b; STOSW { o o o  o     }
          MOV     AX,0011011011111111b; STOSW { oo  o  o     }
          MOV     AX,1111101101111111b; STOSW {      o  o    }
          MOV     AX,1111101101111111b; STOSW {      o  o    }
          MOV     AX,1111110001111111b; STOSW {       ooo    }

          MOV     AX,0000000000000000b; STOSW
          MOV     AX,0100000000000000b; STOSW
          MOV     AX,0110000000000000b; STOSW
          MOV     AX,0111000000000000b; STOSW
          MOV     AX,0111100000000000b; STOSW
          MOV     AX,0111110000000000b; STOSW
          MOV     AX,0111111000000000b; STOSW
          MOV     AX,0111111100000000b; STOSW
          MOV     AX,0111111110000000b; STOSW
          MOV     AX,0111110000000000b; STOSW
          MOV     AX,0110110000000000b; STOSW
          MOV     AX,0100011000000000b; STOSW
          MOV     AX,0000011000000000b; STOSW
          MOV     AX,0000001100000000b; STOSW
          MOV     AX,0000001100000000b; STOSW
          MOV     AX,0000000000000000b; STOSW
 END;

{---------------------------------------------------------------------------}

VAR Fs,Fo:WORD; 

PROCEDURE UseFont(Ptr:POINTER);
 BEGIN
   Fs:=SEG(Ptr^); Fo:=OFS(Ptr^)+1; Fh:=MEM[Fs:Fo-1];
 END;

PROCEDURE PlotChar(X,Y:INTEGER; Ch:BYTE; Color,Bg:BYTE);
 VAR T,U:BYTE;
 BEGIN
   IF (X<0) OR (Y<0) OR (X>xMax-8) OR (Y>yMax-Fh) THEN Exit;
   FOR T:=0 TO 7 DO FOR U:=0 TO Fh-1 DO
   IF MEM[Fs:Fo+Ch*Fh+U] AND  (128 SHR (T AND 7))=(128 SHR (T AND 7))
      THEN SetPix(X+T,Y+U,Color) ELSE SetPix(X+T,Y+U,Bg);
 END;

PROCEDURE DrawChar(X,Y:INTEGER; Ch:BYTE; Color:BYTE);
 VAR T,U:BYTE;
 BEGIN
   IF (X<0) OR (Y<0) OR (X>xMax-8) OR (Y>yMax-Fh) THEN Exit;
   FOR T:=0 TO 7 DO FOR U:=0 TO Fh-1 DO
   IF MEM[Fs:Fo+Ch*Fh+U] AND  (128 SHR (T AND 7))=(128 SHR (T AND 7))
      THEN SetPix(X+T,Y+U,Color);
 END;

PROCEDURE WriteLine(X,Y:INTEGER; S:STRING; C,B:BYTE);
 VAR T:BYTE;
 BEGIN                                          
   FOR T:=1 TO LENGTH(S) DO
    IF C=B THEN DrawChar(X+(T-1)*8,Y,ORD(S[T]),C  )
           ELSE PlotChar(X+(T-1)*8,Y,ORD(S[T]),C,B);
 END;

{---------------------------------------------------------------------------}

PROCEDURE Button.Draw;
 VAR A,B:BYTE;
 BEGIN
   SaveMouse;
   IF Paa THEN BEGIN A:=Fg; Fg:=Sd; B:=Hl; Hl:=Sd; Sd:=B; END;
   Box(Xa,Ya,Xb,Yb,0);
   HLine(Xa+1,Xb-2,Ya+1,Hl); VLine(Ya+1,Yb-1,Xa+1,Hl);
   HLine(Xa+2,Xb-1,Yb-1,Sd); VLine(Ya+1,Yb-1,Xb-1,Sd);
   HLine(Xa+2,Xb-3,Ya+2,Hl); VLine(Ya+2,Yb-2,Xa+2,Hl);
   HLine(Xa+3,Xb-2,Yb-2,Sd); VLine(Ya+2,Yb-2,Xb-2,Sd);
   IF Oldtt<>Title THEN
    BEGIN FBox(Xa+3,Ya+3,Xb-3,Yb-3,Bg); Oldtt:=Title; END;
   WriteLine(Xa+1+(Xb-Xa-LENGTH(Title)*8) DIV 2
            ,Ya+1+((Yb-Ya) DIV 2)-Fh DIV 2,Title,Fg,Fg);
   IF Paa THEN BEGIN Fg:=A; Sd:=Hl; Hl:=B; END; RestoreMouse;
 END;

PROCEDURE Button.Remove;
 BEGIN SaveMouse; FBox(Xa,Ya,Xb,Yb,Bg); RestoreMouse; END;

PROCEDURE Button.Init(Ax,Ay,Bx,By:WORD; F,B,H,S:BYTE; T:STRING);
 BEGIN
   Xa:=Ax; Ya:=Ay; Xb:=Bx; Yb:=By; Paa:=OFF; Oldtt:='';
   Fg:=F;  Bg:=B;  Hl:=H;  Sd:=S; Title:=T;
 END;

FUNCTION  Button.Pressed:BOOLEAN;
 BEGIN
   Pressed:=FALSE;
   IF Mb=0 THEN Exit;
   IF (Mx>=Xa) AND (My>=Ya) AND (Mx<=Xb) AND (My<=Yb) THEN
    BEGIN
      Klick(100,10); Paa:=NOT Paa; Draw;
      REPEAT UNTIL Mb=0; Pressed:=TRUE;
      Klick(100,10); Paa:=NOT Paa; Draw;
    END;
 END;

FUNCTION  Button.Switched:BOOLEAN;
 BEGIN
   Switched:=FALSE;
   IF Mb=0 THEN Exit;
   IF (Mx>=Xa) AND (My>=Ya) AND (Mx<=Xb) AND (My<=Yb) THEN
    BEGIN
      Klick(100,10); Paa:=NOT Paa; Draw;
      REPEAT UNTIL Mb=0; Switched:=TRUE;
    END;
 END;

{---------------------------------------------------------------------------}

PROCEDURE Window.Draw;
 BEGIN
   SaveMouse;
   EgaDraw.FBox (Xa+1   ,Ya+1   ,Xb-1   ,Yb-1,Bg);
   EgaDraw.HLine(Xa     ,Xb     ,Ya     ,Hl);
   EgaDraw.HLine(Xa     ,Xb     ,Yb     ,Sd);
   EgaDraw.VLine(Ya     ,Yb     ,Xa     ,Hl);
   EgaDraw.VLine(Ya     ,Yb     ,Xb     ,Sd);
   EgaDraw.HLine(Xa+4   ,Xb-4   ,Ya+5+Fh,Sd);
   EgaDraw.HLine(Xa+4   ,Xb-4   ,Yb-3   ,Hl);
   EgaDraw.VLine(Ya+5+Fh,Yb-3   ,Xa+4   ,Sd);
   EgaDraw.VLine(Ya+5+Fh,Yb-3   ,Xb-4   ,Hl);
   EgaDraw.WriteLine(Xa+(Xb-Xa-8*LENGTH(Title)) DIV 2,Ya+3,Title,Fg,Bg);
   EgaDraw.FBox (Xa+5   ,Ya+6+Fh,Xb-5   ,Yb-4,Sc);
   RestoreMouse;
 END;

PROCEDURE Window.Remove;
 BEGIN
   SaveMouse;
   EgaDraw.FBox(Xa,Ya,Xb,Yb,Bg);
   RestoreMouse;
 END;

PROCEDURE Window.Init(A,B,C,D:WORD; E,F,G,H:BYTE; I:STRING; J:BYTE);
 BEGIN
   Xa:=A; Ya:=B; Xb:=C; Yb:=D; Fg:=E; Bg:=F; Hl:=G; Sd:=H; Title:=I; Sc:=J;
   Xl:=Xb-Xa-10; Yl:=Yb-Ya-10-Fh;
 END;

PROCEDURE Window.WriteLine(A,B:WORD; C:STRING);
 BEGIN
   SaveMouse;
   EgaDraw.WriteLine(Xa+5+A,Ya+6+Fh+B,C,Fg,Sc);
   RestoreMouse;
 END;

PROCEDURE Window.SetPix(X,Y:WORD; C:BYTE);
 BEGIN
   EgaDraw.SetPix(Xa+5+X,Ya+6+Fh+Y,C);
 END;

FUNCTION  Window.GetPix(X,Y:WORD):BYTE;
 BEGIN
   GetPix:=EgaDraw.GetPix(Xa+5+X,Ya+6+Fh+Y);
 END;

PROCEDURE Window.Line(A,B,C,D,E:INTEGER);
 BEGIN
   SaveMouse;
   EgaDraw.Line(Xa+5+A,Ya+6+Fh+B,Xa+5+C,Ya+6+Fh+D,E);
   RestoreMouse;
 END;

FUNCTION  Window.Test:BOOLEAN;
 VAR A,B:WORD;
 BEGIN
   IF (Mx>=Xa) AND (Mx<=Xb) AND (My>=Ya) AND (My<=Ya+5+Fh) AND (Mb=1) THEN
    BEGIN
      Remove;
      A:=Mx-Xa; B:=My-Ya; Xb:=Xb-Xa; Yb:=Yb-Ya;
      SaveMouse;
      REPEAT
	Xa:=Mx-A; Ya:=My-B;
        IF Xa<0 THEN Xa:=0; IF Ya<0 THEN Ya:=0;
        IF Xa+Xb>xMax THEN Xa:=xMax-Xb;
        IF Ya+Yb>yMax THEN Ya:=yMax-Yb;
	EgaDraw.Box(Xa,Ya,Xa+Xb,Ya+Yb,Sd);
	EgaDraw.Box(Xa,Ya,Xa+Xb,Ya+Yb,Bg);
      UNTIL Mb=0;
     RestoreMouse;
     Xb:=Xa+Xb; Yb:=Ya+Yb;
     Draw;
    END;
 END;

BEGIN
  Mode:=Unknown; Visible:=OFF; SaveVs:=OFF; Sound:=ON;
END.