#include <stdio.h>
#include <stdlib.h>
#include <string.h>
#include <conio.h>
#include <dos.h>
#define vbeUseLFB       0x4000      
#define vbeMdAvailable  0x0001    
#define IN(reg)     rmregs.e##reg = in->x.reg
#define OUT(reg)    out->x.reg = rmregs.e##reg
static short vesa_add;
int     VESABuf_len = 1024;         
int     VESABuf_sel = 0;            
int     VESABuf_rseg;               
short   VESA_modeList[50];          
int     VESA_modemultiply;
int     VESA_xres,VESA_yres;        
int     VESA_bytesperline;         
long    VESA_imageSize;             
char    far * VESA_LFBPtr;          

typedef struct {
    char    VESASignature[4];       
    short   VESAVersion;            
    long    OemStringPtr;           
    long    Capabilities;           
    long    VideoModePtr;           
    short   TotalMemory;            
    /* VBE 2.0 extensions */
    short   OemSoftwareRev;         
    long    OemVendorNamePtr;       
    long    OemProductNamePtr;      
    long    OemProductRevPtr;       
    char    reserved[222];          
    char    OemDATA[256];           
    } VBE_vgaInfo;

typedef struct {
    short   ModeAttributes;         
    char    WinAAttributes;         
    char    WinBAttributes;         
    short   WinGranularity;         
    short   WinSize;                
    short   WinASegment;            
    short   WinBSegment;            
    long    WinFuncPtr;             
    short   BytesPerScanLine;       
    short   XResolution;            
    short   YResolution;            
    char    XCharSize;              
    char    YCharSize;              
    char    NumberOfPlanes;         
    char    BitsPerPixel;           
    char    NumberOfBanks;          
    char    MemoryModel;            
    char    BankSize;               
    char    NumberOfImagePages;     
    char    res1;                   
    char    RedMaskSize;            
    char    RedFieldPosition;       
    char    GreenMaskSize;          
    char    GreenFieldPosition;     
    char    BlueMaskSize;           
    char    BlueFieldPosition;      
    char    RsvdMaskSize;           
    char    RsvdFieldPosition;      
    char    DirectColorModeInfo;    
    /* VBE 2.0 extensions */
    long    PhysBasePtr;            
    long    OffScreenMemOffset;     
    short   OffScreenMemSize;       
    char    res2[206];              
    } VBE_modeInfo;


typedef struct {
    long    edi;
    long    esi;
    long    ebp;
    long    reserved;
    long    ebx;
    long    edx;
    long    ecx;
    long    eax;
    short   flags;
    short   es,ds,fs,gs,ip,cs,sp,ss;
    } _RMREGS;

struct _RMWORDREGS {
    unsigned short ax, bx, cx, dx, si, di, cflag;
    };

struct _RMBYTEREGS {
    unsigned char   al, ah, bl, bh, cl, ch, dl, dh;
    };

typedef union {
    struct  _RMWORDREGS x;
    struct  _RMBYTEREGS h;
    } RMREGS;

typedef struct {
    unsigned short  es;
    unsigned short  cs;
    unsigned short  ss;
    unsigned short  ds;
    } RMSREGS;


void FatalError(char *msg)
{
    fprintf(stderr,"%s\n", msg);
    exit(1);
}

void DPMI_allocRealSeg(int size,int *sel,int *r_seg)
{
    union REGS      r;

    r.w.ax = 0x100;                
    r.w.bx = (size + 0xF) >> 4;    
    int386(0x31, &r, &r);
    if (r.w.cflag)
        FatalError("void DPMI_allocRealSeg() failed!");
    *sel = r.w.dx;                 
    *r_seg = r.w.ax;               
}

void DPMI_freeRealSeg(unsigned sel)
{
    union REGS  r;

    r.w.ax = 0x101;        
    r.w.dx = sel;          
    int386(0x31, &r, &r);
}

int DPMI_int86(int intno, RMREGS *in, RMREGS *out)
{
    _RMREGS         rmregs;
    union REGS      r;
    struct SREGS    sr;

    memset(&rmregs, 0, sizeof(rmregs));
    IN(ax); IN(bx); IN(cx); IN(dx); IN(si); IN(di);

    segread(&sr);
    r.w.ax = 0x300;              
    r.h.bl = intno;
    r.h.bh = 0;
    r.w.cx = 0;
    sr.es = sr.ds;
    r.x.edi = (unsigned)&rmregs;
    int386x(0x31, &r, &r, &sr);  

    OUT(ax); OUT(bx); OUT(cx); OUT(dx); OUT(si); OUT(di);
    out->x.cflag = rmregs.flags & 0x1;
    return out->x.ax;
}

int DPMI_int86x(int intno, RMREGS *in, RMREGS *out, RMSREGS *sregs)
{
    _RMREGS         rmregs;
    union REGS      r;
    struct SREGS    sr;

    memset(&rmregs, 0, sizeof(rmregs));
    IN(ax); IN(bx); IN(cx); IN(dx); IN(si); IN(di);
    rmregs.es = sregs->es;
    rmregs.ds = sregs->ds;

    segread(&sr);
    r.w.ax = 0x300;            
    r.h.bl = intno;
    r.h.bh = 0;
    r.w.cx = 0;
    sr.es = sr.ds;
    r.x.edi = (unsigned)&rmregs;
    int386x(0x31, &r, &r, &sr);    

    OUT(ax); OUT(bx); OUT(cx); OUT(dx); OUT(si); OUT(di);
    sregs->es = rmregs.es;
    sregs->cs = rmregs.cs;
    sregs->ss = rmregs.ss;
    sregs->ds = rmregs.ds;
    out->x.cflag = rmregs.flags & 0x1;
    return out->x.ax;
}

int DPMI_allocSelector(void)
{
    int         sel;
    union REGS  r;

    r.w.ax = 0;        
    r.w.cx = 1;        
    int386(0x31, &r, &r);
    if (r.x.cflag)
        FatalError("int DPMI_allocSelector() failed!");
    sel = r.w.ax;

    r.w.ax = 9;        
    r.w.bx = sel;
    r.w.cx = 0x8092;   
    int386(0x31, &r, &r);
    return sel;
}

long DPMI_mapPhysicalToLinear(long physAddr,long limit)
{
    union REGS  r;

    r.w.ax = 0x800;                
    r.w.bx = physAddr >> 16;
    r.w.cx = physAddr & 0xFFFF;
    r.w.si = limit >> 16;
    r.w.di = limit & 0xFFFF;
    int386(0x31, &r, &r);
    if (r.x.cflag)
        FatalError("long DPMI_mapPhysicalToLinear() failed!");
    return ((long)r.w.bx << 16) + r.w.cx;
}

void DPMI_setSelectorBase(int sel,long linAddr)
{
    union REGS  r;

    r.w.ax = 7;          
    r.w.bx = sel;
    r.w.cx = linAddr >> 16;
    r.w.dx = linAddr & 0xFFFF;
    int386(0x31, &r, &r);
    if (r.x.cflag)
        FatalError("void DPMI_setSelectorBase() failed!");
}

void DPMI_setSelectorLimit(int sel,long limit)
{
    union REGS  r;

    r.w.ax = 8;            
    r.w.bx = sel;
    r.w.cx = limit >> 16;
    r.w.dx = limit & 0xFFFF;
    int386(0x31, &r, &r);
    if (r.x.cflag)
        FatalError("void DPMI_setSelectorLimit() failed!");
}







void lfb(char *src);
#pragma aux lfb =               \
    "push   es"                     \  
    "mov    es,vesa_add"            \
    "xor    edi,edi"                \
    "mov    ecx,64000"              \    
    "rep    movsd"                  \
    "pop    es"                     \
    parm[esi] modify[edi ecx];


static void ExitVBEBuf(void)
{
    DPMI_freeRealSeg(VESABuf_sel);
}

void VBE_initRMBuf(void)
{
    if (!VESABuf_sel) {
        DPMI_allocRealSeg(VESABuf_len, &VESABuf_sel, &VESABuf_rseg);
        atexit(ExitVBEBuf);
        }
}

void VBE_callESDI(RMREGS *regs, void *buffer, int size)
{
    RMSREGS sregs;

    VBE_initRMBuf();
    sregs.es = VESABuf_rseg;
    regs->x.di = 0;
    _fmemcpy(MK_FP(VESABuf_sel,0),buffer,size);
    DPMI_int86x(0x10, regs, regs, &sregs);
    _fmemcpy(buffer,MK_FP(VESABuf_sel,0),size);
}

int VBE_detect(void)
{
    RMREGS      regs;
    short       *p1,*p2;
    VBE_vgaInfo vgaInfo;
    strncpy(vgaInfo.VESASignature,"VBE2",4);
    regs.x.ax = 0x4F00;
    VBE_callESDI(&regs, &vgaInfo, sizeof(VBE_vgaInfo));
    if (regs.x.ax != 0x004F)
        return 0;
    if (strncmp(vgaInfo.VESASignature,"VESA",4) != 0)
        return 0;
    p1 = (short *) (void*)(((unsigned)(vgaInfo.VideoModePtr) >> 12) + ((vgaInfo.VideoModePtr) & 0xFFFF));
    p2 = VESA_modeList;
    while (*p1 != -1)
        *p2++ = *p1++;
    *p2 = -1;
    return vgaInfo.VESAVersion;
}

int VBE_getModeInfo(int mode,VBE_modeInfo *modeInfo)
{
    RMREGS  regs;

    regs.x.ax = 0x4F01;             
    regs.x.cx = mode;
    VBE_callESDI(&regs, modeInfo, sizeof(VBE_modeInfo));
    if (regs.x.ax != 0x004F)
        return 0;
    if ((modeInfo->ModeAttributes & vbeMdAvailable) == 0)
        return 0;
    return 1;
}

static void VBE_setVideoMode(int mode)
{
    RMREGS  regs;
    regs.x.ax = 0x4F02;
    regs.x.bx = mode;
    DPMI_int86(0x10,&regs,&regs);
}


void far *GetPtrToLFB(long physAddr)
{
    int     sel;
    long    linAddr,limit = (4096 * 1024) - 1;
    sel = DPMI_allocSelector();
    linAddr = DPMI_mapPhysicalToLinear(physAddr,limit);
    DPMI_setSelectorBase(sel,linAddr);
    DPMI_setSelectorLimit(sel,limit);
    return MK_FP(sel,0);
}

int setme(int x,int y,int mode)
{
    if(VBE_detect()<0x200)return 0;
    VBE_modeInfo    modeInfo;
    VBE_getModeInfo(mode,&modeInfo);
            VESA_xres = x;
            VESA_yres = y;
            VESA_bytesperline = modeInfo.BytesPerScanLine;
            VESA_modemultiply=modeInfo.BitsPerPixel/8;
            VESA_imageSize = VESA_bytesperline * VESA_yres;
            VBE_setVideoMode(mode|vbeUseLFB);
            VESA_LFBPtr = (char __far *)GetPtrToLFB(modeInfo.PhysBasePtr);
            vesa_add=FP_SEG(VESA_LFBPtr);
return 1;
}

void VESA_EndGraphics(void)
{
    RMREGS  regs;
    regs.x.ax = 0x3;
    DPMI_int86(0x10, &regs, &regs);
}

void buf2lfb(char*buf){lfb(buf);}

