#include <stdio.h>
#include <stdlib.h>
#include <conio.h>
#include <dos.h>
#include <string.h>
#include <math.h>
#define PI 3.141592654
#define SCREENWIDTH VESA_xres
#define SCREENHEIGHT VESA_yres
#define MAPWIDTH 512
#define MAPHEIGHT 512
#define MAPSHIFT 9          //2^9==512==MAPWIDTH
#define voxel_dist 3000     

/*************EXTERNS*****************************************/
extern int VESA_xres,VESA_yres;
extern int VBE_detect(void);
extern void VESA_EndGraphics();
extern void buf2lfb(char * src);
extern int setme(int x,int y,int mode);

/*************************************************************/

/**************************VARS*******************************/
float sintab[360],costab[360];
char *buffer,         //Offscreen Buffer
     *map,            //Height Map
     *color,          //Color Map
     *clouds;         //Cloud Bitmap
char ende;
char scancode;
char Keys[128];
void (__interrupt __far *old09h)();
void __interrupt __far new09h();
int hoehe=100,richt,xc,yc,direction,voxel_stretch=50;
int horizon,maxy,
    view_length,view_size,flyheight=100,
    y_old,offtab[400],
    xtab[640][400],voxtab[640];
/************************************************************/


/**************************PCX-STRUCTS***********************/
typedef struct{
        short x,y;} Tpcxsize;


typedef struct{
        unsigned char id,version,encoding,bpp;
        short x1,y1,x2,y2,hres,vres;
        unsigned char colors[48];
        unsigned char vmode,planes;
        short bpl,palinfo;
        unsigned char fillbytes[58];
        } PCXHeader;

/************************************************************/


/*****************NEW KEYBOARD 09h ISR***********************/

void __interrupt __far new09h(void)
{
char x;
scancode = inp(0x60);
x = inp(0x61);
outp(0x61, (x | 0x80));
outp(0x61, x);
outp(0x20, 0x20);
Keys[scancode & 127] = 1;
if (scancode & 128)
    {
    Keys[scancode & 127] = 0;
    }

}

void inst_key(void)
{
old09h=_dos_getvect(0x09);
_dos_setvect(0x09,new09h);
}


void restore_key(void)
{
_dos_setvect(0x09,old09h);
}

/************************************************************/


/*****************BUILD TABLES*******************************/

void intvars()
{
    horizon=150,
    maxy=(SCREENHEIGHT-1),
    view_length=(SCREENWIDTH/6),
    view_size=(SCREENWIDTH/4)-1;
}

void make_trig()
{
    float i;
    for(i=0;i<=359;i++)sintab[(int)i]=sin(i/(180)*PI);
    for(i=0;i<=359;i++)costab[(int)i]=cos(i/(180)*PI);
}


void gentab()
{
    for(int j=1;j<=view_length;j++)voxtab[j]=horizon+voxel_dist/j;
    for(j=0;j<400;j++)offtab[j]=j*SCREENWIDTH;
    for(int i=0;i<=view_size;i++)
        for(j=1;j<=view_length;j++)
            xtab[i][j]=i*j /view_size-(j>>1);                    
    make_trig();
}


float sinus(int a)
{
    a+=360;
    a=a%360;
    return sintab[(int)a];
}

float cosinus(int a)
{
    a+=360;
    a=a%360;
    return costab[(int)a];
}


/************************PCX LOADER**************************/

Tpcxsize getpcxsize(char *d)
{
    Tpcxsize k;
    PCXHeader pc;
    FILE *f=fopen(d,"rb");
    memset(&pc,0,sizeof(pc));
    fread(&pc,sizeof(pc),1,f);
    fclose(f);
    k.x=pc.x2+1;
    k.y=pc.y2+1;
    return k;
}

long filesize(FILE *n)
{
    long org=ftell(n);
    fseek(n,-0L,SEEK_END);
    long size=ftell(n);
    fseek(n,org,SEEK_SET);
    return size;
}

void loadpcx(char *name,char *po)
{
    FILE *f;
    int g,m,i,z;
    Tpcxsize sz=getpcxsize(name);
    f=fopen(name,"rb");
    char *cimage=(char *)malloc(filesize(f));
    unsigned char header[128];
    fread(&header,128,1,f);
    fread(&*cimage,filesize(f)-896,1,f);
    fclose(f);
    z=0;
    g=0;
    do{
        if(cimage[z]<192) po[g]=cimage[z];
        if(cimage[z]>=192){m=cimage[z]-192;
        z++;
        for(i=1;i<=m;i++) po[g+i-1]=cimage[z];
        g=g+m-1;}
        z++;
        g++;
    }while(g<sz.x*sz.y);
    free(cimage);
}



void loadpcxpal(char *name,unsigned char pal[768])
{
    FILE *f;
    f=fopen(name,"rb");
    fseek(f,filesize(f)-768,SEEK_SET);
    fread(pal,768,1,f);
    for(int i=0;i<768;i++) pal[i]/=4;
}

/***********************************************************/


void setpal(unsigned char palp[])
{
    unsigned int pcount;
    outp(0x3c8,0);
    for(pcount=0;pcount<768;pcount+=3){
        outp(0x3c9,palp[pcount]);
        outp(0x3c9,palp[pcount+1]);
        outp(0x3c9,palp[pcount+2]);
    }
}

void adjust(char *b) 
{
int x,y,f;
for(y=0;y<512;y++)
for(x=0;x<512;x++){
        f=b[(x-1)+y*512]+\
        b[(x-2)+y*512]+\
        b[(x+1)+y*512]+\
        b[(x+2)+y*512]+\
        b[x+(y-1)*512]+\
        b[x+(y-2)*512]+\
        b[x+(y+1)*512]+\
        b[x+(y+2)*512];
        if(f!=0)b[x+y*512]=f>>3;}
}



/*****************MAIN VOXEL PROCS**************************/

void innerloop(int x,int start,int col);    //draws 4pix vline
#pragma aux innerloop=   \
    "mov    edi,[buffer]"\
    "add    edi,ebx     "\
    "mov    ecx,[y_old] "\
    "inc    ecx         "\
    "sub    ecx,edx     "\
    "imul   edx,640     "\
    "add    edi,edx     "\
    "mov    ah,al       "\
    "push   ax          "\
    "shl    eax,16      "\
    "pop    ax          "\
    "l1:                "\
    "mov    [edi],eax   "\
    "add    edi,640     "\
    "loop l1            "\
     modify [edi ecx]    \
     parm[ebx][edx][eax];


void draw_voxel(int x,int e,int f,int c)
{
    int y,y2,h,i;
    f-=hoehe;
    h=f*voxel_stretch /e;
    y=voxtab[e]-h;
    if(y>0&&y<y_old){
                innerloop(x,y,c);
                y_old=y;
    }        
}


void voxel_spacing(int xp,int yp,int r)   
{
    int i,j=0,offset,x,y,co,si,nx,ny,h;
    r-=90;
    int f,c;
    co=cosinus(r)*1024;
    si=sinus(r)*1024;
    hoehe=map[xp+yp*MAPWIDTH]+flyheight;
    for(i=0;i<=view_size;i++){
        y_old=399;
        for(j=1;j<=view_length;j++){
            x=xtab[i][j];
            nx=(x*co >> 10)-(j*si >> 10);
            ny=(x*si >> 10)+(j*co >> 10);
            offset=(nx+xp)+(ny+yp<<MAPSHIFT); 
            f=map[offset];
            c=color[offset];
            draw_voxel(i*4,j,f,c);
            }
        }
}

/***********************************************************/

void control()
{
    if(Keys[80]){
        xc-=cosinus(richt)*4;
        yc-=sinus(richt)*4;
        }
    if(Keys[72]){
        xc+=cosinus(richt)*4;
        yc+=sinus(richt)*4;
        }
    if(Keys[77]){richt-=4;direction-=4;if(richt<0)richt=360;}
    if(Keys[75]){richt+=4;direction+=4;if(richt>360)richt=0;}
    if(Keys[74])flyheight--;
    if(Keys[78])flyheight++;
    if(Keys[28])adjust(map);
    if(Keys[16])voxel_stretch++;
    if(Keys[30])voxel_stretch--;
    if(Keys[1]) ende=1;
}

/***********************************************************/


/********************MAIN PROC******************************/

void main()
{
    int *timer=(int*)0x46c;
    int version=VBE_detect();
    int frame=0;
    int starttime,endtime;
    unsigned char pal[768];
    printf("VESA :%X found.\n",version);
    if(version<0x200){printf("VBE 2.0 required!\n");exit(0);}
    delay(1000);
    setme(640,400,0x100);
    intvars();
    gentab();
    buffer=(char*)malloc(SCREENWIDTH*SCREENHEIGHT);
    map=(char*)malloc(MAPWIDTH*MAPHEIGHT);
    color=(char*)malloc(MAPWIDTH*MAPHEIGHT);
    clouds=(char*)malloc(SCREENWIDTH*SCREENHEIGHT);
    if(color==0||buffer==0||map==0||clouds==0){
        printf("no mem... -sorry!\n");exit(0);
        }
    loadpcx("demoh.pcx",map);
    loadpcx("democ.pcx",color);
    loadpcx("clouds.pcx",clouds);
    loadpcxpal("democ.pcx",pal);
    for(int u=0;u<7;u++)adjust(map);    
    setpal(pal);
    hoehe=0,xc=160,yc=100,direction=0;
    inst_key();
    starttime=*timer;
    do{
        control();
        memcpy(buffer+direction,clouds,640*400);
        voxel_spacing(xc,yc,richt);
        buf2lfb(buffer);
        frame++;
        }while(!ende);
  endtime=*timer;
  VESA_EndGraphics();
  restore_key();
  printf("%.2f fps\n",frame*18.2/(endtime-starttime));
}
