/* Data structures for 3D modelling */

/* Written by Bernie Roehl and Dave Stampe, December 1991 */
/* updated 10/1/91 for renderer clip (first stage */
/* Integerizaation finished 19/1/91 and comments added */

// Massive upgrades since-- who's counting?

/*
 This code is part of the VR-386 project, created by Dave Stampe.
 VR-386 is a desendent of REND386, created by Dave Stampe and
 Bernie Roehl.  Almost all the code has been rewritten by Dave
 Stampre for VR-386.

 Copyright (c) 1994 by Dave Stampe:
 May be freely used to write software for release into the public domain
 or for educational use; all commercial endeavours MUST contact Dave Stampe
 (dstampe@psych.toronto.edu) for permission to incorporate any part of
 this software or source code into their products!  Usually there is no
 charge for under 50-100 items for low-cost or shareware products, and terms
 are reasonable.  Any royalties are used for development, so equipment is
 often acceptable payment.

 ATTRIBUTION:  If you use any part of this source code or the libraries
 in your projects, you must give attribution to VR-386 and Dave Stampe,
 and any other authors in your documentation, source code, and at startup
 of your program.  Let's keep the freeware ball rolling!

 DEVELOPMENT: VR-386 is a effort to develop the process started by
 REND386, improving programmer access by rewriting the code and supplying
 a standard API.  If you write improvements, add new functions rather
 than rewriting current functions.  This will make it possible to
 include you improved code in the next API release.  YOU can help advance
 VR-386.  Comments on the API are welcome.

 CONTACT: dstampe@psych.toronto.edu
*/



/* NOTE ON FORMATS:
 <nn.ff> means that nn bits are available as the integer part, and
 ff bits are used as a fractional part.  Multiply a float by 2^ff
 to get a long value to feed in.

 World coordinates should be kept below signed 24 bits (16.7M) to
 assure no errors.  This allows a range of 1mm->16.7 km, which
 should be plenty!

 Angles are in <16.16> format, where the integer part is in degrees.
*/


#ifndef MATRIXDEF
typedef long MATRIX[4][3];  	  /* 3x3 rotate plus 3 translate para's */
			/* rotate matrix is <3.29>, translate is <32.0> */
#define MATRIXDEF 1
#endif

/* new vertex copies, internal to renderer */

typedef struct nV NVERTEX;
struct nV{
		long  x, y, z;       	  /* viewport coordinates (used for saving time) */
	  long  xs, ys ;          /* screen coordinates */
		unsigned char outcode;  /* XY clip outcodes */
		unsigned char perspect; /* flags perspective done */
		};

#define LEFT   1	/* XY outcode bits */
#define RIGHT  2
#define TOP    4
#define BOTTOM 8



/* world database vertices */
/* object coords are referenced to object */
/* world coords are updated when moving or rotating object */
/* all others are renderer workspace */

typedef struct {
	long ox, oy, oz;   /* object coordinates */
	long x, y, z;      /* world coordinates  */
	long cz;	   /* converted Z coord  */
	NVERTEX *new_copy;  /* non-zero if x and y transformed */
	unsigned char z_transformed;   /* non-zero if z has been transformed */
	unsigned char z_outcode;       /* 1 set if hither, 2 set if yon */
	} VERTEX;

#define HITHER 16	/* Z outcode bits */
#define YON    32


/* world database polys */
/* object-based normal must be rotated to world copy with object */
/* color will have 8-bit color, 8-bit reflectance field */

#ifndef POLYDEF
#define POLYDEF 1

typedef struct {
	unsigned color;   /* color (not used yet-- will set chroma, reflectance */
	VERTEX **points;  /* array of pointers to the vertices of this polygon */
	int npoints;      /* number of entries in points[] */
	long onormalx,
	     onormaly,
	     onormalz;    /* unit length surface normal (VISOBJ) */
	long normalx,
	     normaly,
	     normalz;     /* unit length surface normal (WORLD)*/
	struct _object *object;
	} POLY;

#endif


/* renderer poly copy */
/* paernt points back to original poly for lighting */
/* color computed by cosine lighting (currently 0-15) */
/* maxz is deepest poly point for sorting */

typedef struct {
	int npoints;       /* number of entries in points[] MUST BE FIRST */
	POLY *parent;
	unsigned color;	   /* color after illumination */
	long maxz;        /* maximum Z value (for sorting) */
	} NPOLY;


typedef struct { NPOLY *ptr; long depth; } DSORT; /* used for depth sorting */

#ifndef REPDEF
#define REPDEF 1

typedef struct _rep {     /* a representation for an object */
	int size;            /* if the object is bigger than this, use this rep */
	int nverts, npolys;   /* number of vertices, number of polys */
	VERTEX *verts;        /* array of vertices */
	POLY *polys;          /* array of polygons */
	struct _rep *next;    /* pointer to next rep in list */
	long update_count;    /* inc. every time rep moves */
	unsigned flags;
	} REP;

#endif


/* world database object */
/* sphx, sphy, sphz, sphr used for sphere object clipping */

#define OBJ_FLAG_MASK  0x7C00
#define OBJ_DEPTH_MASK 0x010F

#ifndef OBJDEF
#define OBJDEF 1

typedef struct _object OBJECT;	// for our purposes...

typedef struct _object VISOBJ;  // this is a special case of OBJECT now

struct _object
 {
	unsigned int oflags;
#define OBJ_REPLOCK      0x0400
#define OBJ_NONSEL       0x0800 /* can't be selected (i.e. pointer) */
#define OBJ_INVIS        0x1000
#define OBJ_HIGHLIGHTED  0x2000
#define OBJLIST_HEADER   0x4000
#define IS_VISOBJ        0x8000	/* required by renderer: it will set */

//other uses of flags: for segments:
#define IS_SEGMENT    0x0080
#define SYSTEM_OWNED  0x0040
#define IS_MOVEABLE   0x0010    // segment or attached object


#define DEEPEST 0x0000		/* sort polys by deepest point */
#define ATBACK  0x0001		/* push this object's poly's waaaay back */
#define AVERAGE 0x0002		/* sort polys by average depth */

#define BYOBJECT   0x0100	/* sort by object */
#define BYPOLY     0x0000	/* put polys in world before sort */

	struct _object *prev;
	struct _object *nnext;

	void *owner;       /* for example, a body segment description struct */
	REP *replist;              /* pointer to list of representations */
	REP *current_rep;          /* the currently-active rep */
//	int (*coll_eval)(VISOBJ *obj, long x, long y, long z);    /* evaluate collision */

	long osphx, osphy, osphz;     /* object-coord sphere center */
	long sphx, sphy, sphz, sphr;  /* bounding sphere center and radius */
	long update_count;         /* inc. every time object moved */
 };

#endif


/* world database object list head */
/* dual linked for fast remove/insert needed for splits */

#ifndef OBJLDEF
#define OBJLDEF 1

typedef struct _objlist
 {
	unsigned int oflags;	/* so it LOOKS like part of OBJ */
#define OBJ_INVIS        0x1000
#define OBJ_HIGHLIGHTED  0x2000
#define OBJLIST_HEADER   0x4000
#define IS_VISOBJ        0x8000	/* required by renderer: it will set */

	struct _object *prev;
	struct _object *nnext;
 } OBJLIST;

#endif


#ifndef VIEWDEF
/* renderer viewpoint/screen control structure */
/* viewoint in X, Y, Z coords */
/* pan, tilt, roll in (float*65536) formats */
/* zoom is equiv. to magnification from 90 deg. FOV (also float*65536) */
/* aspect sets how much to magnify Y more than X to fix up displays */
/* light source point in world coordinates */
/* left, right, top, bottom set edges of screen */
/* hither sets closest point: keep >16 for best range of world coords */
/* yon sets max. distance: keep it 1<<26 if not used */
/* all others are renderer workspace */

#define NOFLIP 0      /* for orientation flags */
#define XFLIP  1
#define YFLIP  2

typedef struct {
	long zoom;              /* <16.16> 1/tan(H FOV/2) 0.5 to 16     */

				 /* SCREEN DATA */
	long left,right;        /* <25.0> clipping planes */
	long top, bottom;
	long hither, yon;   /* <25.0> near and far clipping planes   */
	long aspect;		/* <16.16> x:y fixup factor (magnify Y by..*/

	/* RENDERING CONTROL */
	unsigned flags;     /* 16 bits of flags */

				 /* ADVANCED SCREEN DATA */
	long x_offset, y_offset; /* amount to move screen center in pixels */
	unsigned orientation;    /* used to mirror screen image */
	MATRIX eye_xform;

		     /* INTERNAL RECORDS */
	long hsw, hsh;		/* half screen width, height */
	long hsc, vsc;		/* screen center (with offset) */
	long scx, scy;		/* full-resolution scaling for horizon */
	long sx,sy;		/* mantissa of screen scaling  */
	int  xshift, yshift;    /* scaling bit shifts */

	long left_C, left_M;    /* spherical clip coefficients */
	long right_C, right_M;
	long top_C, top_M;
	long bot_C, bot_M;

	       } VIEW;

/* View flags: */

#define WIREFRAME           0x0001
#define VIEWDEF 1
#endif

/* Prescaling (used in hrendo5.c and 3dsupp.c (in where_screen_pt()) */

#define PRESCALE  2	/* frac bits in XY coords */
#define PRESCALEZ 2

#ifndef SCRIDEF
#define SCRIDEF 1
struct Screeninfo {
	int xmin, ymin, xmax, ymax, xcent, ycent, colors, pages, bw;
	long aspect;
	char id[80];
	};
#endif

extern struct Screeninfo *screeninfo;

					/* create rotation/translation */
					/* "matrix" from angle data    */
					/* CALL setup_render FIRST!    */

/* End of structs */


#define OUT_OF_VIEW 0x80000000L // returned by clip_by_volume() if out

/* End of 3dstruct.h */

