	TITLE	ANIMATE - Animation computations IN ASSEMBLER

	COMMENT $

/* Support for statmach.c, assembly by Dave Stampe */
/* ported to assembly modules by D. Stampe 12/12/93 */


/*
 This code is part of the VR-386 project, created by Dave Stampe.
 VR-386 is a desendent of REND386, created by Dave Stampe and
 Bernie Roehl.  Almost all the code has been rewritten by Dave
 Stampre for VR-386.

 Copyright (c) 1994 by Dave Stampe:
 May be freely used to write software for release into the public domain
 or for educational use; all commercial endeavours MUST contact Dave Stampe
 (dstampe@psych.toronto.edu) for permission to incorporate any part of
 this software or source code into their products!  Usually there is no
 charge for under 50-100 items for low-cost or shareware products, and terms
 are reasonable.  Any royalties are used for development, so equipment is
 often acceptable payment.

 ATTRIBUTION:  If you use any part of this source code or the libraries
 in your projects, you must give attribution to VR-386 and Dave Stampe,
 and any other authors in your documentation, source code, and at startup
 of your program.  Let's keep the freeware ball rolling!

 DEVELOPMENT: VR-386 is a effort to develop the process started by
 REND386, improving programmer access by rewriting the code and supplying
 a standard API.  If you write improvements, add new functions rather
 than rewriting current functions.  This will make it possible to
 include you improved code in the next API release.  YOU can help advance
 VR-386.  Comments on the API are welcome.

 CONTACT: dstampe@psych.toronto.edu
*/

This code will be less useful for 32-bit C compilers.  Nonetheless,
it needs 64-bit intermediate results.  It could be redone using the
new function mulmuldiv(), though.


/* Contact: dstampe@sunee.waterloo.edu */

		$

	.MODEL large

	.DATA

include animate.inc

	.CODE
	.386

;/***************** SUPPORT FOR STATMACH.C **************/


;void scaled_rotate(STATE *s, long *nrx,long *nry,long *nrz, long elpsed, long tps);

s	equ	[bp+8]          ; arguments
pnrx	equ	[bp+12]
pnry	equ	[bp+16]
pnrz	equ	[bp+20]
elapsed	equ	[bp+24]         ; elapsed time
tps	equ	[bp+28]         ; ticks per sec: 0 for no scaling

	PUBLIC	_scaled_rotate

_scaled_rotate 	proc	far

	.386
	push	ebp
	mov	ebp,esp
	push	ds
	push	di

	les	bx,DWORD PTR s

	mov	eax,es:[bx].ST_x2	; get rotate step
	test	DWORD PTR tps,-1        ; any scale?
	je	no_scale_rx

	imul	DWORD PTR elapsed       ; scale by time
	idiv	DWORD PTR tps

no_scale_rx:
	lds	di,DWORD PTR pnrx       ; get present angle
	add	eax,ds:[di]             ; add in
	cmp	eax,-360*65536          ; clip angle
	jg	nccx
	add	eax,360*65536
nccx:
	cmp	eax,360*65536
	jl	nchx
	sub	eax,360*65536
nchx:
	mov	ds:[di],eax             ; store new angle

	mov	eax,es:[bx].ST_y2       ; repeat for Y
	test	DWORD PTR tps,-1
	je	no_scale_ry

	imul	DWORD PTR elapsed
	idiv	DWORD PTR tps

no_scale_ry:
	lds	di,DWORD PTR pnry
	add	eax,ds:[di]
	cmp	eax,-360*65536
	jg	nccy
	add	eax,360*65536
nccy:
	cmp	eax,360*65536
	jl	nchy
	sub	eax,360*65536
nchy:
	mov	ds:[di],eax

	mov	eax,es:[bx].ST_z2
	test	DWORD PTR tps,-1
	je	no_scale_rz

	imul	DWORD PTR elapsed
	idiv	DWORD PTR tps

no_scale_rz:
	lds	di,DWORD PTR pnrz      ; repeat for Z
	add	eax,ds:[di]
	cmp	eax,-360*65536
	jg	nccz
	add	eax,360*65536
nccz:
	cmp	eax,360*65536
	jl	nchz
	sub	eax,360*65536
nchz:
	mov	ds:[di],eax

	pop	di
	pop	ds
	mov	esp,ebp
	pop	ebp
	ret

_scaled_rotate	endp




;void scaled_move(STATE *s, long *nx,long *ny,long *nz, long elapsed, long tps);


s	equ	[bp+8]          ; arguments
pnx	equ	[bp+12]
pny	equ	[bp+16]
pnz	equ	[bp+20]
elapsed	equ	[bp+24]         ; elapsed time
tps	equ	[bp+28]         ; ticks per sec: 0 for no scaling

	PUBLIC	_scaled_move

_scaled_move 	proc	far

	.386
	push	ebp
	mov	ebp,esp
	push	ds
	push	di

	les	bx,DWORD PTR s

	mov  	eax,es:[bx].ST_x1
	or	eax,eax
	je	no_x_move
	test	DWORD PTR tps, -1
	je	no_xmove_scale
	imul 	DWORD PTR elapsed
	idiv 	DWORD PTR tps
no_xmove_scale:
	mov  	dl,BYTE PTR es:[bx].ST_xo1
	mov  	dh,al
	sar  	eax,8
	add  	dl,dh
	lds	di,pnx
	adc  	ds:[di],eax
	mov  	BYTE PTR es:[bx].ST_xo1,dl
no_x_move:

	mov  	eax,es:[bx].ST_y1
	or	eax,eax
	je	no_y_move
	test	DWORD PTR tps, -1
	je	no_ymove_scale
	imul 	DWORD PTR elapsed
	idiv 	DWORD PTR tps
no_ymove_scale:
	mov  	dl,BYTE PTR es:[bx].ST_yo1
	mov  	dh,al
	sar  	eax,8
	add  	dl,dh
	lds	di,pny
	adc  	ds:[di],eax
	mov  	BYTE PTR es:[bx].ST_yo1,dl
no_y_move:

	mov  	eax,es:[bx].ST_z1
	or	eax,eax
	je	no_z_move
	test	DWORD PTR tps, -1
	je	no_zmove_scale
	imul 	DWORD PTR elapsed
	idiv 	DWORD PTR tps
no_zmove_scale:
	mov  	dl,BYTE PTR es:[bx].ST_zo1
	mov  	dh,al
	sar  	eax,8
	add  	dl,dh
	lds	di,pnz
	adc  	ds:[di],eax
	mov  	BYTE PTR es:[bx].ST_zo1,dl
no_z_move:

	pop	di
	pop	ds
	mov	esp,ebp
	pop	ebp
	ret

_scaled_move	endp


; void scaled_gravity(STATE *s, long elpsed, long tps);


s	equ	[bp+8]          ; arguments
elapsed	equ	[bp+12]         ; elapsed time
tps	equ	[bp+16]         ; ticks per sec: 0 for no scaling

	PUBLIC	_scaled_gravity

_scaled_gravity	proc	far

	.386
	push	ebp
	mov	ebp,esp

	les	bx,DWORD PTR s

	mov   	eax,es:[bx].ST_x3    ; get gravity acceleration
	or	eax,eax
	je	no_x_gravity         ; none?

	imul  	DWORD PTR elapsed    ; scale by time
	idiv  	DWORD PTR tps
	mov   	dl,al                ; underflow integerate
	sar   	eax,8
	add   	dl,BYTE PTR es:[bx].ST_xo2
	adc   	es:[bx].ST_x1,eax
	mov   	BYTE PTR es:[bx].ST_xo2,dl    ; add to velocity
no_x_gravity:

	mov   	eax,es:[bx].ST_y3    ; repeat for y
	or	eax,eax
	je	no_y_gravity

	imul  	DWORD PTR elapsed
	idiv  	DWORD PTR tps
	mov   	dl,al
	sar   	eax,8
	add   	dl,BYTE PTR es:[bx].ST_yo2
	adc   	es:[bx].ST_y1,eax
	mov   	BYTE PTR es:[bx].ST_yo2,dl
no_y_gravity:

	mov   	eax,es:[bx].ST_z3    ; repeat for Z
	or	eax,eax
	je	no_z_gravity

	imul  	DWORD PTR elapsed
	idiv  	DWORD PTR tps
	mov   	dl,al
	sar   	eax,8
	add   	dl,BYTE PTR es:[bx].ST_zo2
	adc   	es:[bx].ST_z1,eax
	mov   	BYTE PTR es:[bx].ST_zo2,dl
no_z_gravity:

	mov	esp,ebp
	pop	ebp
	ret

_scaled_gravity	endp



	end

