/* 2D cursor handling  */
// Mouse cursor show, move
// Click-on-screen->object selection
// Mouse handler
// Rewritten for VR-386 by Dave Stampe 9/1/94

/* Original written by Dave Stampe, Aug. 1992 */


/*
 This code is part of the VR-386 project, created by Dave Stampe.
 VR-386 is a desendent of REND386, created by Dave Stampe and
 Bernie Roehl.  Almost all the code has been rewritten by Dave
 Stampre for VR-386.

 Copyright (c) 1994 by Dave Stampe:
 May be freely used to write software for release into the public domain
 or for educational use; all commercial endeavours MUST contact Dave Stampe
 (dstampe@psych.toronto.edu) for permission to incorporate any part of
 this software or source code into their products!  Usually there is no
 charge for under 50-100 items for low-cost or shareware products, and terms
 are reasonable.  Any royalties are used for development, so equipment is
 often acceptable payment.

 ATTRIBUTION:  If you use any part of this source code or the libraries
 in your projects, you must give attribution to VR-386 and Dave Stampe,
 and any other authors in your documentation, source code, and at startup
 of your program.  Let's keep the freeware ball rolling!

 DEVELOPMENT: VR-386 is a effort to develop the process started by
 REND386, improving programmer access by rewriting the code and supplying
 a standard API.  If you write improvements, add new functions rather
 than rewriting current functions.  This will make it possible to
 include you improved code in the next API release.  YOU can help advance
 VR-386.  Comments on the API are welcome.

 CONTACT: dstampe@psych.toronto.edu
*/



#include <stdio.h>
#include <dos.h>

#include "pointer.h"
#include "vr_api.h"
#include "f3dkitd.h"
#include "renderer.h"	// for screen monitor
#include "intmath.h"

extern int manip_2D_avail;

/***************** 2D (screen) cursor handling ************/

static SWORD oldx = 160, oldy = 100;
static BOOL cursor_visible = FALSE;
static BOOL enable_2D;

void cursor_enable(BOOL state)   /* hardwire on/off */
{
  if(!state && cursor_visible && in_graphics)
		cursor_hide();
  enable_2D = state;
  if(state && !cursor_visible && in_graphics)
		cursor_show();
}

void cursor_move(WORD x, WORD y) /* move cursor if visible */
{
  oldx = x;
  oldy = y;
  if (cursor_visible==TRUE && enable_2D==TRUE)
    {
      set_drawpage(current_video_page);
      erase_cursor(current_video_page);
      draw_cursor(x,y,-(screeninfo->colors-1),current_video_page);
    }
}

BOOL cursor_hide() /* erase cursor, tell if it was shown */
{
  BOOL i = cursor_visible;

  if (cursor_visible==TRUE && enable_2D)
    {
      erase_cursor(current_video_page);
      cursor_visible = FALSE;
    }
  return i;
}


BOOL last_cursor_hide(WORD page) /* erase cursor, tell if it was shown */
{                       /* for non-current page */
  BOOL i = cursor_visible;

  if (cursor_visible==TRUE && enable_2D)
    {
      erase_cursor(page);
      cursor_visible = FALSE;
    }
  return i;
}


void cursor_show() /* redisplay cursor */
{
  if (cursor_visible==FALSE && enable_2D)
    {
      set_drawpage(current_video_page);
      draw_cursor(oldx, oldy, -(screeninfo->colors-1), current_video_page);
      cursor_visible = TRUE;
    }
}


WORD move_2D(PDRIVER *d, WORD *x, WORD *y, WORD *b)
{
  int c;

  if (d == NULL) return 0;
  if (PNEW_POS & (c = mouse_read(d, x, y, b)))
	cursor_move(*x, *y);
  return c;
}


WORD move_till_click(PDRIVER *d, WORD b, WORD *x, WORD *y) /* b is button mask */
{
  int s;
  unsigned c;

  if (d == NULL) return 0;
  while(1)
    {
      if (((s = move_2D(d, x, y, &c)) & PNEW_BUT) && (c & b)) break;
    }
  return s;
}

extern int mouse_nav;

BOOL can_point_2D()
{
  if (!manip_2D_avail || mouse_nav)
    {
      if(in_graphics)
	{
	  save_screen();
	  popmsg("Mouse not available");
	  tdelay(500);
	  restore_screen();
	}
      return 0;
    }
  return 1;
}


////// USE report_screen_object() <objsppt.c>
////// to get rest of data on object


OBJECT *find_object_on_screen(WORD x, WORD y)
{
  OBJECT *obj;               // ACTUALLY REDRAWS SCREEN TO GET DATA
  set_screen_monitor(x, y);
  screen_refresh(current_camera);
  clear_screen_monitor();
  process_screen_monitor();
  return screen_monitor_object();
}



OBJECT *move_and_find_object_2D(PDRIVER *d, WORD *buttons)	// to find object etc
{
  int x, y, c;
  OBJECT *obj;
  int b;

  if(!buttons) buttons = &b;

  if (!(c = move_2D(d, &x, &y, buttons))) return NULL; /* no changes */

  if (*buttons != 0 && (c & PNEW_BUT)) /* new button: DOWN event */
    {
      obj = find_object_on_screen(x, y);
      if (obj && is_object_selectable(obj)) return obj;
    }
  return NULL;
}


// the "screen idle" call
// returns 0 if no action
// returns -1 if menu-area click
// returns 1 if new object selected

int move_and_select_2D(PDRIVER *d)
{
  int x, y, c;
  unsigned b;

  if (!(c = move_2D(d, &x, &y, &b))) return 0; /* no changes */

  b &= 1; /* only left button wanted */
  if(b==1 && y==0) return -1; /* menu callup */

  if (b != 0 && (c & PNEW_BUT)) /* new button: DOWN event */
    {
      OBJECT *obj;

      obj = find_object_on_screen(x, y);
      if (obj && is_object_selectable(obj))
	{
	  if(is_object_selected(obj))
	     unhighlight_object(obj);
	  else
	     highlight_object(obj);
	  world_changed++;
	  return 1;
	}
      else
	{
	  save_screen();
	  popmsg("Not on (selectable) object");
	  tdelay(300);
	  restore_screen();
	}
    }
  return 0;
}

extern PDRIVER *cursor_device;

void mouse_process()
{
  int i;
  if(mouse_nav || !cursor_device) return;
  i = move_and_select_2D(cursor_device);
  if(i==-1) process_a_key('X');	// menu callup
}