/* 3D cursor handling  */
/* some manipulation routines */
// Rewritten for VR-386 by Dave Stampe 9/1/94

/* Original written by Dave Stampe, Aug. 1992 */


/*
 This code is part of the VR-386 project, created by Dave Stampe.
 VR-386 is a desendent of REND386, created by Dave Stampe and
 Bernie Roehl.  Almost all the code has been rewritten by Dave
 Stampre for VR-386.

 Copyright (c) 1994 by Dave Stampe:
 May be freely used to write software for release into the public domain
 or for educational use; all commercial endeavours MUST contact Dave Stampe
 (dstampe@psych.toronto.edu) for permission to incorporate any part of
 this software or source code into their products!  Usually there is no
 charge for under 50-100 items for low-cost or shareware products, and terms
 are reasonable.  Any royalties are used for development, so equipment is
 often acceptable payment.

 ATTRIBUTION:  If you use any part of this source code or the libraries
 in your projects, you must give attribution to VR-386 and Dave Stampe,
 and any other authors in your documentation, source code, and at startup
 of your program.  Let's keep the freeware ball rolling!

 DEVELOPMENT: VR-386 is a effort to develop the process started by
 REND386, improving programmer access by rewriting the code and supplying
 a standard API.  If you write improvements, add new functions rather
 than rewriting current functions.  This will make it possible to
 include you improved code in the next API release.  YOU can help advance
 VR-386.  Comments on the API are welcome.

 CONTACT: dstampe@psych.toronto.edu
*/

#include <stdio.h>
#include <dos.h>

#include "vrconst.h"
#include "pointer.h"
#include "vr_api.h"
#include "intmath.h"
#include "segment.h"



/************* 3D/6D CURSOR SUPPORT ***********/

	// sets up the 3D/6D manip system
void set_3D_manip_data(PDRIVER *ptr, SEGMENT *move, SEGMENT *sel, POSE *seloffset);

static SEGMENT *cursor_seg;

static int load_3D_cursor(PDRIVER *gd, char *cursor_fname)
{
  int i;
  FILE *in;
  OBJECT *obj;
  POSE p = ZERO_POSE;

  if ((in = fopen(cursor_fname, "r")) == NULL)
    {
      errprintf("Cannot read 3D cursor object %s",cursor_fname);
      return -1;
    }
  cursor_seg = create_invisible_object();
  attach_object(cursor_seg, body_seg, 0);
  obj = load_plg_object(in, &p, 1, 1, 1, 0);
  if(!obj)
    {
      errprintf("Error in loading 3D cursor object %s",cursor_fname);
      return -2;
    }
  make_fixed_object_moveable(obj, cursor_seg);
  update_object(cursor_seg);
  add_object_to_world(obj);
  fclose(in);

  make_object_unselectable(obj);

  set_3D_manip_data(gd, cursor_seg, cursor_seg, &p);

}



int cursor_update_3D(PDRIVER *d, POINTER *p) /* read pointer, update positions */
{
	int c;

	c = pointer_read(d, p);

	if ((c & (PNEW_POS | PNEW_ROT)) == 0) return 0;

	abs_move_segment(cursor_seg, p->x, p->y + Y_PTR_OFFSET, p->z + PTR_DIST);
	abs_rot_segment(cursor_seg, p->rx, p->ry, p->rz, RYXZ);

	world_changed++;
	return 1;
}

static PDRIVER *ptr3d;

static void ptr3d_quit()
{
   pointer_quit(ptr3d);
}


PDRIVER *pointer_initialize(char *ptrdrv, char *ptrobj, POSE *s)
{
  PDRIVER *p;
  POINTER x;

  p = pointer_init(P_IS3DG | P_IS6DG, ptrdrv); /* setup glove device */
  if (p == NULL) return NULL;

  init_pointer(&x); /* so that defaults are OK */
	/* use abs. glove motion */
  pointer_abscale(p, s->x, s->y, s->z, s->rx, s->ry, s->rz);
  set_mouse_limits(p, screeninfo->xmax, screeninfo->ymax);
  pointer_read(p, &x);
  pointer_read(p, &x); /* save current position */
  mouse_read(p, NULL, NULL, NULL);

  ptr3d = p;
  atexit(ptr3d_quit);

  load_3D_cursor(p, ptrobj);

  return p;
}






	// read, handle 3D/6D pointer commands
void pointer_process()
{
  POINTER gp;
  int g;

  cursor_update_3D(ptr3d, &gp);
  switch(gp.buttons)
    {
      case 2 :
	g = GRASP_DO;
	break;
      case 3:
	g = ROTATE_DO;
	break;
      case 1:
	g = SELECT_DO;
	break;
      default:
	g = FREE_DO;
	break;
   }
 do_3D_manip(g);
}
