// file, error, etc support
// Dave Stampe, 4/1/94


/*
 This code is part of the VR-386 project, created by Dave Stampe.
 VR-386 is a desendent of REND386, created by Dave Stampe and
 Bernie Roehl.  Almost all the code has been rewritten by Dave
 Stampre for VR-386.

 Copyright (c) 1994 by Dave Stampe:
 May be freely used to write software for release into the public domain
 or for educational use; all commercial endeavours MUST contact Dave Stampe
 (dstampe@psych.toronto.edu) for permission to incorporate any part of
 this software or source code into their products!  Usually there is no
 charge for under 50-100 items for low-cost or shareware products, and terms
 are reasonable.  Any royalties are used for development, so equipment is
 often acceptable payment.

 ATTRIBUTION:  If you use any part of this source code or the libraries
 in your projects, you must give attribution to VR-386 and Dave Stampe,
 and any other authors in your documentation, source code, and at startup
 of your program.  Let's keep the freeware ball rolling!

 DEVELOPMENT: VR-386 is a effort to develop the process started by
 REND386, improving programmer access by rewriting the code and supplying
 a standard API.  If you write improvements, add new functions rather
 than rewriting current functions.  This will make it possible to
 include you improved code in the next API release.  YOU can help advance
 VR-386.  Comments on the API are welcome.

 CONTACT: dstampe@psych.toronto.edu
*/


#include <stdio.h>
#include <stdarg.h>
#include <ctype.h>
#include <dos.h>
#include <conio.h>     /* kbhit() */
#include <bios.h>      /* bioskey() */
#include <string.h>    /* strlen() */

#include "vr_api.h"


extern FILE *logfile;

WORD errprintf(char *fmt, ...)
{
   char buffer[180];
   va_list argptr;
   int cnt;

   va_start(argptr, fmt);
   cnt = vsprintf(buffer, fmt, argptr);
   va_end(argptr);

   if(log_file) fprintf(log_file,"%s\n",buffer);
   if(!in_graphics)
       fprintf(stderr,"%s\n",buffer);
   if(in_graphics)
     {
       buffer[35] = 0;
       save_screen();
       popmsg(buffer);
       get_response(1);
       restore_screen();
     }

   return(cnt);
}


	// prints to "popmsg" box
	// useful for debugging
	// prints to stderr if not in graphics mode
WORD popprintf(char *fmt, ...)
{
  char buffer[180];
  va_list argptr;
  int cnt;

  va_start(argptr, fmt);
  cnt = vsprintf(buffer, fmt, argptr);
  va_end(argptr);

   if(!in_graphics)
       fprintf(stderr,"%s\n",buffer);
   if(in_graphics)
     {
       buffer[35] = 0;
       popmsg(buffer);
     }

   return(cnt);
}


void add_ext(char *name, char *ext)    // add extension to filename
{
  char *c;
  if(strchr(name, '.')) return;
  c = strchr(name, 0);
  *c++ = '.';
  *c++ = *ext++;
  *c++ = *ext++;
  *c++ = *ext++;
  *c = 0;
}

static char tempname[100];
char loadpath[100] = "";

char *fix_fname(char *name)
{
  if (loadpath[0] && !strchr(name, '\\') && !strchr(name, '/'))
	sprintf(tempname, "%s\\%s", loadpath, name);
  else
	strcpy(tempname, name);
  return tempname;
}

