	TITLE	HORMATH - HORIZON INTERCEPT IN ASSEMBLER

	COMMENT $

// 26/12/93 by Dave Stampe
// All algorithms and code (c) 1993 by Dave Stampe

/*
 This code is part of the REND386 project, created by Dave Stampe and
 Bernie Roehl.

 Copyright 1992, 1993, 1994 by Dave Stampe and Bernie Roehl.

 May be freely used to write software for release into the public domain;
 all commercial endeavours MUST contact BOTH Bernie Roehl and Dave Stampe
 for permission to incorporate any part of this software into their
 products!  Usually there is no charge for under 50-100 items for
 low-cost or shareware, and terms are reasonable.  Any royalties are used
 for development, so equipment is often acceptable payment.

 ATTRIBUTION:  If you use any part of this source code or the libraries
 in your projects, you must give attribution to REND386, Dave Stampe,
 and Bernie Roehl in your documentation, source code, and at startup
 of your program.  Let's keep the freeware ball rolling!  No more
 code ripoffs please.

 CONTACTS: dstampe@psych.toronto.edu, broehl@sunee.uwaterloo.ca
 See the COPYRITE.H file for more information.
*/


/* Contact: dstampe@sunee.waterloo.edu */

		$

	.MODEL large
	.386

	.DATA

include 3dstruct.inc

	.CODE RENDERER

;/************ HORIZON IMPLEMENTATION MATH *****************/

; computes if point on screen is above or below horizon
; used to determine how to draw horizon
;
;int above_horizon(long x, long y, VIEW *v, long offst)


x	equ	[bp+8]          ; arguments
y	equ	[bp+12]
v	equ	[bp+16]
offst	equ	[bp+20]

scx	equ	es:[bx].VP_scx	; scaling from viewport coeffs
scy	equ	es:[bx].VP_scy
hsc	equ	es:[bx].VP_hsc	; viewport screen center offsets
vsc	equ	es:[bx].VP_vsc

B	equ	es:[bx].VP_xform01	; viewport matrix elements
E	equ	es:[bx].VP_xform11
H	equ	es:[bx].VP_xform21
orient	equ	es:[bx].VP_orientation	; viewport flip flags


	PUBLIC	_above_horizon

_above_horizon	proc	far

	.386
	push	ebp
	mov	ebp,esp

	push	ecx

	les	bx,DWORD PTR v

	mov	eax,x		; (x-hsc)*B/scx
	sub	eax,hsc
	imul	DWORD PTR B
	idiv	DWORD PTR scx
	test	orient,XFLIP
	je	pos_scx         ; flip sign if screen flipped
	neg	eax
pos_scx:
	mov	ecx,eax

	mov	eax,y           ; -(y-vsc)*E/scy
	neg	eax
	add	eax,vsc
	imul	DWORD PTR E
	idiv	DWORD PTR scy
	test	orient,YFLIP
	je	pos_scy         ; flip sign if screen flipped
	neg	eax
pos_scy:
	add	ecx,eax

	mov	eax,offst	; -(H+offset)
	shl	eax,16
	add	eax, H          ; shift aligns terms
	neg	eax
	sar	eax,16
	cmp	ecx,eax
	mov	ax,0
	jl	below
	inc	ax
below:			; return 1 if above, 0 if below horizon
	pop	ecx

	mov	esp,ebp
	pop	ebp
	ret

_above_horizon	endp



; computes x-intercept of horizon with x side of screen
;
;long y_horizon(long x, VIEW *v, long offst)


x	equ	[bp+8]          ; arguments
v	equ	[bp+12]
offst	equ	[bp+16]

scx	equ	es:[bx].VP_scx	; scaling from viewport coeffs
scy	equ	es:[bx].VP_scy
hsc	equ	es:[bx].VP_hsc	; viewport screen center offsets
vsc	equ	es:[bx].VP_vsc

B	equ	es:[bx].VP_xform01	; viewport matrix elements
E	equ	es:[bx].VP_xform11
H	equ	es:[bx].VP_xform21
orient	equ	es:[bx].VP_orientation	; viewport flip flags


	PUBLIC	_y_horizon

_y_horizon	proc	far

	.386
	push	ebp
	mov	ebp,esp

	les	bx,DWORD PTR v

	mov	eax,x		; (x-hsc)*B/scx
	sub	eax,hsc
	imul	DWORD PTR B
	idiv	DWORD PTR scx
	test	orient,XFLIP
	je	posy_scx         ; flip sign if screen flipped
	neg	eax
posy_scx:
	mov	edx,offst	; -(H+offset)
	shl	edx,16
	add	edx, H          ; shift aligns terms
	sar	edx,16
	add	eax,edx         ; add in
	neg	eax

	imul	DWORD PTR scy   ; vertical scaling
	idiv	DWORD PTR E
	test	orient,YFLIP
	je	posy_scy         ; flip sign if screen flipped
	neg	eax
posy_scy:
	neg	eax
	add	eax,vsc
	shld	edx,eax,16	; result returned in both eax and dx:ax

	mov	esp,ebp
	pop	ebp
	ret

_y_horizon	endp




; computes y-intercept of horizon with y top/bot of screen
;
;long x_horizon(long y, VIEW *v, long offst)


y	equ	[bp+8]          ; arguments
v	equ	[bp+12]
offst	equ	[bp+16]

scx	equ	es:[bx].VP_scx	; scaling from viewport coeffs
scy	equ	es:[bx].VP_scy
hsc	equ	es:[bx].VP_hsc	; viewport screen center offsets
vsc	equ	es:[bx].VP_vsc

B	equ	es:[bx].VP_xform01	; viewport matrix elements
E	equ	es:[bx].VP_xform11
H	equ	es:[bx].VP_xform21
orient	equ	es:[bx].VP_orientation	; viewport flip flags


	PUBLIC	_x_horizon

_x_horizon	proc	far

	.386
	push	ebp
	mov	ebp,esp

	les	bx,DWORD PTR v

	mov	eax,y		; -(y-vsc)*E/scy
	sub	eax,vsc
	neg	eax
	imul	DWORD PTR E
	idiv	DWORD PTR scy
	test	orient,YFLIP
	je	posx_scy         ; flip sign if screen flipped
	neg	eax
posx_scy:
	mov	edx,offst	; -(H+offset)
	shl	edx,16
	add	edx, H          ; shift aligns terms
	sar	edx,16
	add	eax,edx         ; add in
	neg	eax

	imul	DWORD PTR scx   ; vertical scaling
	idiv	DWORD PTR B
	test	orient,XFLIP
	je	posx_scx         ; flip sign if screen flipped
	neg	eax
posx_scx:
	add	eax,hsc
	shld	edx,eax,16	; result returned in both eax and dx:ax

	mov	esp,ebp
	pop	ebp
	ret

_x_horizon	endp



	end