	TITLE	INTSPLIT - Splitting-tree assembly routines (should be private to splits.c)


	COMMENT	$
/*
 This code is part of the VR-386 project, created by Dave Stampe.
 VR-386 is a desendent of REND386, created by Dave Stampe and
 Bernie Roehl.  Almost all the code has been rewritten by Dave
 Stampre for VR-386.

 Copyright (c) 1994 by Dave Stampe:
 May be freely used to write software for release into the public domain
 or for educational use; all commercial endeavours MUST contact Dave Stampe
 (dstampe@psych.toronto.edu) for permission to incorporate any part of
 this software or source code into their products!  Usually there is no
 charge for under 50-100 items for low-cost or shareware products, and terms
 are reasonable.  Any royalties are used for development, so equipment is
 often acceptable payment.

 ATTRIBUTION:  If you use any part of this source code or the libraries
 in your projects, you must give attribution to VR-386 and Dave Stampe,
 and any other authors in your documentation, source code, and at startup
 of your program.  Let's keep the freeware ball rolling!

 DEVELOPMENT: VR-386 is a effort to develop the process started by
 REND386, improving programmer access by rewriting the code and supplying
 a standard API.  If you write improvements, add new functions rather
 than rewriting current functions.  This will make it possible to
 include you improved code in the next API release.  YOU can help advance
 VR-386.  Comments on the API are welcome.

 CONTACT: dstampe@psych.toronto.edu
*/



All code in this module by Dave Stampe
Splits are an important part of VR-386: this code makes them work
faster.  Probably not needed for a true 32-bit compiler.

		$

		.MODEL large

include splitdef.inc

;int _which_side(SPLIT *s, long tx,long ty,long tz)
;{

		.CODE INTMATH

s	equ	[bp+8]          ; arguments
tx	equ	[bp+12]
ty	equ	[bp+16]
tz	equ	[bp+20]

side	equ	[bp-4]		; locals




		PUBLIC	__which_side

__which_side 	proc	far

	.386
	push	ebp
	mov	ebp,esp
	sub	esp,4
	push 	ecx
	push 	edi
	les 	bx,DWORD PTR s
	mov	DWORD PTR side,-1

	mov 	eax,DWORD PTR es:[bx].split_nx ; dot prod.
	mov 	edx,DWORD PTR tx               ; Ns . (t-s)
	sub 	edx,DWORD PTR es:[bx].split_x
	imul 	edx
	mov 	ecx,eax
	mov 	edi,edx
	mov 	eax,DWORD PTR es:[bx].split_ny
	mov 	edx,DWORD PTR ty
	sub 	edx,DWORD PTR es:[bx].split_y
	imul 	edx
	add 	ecx,eax
	adc 	edi,edx
	mov 	eax,DWORD PTR es:[bx].split_nz
	mov 	edx,DWORD PTR tz
	sub 	edx,DWORD PTR es:[bx].split_z
	imul 	edx
	add 	ecx,eax
	adc 	edi,edx            ; negative
	jl 	alldone
	neg	DWORD PTR side
	or 	edi,ecx            ; positive
	jnz 	alldone
	mov 	WORD PTR side, di  ; zero:
alldone:
	mov	eax,side
	pop 	edi
	pop 	ecx
	mov	esp,ebp
	pop	ebp
	ret

__which_side	endp



;void *_fast_split_descent(SPLIT *tree, long x, long y, long z, char *type)


tree	equ	[bp+8]          ; arguments
x	equ	[bp+12]
y	equ	[bp+16]
z	equ	[bp+20]
type	equ	[bp+24]


	PUBLIC	__fast_split_descent

__fast_split_descent	proc	far

	.386
	push	ebp
	mov	ebp,esp
	push 	esi
	push 	ecx
	les 	bx,DWORD PTR tree
next:
	or 	bx,bx		; test for NULL ptr
	jz 	endtree
	mov 	eax,DWORD PTR es:[bx].split_nx ; side-of-surface dot product
	mov 	edx,DWORD PTR x
	sub 	edx,DWORD PTR es:[bx].split_x
	imul 	edx
	mov 	esi,eax
	mov 	ecx,edx
	mov 	eax,DWORD PTR es:[bx].split_ny
	mov 	edx,DWORD PTR y
	sub 	edx,DWORD PTR es:[bx].split_y
	imul 	edx
	add 	esi,eax
	adc 	ecx,edx
	mov 	eax,DWORD PTR es:[bx].split_nz
	mov 	edx,DWORD PTR z
	sub 	edx,DWORD PTR es:[bx].split_z
	imul 	edx
	add 	esi,eax
	adc 	ecx,edx	; positive/zero
	jge 	right
	mov 	al,BYTE PTR es:bx.split_ltype  ; left walk
	les 	bx,DWORD PTR es:bx.split_leftptr
	cmp 	al,ISSPLIT
	je 	next
	jmp 	endtree
right:
	mov 	al,BYTE PTR es:bx.split_rtype
	les 	bx,DWORD PTR es:bx.split_rightptr
	cmp 	al,ISSPLIT
	je 	next
endtree:
	mov 	cl,al
	mov 	ax,bx
	mov 	dx,es
	les 	bx,DWORD PTR type
	mov 	es:bx,cl

	pop 	ecx
	pop 	esi
	mov	esp,ebp
	pop	ebp
	ret

__fast_split_descent	endp


	end
