/* Segment file i/o  <actually FIG files> */
/* segments are usually created and linked in the .WLD files */

/* Original code written by Bernie Roehl, March 1992 */
/* Completely redone for VR-386 by Dave Stampe, 1/1/94

/*
 This code is part of the VR-386 project, created by Dave Stampe.
 VR-386 is a desendent of REND386, created by Dave Stampe and
 Bernie Roehl.  Almost all the code has been rewritten by Dave
 Stampre for VR-386.

 Copyright (c) 1994 by Dave Stampe:
 May be freely used to write software for release into the public domain
 or for educational use; all commercial endeavours MUST contact Dave Stampe
 (dstampe@psych.toronto.edu) for permission to incorporate any part of
 this software or source code into their products!  Usually there is no
 charge for under 50-100 items for low-cost or shareware products, and terms
 are reasonable.  Any royalties are used for development, so equipment is
 often acceptable payment.

 ATTRIBUTION:  If you use any part of this source code or the libraries
 in your projects, you must give attribution to VR-386 and Dave Stampe,
 and any other authors in your documentation, source code, and at startup
 of your program.  Let's keep the freeware ball rolling!

 DEVELOPMENT: VR-386 is a effort to develop the process started by
 REND386, improving programmer access by rewriting the code and supplying
 a standard API.  If you write improvements, add new functions rather
 than rewriting current functions.  This will make it possible to
 include you improved code in the next API release.  YOU can help advance
 VR-386.  Comments on the API are welcome.

 CONTACT: dstampe@psych.toronto.edu
*/


#include <stdio.h>
#include <stdlib.h>
#include <ctype.h>
#include <string.h>

#include "vr_api.h"
#include "intmath.h"  /* for RYZ definition */
#include "segment.h"

extern char *fix_fname(char *fname);

static int readseg_err = 0;

static char *seg_errmsgs[] = {
	"No error",
	"Couldn't open plg file",
	"Error reading plg file",
	"Bad syntax",
	"Couldn't open map file",
	NULL };


static char errm[50];

char *seg_error(int *errnum)
{
  if(errnum) *errnum = readseg_err;
  if(!readseg_err) return NULL;
  sprintf(errm, "FIG load error: %s", seg_errmsgs[-readseg_err]);
  return errm;
}


#define match(a, b) (!strnicmp((a), (b), strlen(b)))

extern OBJLIST *default_objlist;

static OBJLIST *seg_olist;

static SEGMENT **seg_array = NULL;
static int seg_array_size = 0;

static float seg_sx = 1; /* for pos'n and rotate, just */
static float seg_sy = 1; /* attach a parent, update,   */
static float seg_sz = 1; /* then detach it again       */

static int process_attribute(char *buff, OBJECT *seg)
{
  char filename[100];
  int depth = 0;
  FILE *in;

  while (isspace(*buff)) ++buff;
  if (match(buff, "plgfile"))
    {
      float sx = 1, sy = 1, sz = 1;
      OBJECT *obj;
      POSE p = ZERO_POSE;

      sscanf(buff, "plgfile = %s scale %f,%f,%f shift %ld,%ld,%ld sort %d", filename, &sx, &sy, &sz, &p.x, &p.y, &p.z, &depth);
      if ((in = fopen(fix_fname(filename), "r")) == NULL)
	{
	  readseg_err = -1;
	  return -1;
	}
      p.x *= seg_sx;
      p.y *= seg_sy;
      p.z *= seg_sz;
      obj = load_plg_object(in, &p, sx*seg_sx, sy*seg_sy, sz*seg_sz, depth);
      if (!obj)
	{
	  readseg_err = -2;
	  fclose(in);
	  return -2;
	}
      add_to_objlist(seg_olist, obj);
      seg = make_fixed_object_moveable(obj, seg);
      fclose(in);
      return 0;
    }
  else if (match(buff, "pos"))
    {
      POSE p = DONTCARE_POSE;

      sscanf(buff, "pos = %ld,%ld,%ld", &p.x, &p.y, &p.z);
      p.x *= seg_sx;
      p.y *= seg_sy;
      p.z *= seg_sz;
      set_object_pose(seg, &p);
    }
  else if (match(buff, "rot"))
    {
      POSE p = DONTCARE_POSE;
      float rx, ry, rz;

      sscanf(buff, "rot = %f,%f,%f", &rx, &ry, &rz);
      p.rx = float2angle(rx);
      p.ry = float2angle(ry);
      p.rz = float2angle(rz);
      set_object_pose(seg, &p);
    }
  else if (match(buff, "name"))
    {
      char *p;
      if ((p = strchr(buff, '=')) == NULL)
	{
	  readseg_err = -3;
	  return -3;
	}
      do ++p; while (isspace(*p));
      seg_setname(seg, p);
    }
  else if (match(buff, "segnum"))
    {
      int j;
      sscanf(buff, "segnum = %d", &j);
      if (seg_array && j < seg_array_size) seg_array[j] = seg;
    }
	/* ignore anything we don't understand */
 return 0;
}


static SEGMENT *readseg(FILE *in, SEGMENT *parent)
{
  SEGMENT *seg;
  char buff[256];
  int c, i = 0;

  seg = create_invisible_object();     // create, link new object
  if(!seg) return NULL;
  if(parent) naked_attach_object(seg, parent);

  while ((c = getc(in)) != EOF)
    {
      switch (c)
	{
	  case '#':
		while ((c = getc(in)) != EOF)    // comment: skip
			if (c == '\n')
				break;
		break;
	  case '{':                              // new layer
		readseg(in, seg);
		break;
	  case '}':                              // end of layer
		return seg;
	  case ';':
		buff[i] = '\0';                  // move or load appearance
		process_attribute(buff, seg);
		i = 0;
		break;
	  default:                               // debug
		if (i < sizeof(buff)-1) buff[i++] = c;
		break;
	}
    }
  return seg;
}


OBJECT *load_figure_as_object(FILE *in, OBJLIST *olist, OBJECT **segtable,
			      WORD stmax, float sx, float sy, float sz)
{
  seg_olist = olist;
  if(!olist) seg_olist = default_objlist;
  seg_array = segtable;
  seg_array_size = stmax;
  seg_sx = sx;
  seg_sy = sy;
  seg_sz = sz;
  readseg_err = 0;
  return readseg(in, create_invisible_object());
}
