// new MEMLIST memory management
// 1/1/94 by Dave Stampe


/*
 This code is part of the REND386 project, created by Dave Stampe and
 Bernie Roehl.

 Copyright 1992, 1993, 1994 by Dave Stampe and Bernie Roehl.

 May be freely used to write software for release into the public domain;
 all commercial endeavours MUST contact BOTH Bernie Roehl and Dave Stampe
 for permission to incorporate any part of this software into their
 products!  Usually there is no charge for under 50-100 items for
 low-cost or shareware, and terms are reasonable.  Any royalties are used
 for development, so equipment is often acceptable payment.

 ATTRIBUTION:  If you use any part of this source code or the libraries
 in your projects, you must give attribution to REND386, Dave Stampe,
 and Bernie Roehl in your documentation, source code, and at startup
 of your program.  Let's keep the freeware ball rolling!  No more
 code ripoffs please.

 CONTACTS: dstampe@psych.toronto.edu, broehl@sunee.uwaterloo.ca
 See the COPYRITE.H file for more information.
*/


#include <stdio.h>
#include <stdlib.h>  /* for atol(), only for debugging! */
#include <dos.h>
#include <string.h>
#include <alloc.h>


#ifndef DEFMB

struct _mb_ {
	      struct _mb_ *prev;    // header of memory
	      struct _mb_ *next;
	  } ;

typedef struct _mb_ MEMBLOCK;

typedef struct {                    // head of memory list
		 MEMBLOCK *prev;    // USUALLY STATIC MEMORY
		 MEMBLOCK *next;
	       } MEMLIST;
#endif
#define DEFMB 1

#define INIT_MEMLIST { NULL,NULL }	// store in new memlist header
// example:
// MEMLIST env_memlist = INIT_MEMLIST;

#define ptr2memblock(p) MK_FP(FP_SEG(p),FP_OFF(p)-(2*sizeof(MEMBLOCK *)))
#define memblock2ptr(p) MK_FP(FP_SEG(p),FP_OFF(p)+(2*sizeof(MEMBLOCK *)))


#include "vr_api.h"
#include "rend386.h"
#include "intmath.h"



static MEMLIST *current_memory_list = NULL;

	// set list which memory will be recorded to
	// returns old list if any
MEMLIST *set_memory_list(MEMLIST *m)
{
  MEMLIST *old = current_memory_list;
  current_memory_list = m;
  return old;
}


void *listalloc(long size)       // to default list
{
  MEMBLOCK *m;

  if(current_memory_list==NULL) return malloc(size);
  m = malloc(size + 2*sizeof(MEMBLOCK *));
  if(!m) return NULL;
  m->next = current_memory_list->next;	// add to list
  m->prev = current_memory_list;
  return memblock2ptr(m);
}


void *listcalloc(long size, long count)   // to default list
{
  void *p;

  if(current_memory_list==NULL) return calloc(size, count);
  p = listalloc(size*count);
  if(!p) return NULL;
  memset(p, 0, size*count);
  return p;
}


void listfree(void *p)		// any list
{
  MEMBLOCK *m = ptr2memblock(p);

  if(!p) return;	// sanity check

  if(m->prev)	// can't delete header!
    {
      m->prev->next = m->next;
      if(m->next)
	 m->next->prev = m->prev;
      free(m);
    }
}


void listfreeall(MEMLIST *p)	// any list
{
  if(!p) return;	// sanity check
  while(p->next)
    {
      p->next = p->next->next;
      free(p->next);
    }
}


void *xlistalloc(long size, MEMLIST *list)	// specific list
{
  MEMBLOCK *m;

  if(current_memory_list==NULL) return malloc(size);
  m = malloc(size + 2*sizeof(MEMBLOCK *));
  if(!m) return NULL;
  m->next = current_memory_list->next;	// add to list
  m->prev = current_memory_list;
  return memblock2ptr(m);
}


void *xlistcalloc(long size, long count, MEMLIST *list)	// specific list
{
  void *p;

  if(current_memory_list==NULL) return calloc(size, count);
  p = listalloc(size*count);
  if(!p) return NULL;
  memset(p, 0, size*count);
  return p;
}



////////////////////////////////////////////////////
/// WORLD MANAGEMENT:
/// allows suspension, resumption, freeing of memory
/// also loading (some)


/// WORLD STATICS


//CAMERA *default_camera;
//CAMERA *current_camera;
//POSE initial_body_pose;
//POSE *home_pose;
//POSE *body_pose;


WORLD *create_world()
{
}

void release_world(WORLD *w)
{

  free(w);
}

void save_world_state(WORLD *w)
{
}

void restore_world_state(WORLD *w)
{
}

void load_world(FILE *in, WORLD *w)
{
}
