/* Keyboard routines and menus for VRC release */

/* Original simple keyboard was written by Bernie Roehl, July 1992 */

// MASSIVELY rewritten, along with entire menu and navigation
// system, by Dave Stampe for Release 5 (VRC), Nov. 92.

// some changes made to support horizon and key monitor, 12/24/93

// Completely rearranged, substantial mods, ported to VR-386 API 9/1/94


// THIS IS A TINY VERSION FOR MINI DEMO

/*
 This code is part of the VR-386 project, created by Dave Stampe.
 VR-386 is a desendent of REND386, created by Dave Stampe and
 Bernie Roehl.  Almost all the code has been rewritten by Dave
 Stampre for VR-386.

 Copyright (c) 1994 by Dave Stampe:
 May be freely used to write software for release into the public domain
 or for educational use; all commercial endeavours MUST contact Dave Stampe
 (dstampe@psych.toronto.edu) for permission to incorporate any part of
 this software or source code into their products!  Usually there is no
 charge for under 50-100 items for low-cost or shareware products, and terms
 are reasonable.  Any royalties are used for development, so equipment is
 often acceptable payment.

 ATTRIBUTION:  If you use any part of this source code or the libraries
 in your projects, you must give attribution to VR-386 and Dave Stampe,
 and any other authors in your documentation, source code, and at startup
 of your program.  Let's keep the freeware ball rolling!

 DEVELOPMENT: VR-386 is a effort to develop the process started by
 REND386, improving programmer access by rewriting the code and supplying
 a standard API.  If you write improvements, add new functions rather
 than rewriting current functions.  This will make it possible to
 include you improved code in the next API release.  YOU can help advance
 VR-386.  Comments on the API are welcome.

 CONTACT: dstampe@psych.toronto.edu
*/

#include <stdio.h>
#include <stdlib.h>  /* for atol(), only for debugging! */
#include <dos.h>
#include <time.h>    /* time(), ctime() */
#include <string.h>
#include <math.h>
#include <alloc.h>

#include "config.h"
#include "pointer.h"
#include "vr_api.h"
#include "intmath.h"
#include "segment.h"
#include "splits.h"
#include "pcdevice.h"	// last_render_time()
#include "vrconst.h"

extern char *fix_fname(char *fname);

extern manip_2D_avail;

extern void set_horizon(int ncolors, int colors[16], int bandsize);

extern int do_screen_clear, do_horizon;
extern int show_location, show_compass, show_framerate;

extern LIGHT *amb_light, *light1, *light2;

static int sstepsize = 10;	/* speed multipliers */
static int astepsize = 2;

long anglestep = 160000L;
long spacestep = 10L;

int spinmode = 0;
extern int flymode;

/******************* MENU TEXT **************/

static char *mainmenu[] = {
	"Help",
	"Information",
	"View menu",
	"Paint menu",
	"Display menu",
	"Object menu",
	"Figure menu",
	"Mouse menu",
	"Quit",
	NULL
};


/********************** KEY INTERPERTER *****************/


extern BOOL process_motion_keys(unsigned key);

BOOL process_display_keys(unsigned c)	// processes and display setup keys
{
  int i, j;

  switch (c)
	{
	case CTRLLEFT:
		i = +1;
		goto set_shift;
	case CTRLRIGHT:
		i = -1;
	  set_shift:
		if (current_camera->stereo->window[LEFT_EYE].orientation&XFLIP)
		   current_camera->stereo->window[LEFT_EYE].xoff += i;
		else
		   current_camera->stereo->window[LEFT_EYE].xoff -= i;

		if (current_camera->stereo->window[RIGHT_EYE].orientation&XFLIP)
		   current_camera->stereo->window[RIGHT_EYE].xoff -= i;
		else
		   current_camera->stereo->window[RIGHT_EYE].xoff += i;

		compute_camera_factors(current_camera);
		display_changed++;
		break;
	case '+':
		if (stereo_type == MONOSCOPIC)
		  {
		    SCALE z = get_camera_zoom(current_camera);
		    z *= 1.1;
		    if(z<65536L*0.5) z = 65536L*0.5;
		    if(z>65536L*16.0) z = 65536L*16.0;
		    set_camera_zoom(current_camera,z);
		  }
		else
		  {
		    if(current_camera->stereo->phys_screen_dist>30)
			current_camera->stereo->phys_screen_dist *= 1.05;
		    else current_camera->stereo->phys_screen_dist *= 1.25;
		  }
		compute_camera_factors(current_camera);
		display_changed++;
		break;
	case '-':
		if (stereo_type == MONOSCOPIC)
		  {
		    SCALE z = get_camera_zoom(current_camera);
		    z /= 1.1;
		    if(z<65536L*0.5) z = 65536L*0.5;
		    if(z>65536L*16.0) z = 65536L*16.0;
		    set_camera_zoom(current_camera,z);
		    compute_camera_factors(current_camera);
		    display_changed++;
		    break;
		  }
		else
		  {
		    current_camera->stereo->phys_screen_dist /= 1.05;
		    if(current_camera->stereo->phys_screen_dist<5)
		       current_camera->stereo->phys_screen_dist = 5;
		  }
		 compute_camera_factors(current_camera);
		 display_changed++;
		 break;
	case '@':
		if (stereo_type != MONOSCOPIC)
		  {
		    current_camera->stereo->phys_eye_spacing /= 1.05;
		    if(current_camera->stereo->phys_eye_spacing<5)
			current_camera->stereo->phys_eye_spacing = 5;
		    compute_camera_factors(current_camera);
		    display_changed++;
		  }
		break;
	case '!':
		if (stereo_type != MONOSCOPIC)
		  {
		    if(current_camera->stereo->phys_eye_spacing>30)
		       current_camera->stereo->phys_eye_spacing *= 1.05;
		    else
		       current_camera->stereo->phys_eye_spacing *= 1.25;
		    compute_camera_factors(current_camera);
		    display_changed++;
		  }
		break;
	default:
		return FALSE;
    }
 return TRUE;
}


BOOL process_system_keys(unsigned c)	// processes quit, etc
{
  int i, j;

  switch (c)
	{
	case 'Q':
	case ESC:
		popmsg("Really quit?");
		i = get_response(1);
		if (toupper(i)=='Y') running = 0;
		else restore_screen();
		break;
	default:
		return FALSE;
    }
  return TRUE;
}

extern int mouse_nav;

static int movemults[] = { 1,2,3,5,7,10,13,17,22,28};  // speed, angles
static int angmults[] =  { 1,1,1,1,2,2,2,3,4,5};       // 0-9 scale factors


BOOL process_extmove_keys(unsigned c)	// processes daata-display keys
{
  int i, j;

  switch (c)
	{

	case '*':   /* level view */
		body_pose->rx = body_pose->rz = 0;
		display_changed++;
		break;

	case 'U':
		body_pose->ry += 180*65536L;
		position_changed++;
		break;

	case '0':
		sstepsize = movemults[9];
		astepsize = angmults[9];
		break;
	case '1':
	case '2':
	case '3':
	case '4':
	case '5':
	case '6':
	case '7':
	case '8':
	case '9':
		sstepsize = movemults[c - '1'];
		astepsize = angmults[c - '1'];
		break;

	case 'J':
		mouse_nav = !mouse_nav;     // toggle mouse joy
		if(manip_2D_avail)
		  cursor_enable(!mouse_nav);  // cursor on/off
		break;


	default:
		return FALSE;
    }
  return TRUE;
}


/************ API KEY HANDLER **************/

void process_a_key(unsigned c)	// processes key <c>
{
  int i, j;

  if(c<0x7f)
     if(isalpha(c))
	c = toupper(c);

  if(process_motion_keys(c)) return;
  if(process_display_keys(c)) return;
  if(process_system_keys(c)) return;
  if(process_extmove_keys(c)) return;

  if(process_minidemo_keys(c)) return;
}


void key_process()	// reads, processes keys
{
  unsigned c;

  if (!bioskey(1)) return;
  c = getkey();			// read a key
  while(bioskey(1)) getkey();   // dump others

  process_a_key(c);
}


/************ API JOYSTICK HANDLER **************/


void joystick_process()
{
  if(do_joy_navigate(body_pose,
	    spinmode, spacestep*sstepsize, astepsize*anglestep, flymode))
      position_changed ++;

// NO SPIN MODE FOR MINI DEMO
//
// if (position_changed && spinmode)         // SPECIAL: spin mode move xlat
//			spin_mode_compute();
}

