// THESE ARE ROUTINES FOR THE MINI DEMO
// Loads 3 x figures (not in world), 1 x object (in world)
// A,B,C keys toggle figures in and out of world

/*
 This code is part of the VR-386 project, created by Dave Stampe.
 VR-386 is a desendent of REND386, created by Dave Stampe and
 Bernie Roehl.  Almost all the code has been rewritten by Dave
 Stampre for VR-386.

 Copyright (c) 1994 by Dave Stampe:
 May be freely used to write software for release into the public domain
 or for educational use; all commercial endeavours MUST contact Dave Stampe
 (dstampe@psych.toronto.edu) for permission to incorporate any part of
 this software or source code into their products!  Usually there is no
 charge for under 50-100 items for low-cost or shareware products, and terms
 are reasonable.  Any royalties are used for development, so equipment is
 often acceptable payment.

 ATTRIBUTION:  If you use any part of this source code or the libraries
 in your projects, you must give attribution to VR-386 and Dave Stampe,
 and any other authors in your documentation, source code, and at startup
 of your program.  Let's keep the freeware ball rolling!

 DEVELOPMENT: VR-386 is a effort to develop the process started by
 REND386, improving programmer access by rewriting the code and supplying
 a standard API.  If you write improvements, add new functions rather
 than rewriting current functions.  This will make it possible to
 include you improved code in the next API release.  YOU can help advance
 VR-386.  Comments on the API are welcome.

 CONTACT: dstampe@psych.toronto.edu
*/

#include <stdio.h>
#include <stdlib.h>  /* for atol(), only for debugging! */
#include <dos.h>

#include "config.h"
#include "vr_api.h"
#include "intmath.h"
#include "vrconst.h"

extern char *fix_fname(char *fname);

char *figname[3] = {"metalman.fig", "metalman.fig", "metalman.fig"} ;

OBJECT *figs[3] = {NULL,NULL,NULL};     // roots of figures

					// map hue of objects on loading
SURFACEPAIR figmaps[3][6] = {
 0x800,0x100, 0x900,0x200, 0xa00,0x300, 0xb00,0x400, 0xc00,0x500, 0xd00,0x600,
 0x800,0xf00, 0x900,0xe00, 0xa00,0xd00, 0xb00,0xc00, 0xc00,0xb00, 0xd00,0xa00,
 0x800,0xb00, 0x900,0xa00, 0xa00,0x900, 0xb00,0x800, 0xc00,0x700, 0xd00,0x600
			    };
						    // 2000000L == 30 degrees
POSE figpose[3] = {-1500, 0, -3000, 0, -2000000L,  2000000L,
		       0, 0, -3000, 0,        0L,        0L,
		    1500, 0, -3000, 0,  2000000L, -2000000L   };

BOOL fig_in_world[3] = {1,1,1};

minidemo_load()
{
  int i;
  OBJECT *obj;
  FILE *fig;

  for(i=0;i<3;i++)
    {
      if(!(fig = fopen(figname[i],"r"))) continue;
      obj = load_figure_as_object(fig, default_objlist, NULL, 0, 1, 1, 1);
      if (obj)
	{
	  figs[i] = obj;
	  objlist_remap_surface(default_objlist, &(figmaps[i][0]), 6, MAP_HUE_MASK, MAP_HUE_MASK);
	  set_object_pose(figs[i], &figpose[i]);
	  update_object(figs[i]);
	  if(fig_in_world[i])
	      add_objlist_to_world(default_objlist);
	  else
	      merge_objlists(default_objlist, inactive_object_list);
	}
      fclose(fig);
    }
}


toggle_figure(int i)
{
  if(i>2) return;
  fig_in_world[i] = !fig_in_world[i];
  if(fig_in_world[i])
     do_for_all_child_objects(figs[i], add_object_to_world);
  else
     do_for_all_child_objects(figs[i], remove_object_from_world);
  world_changed++;
}


/*************** MINI DEMO MENU **************/

static char *minimenu[] = {
	"figure A",
	"figure B",
	"figure C",
	"Quit",
	NULL
};


BOOL process_minidemo_keys(unsigned c)	// processes quit, etc
{
  int i, j;

  switch (c)
	{
	case 'Q':
	case ESC:
		popmsg("Really quit?");
		i = get_response(1);
		if (toupper(i)=='Y') running = 0;
		else restore_screen();
		break;
	case 'A':
	case 'B':
	case 'C':
		toggle_figure(c-'A');	// figure toggle
		break;
	case 'X':
		{
		  process_a_key(menu(minimenu));  // mini menu callup
		  restore_screen();
		  break;
		}
	default:
		return FALSE;
    }
  return TRUE;
}

