// This module: routines that affect the PC timer
// these are private to these modules

// Prototypes required for the following modules:
// joytimer.asm
// joystick.c
// glovdelh.asm
// sgsppt.c
// timer.c

/*
 This code is part of the VR-386 project, created by Dave Stampe.
 VR-386 is a desendent of REND386, created by Dave Stampe and
 Bernie Roehl.  Almost all the code has been rewritten by Dave
 Stampre for VR-386.

 Copyright (c) 1994 by Dave Stampe:
 May be freely used to write software for release into the public domain
 or for educational use; all commercial endeavours MUST contact Dave Stampe
 (dstampe@psych.toronto.edu) for permission to incorporate any part of
 this software or source code into their products!  Usually there is no
 charge for under 50-100 items for low-cost or shareware products, and terms
 are reasonable.  Any royalties are used for development, so equipment is
 often acceptable payment.

 ATTRIBUTION:  If you use any part of this source code or the libraries
 in your projects, you must give attribution to VR-386 and Dave Stampe,
 and any other authors in your documentation, source code, and at startup
 of your program.  Let's keep the freeware ball rolling!

 DEVELOPMENT: VR-386 is a effort to develop the process started by
 REND386, improving programmer access by rewriting the code and supplying
 a standard API.  If you write improvements, add new functions rather
 than rewriting current functions.  This will make it possible to
 include you improved code in the next API release.  YOU can help advance
 VR-386.  Comments on the API are welcome.

 CONTACT: dstampe@psych.toronto.edu
*/



/************ PRIVATE TIMER SUPPORT **********/

/* for joytimer.asm */

extern timer_tick_count;	// number of interrupts so far
extern timer_vsync_count; 	// timer counts per video frame
extern ticks_per_second; 	// counter time basis
extern counts_per_tick; 	// counter time setting (keep current!)

extern int timer_frame_interval;  // number of ticks per frame
extern int frame_resync_interval; // number of frames between resyncs

				   // tf is ticks till frame end:
				   // if 0, at end of frame!
				   // called once per tick
extern void (*timer_interrupt_hook)(int tf); // timer tick interrupt
extern void (*frame_interrupt_hook)(int tf); //frame-end interrupt (arg=0)

unsigned find_vsync_count();     // returns frame time in 1.19 MHz counts
int write_timer(unsigned count); // sets timer count

void __interrupt __far kbrd_isr();  // hooks kbrd interrupt
void __interrupt __far timer_isr();  // does timer interrupt stuff


/************ JOYSTICK LOW_LEVEL I/O *************/

extern int joystick_j1;	   /* raw joystick results */
extern int joystick_j2;       /* updates after raw_joystick_read() */
extern int joystick_j3;
extern int joystick_j4;
extern int joystick_buttons;
				 // range of 0 to 1200 on read
				 // buttons has 4 bits
				 // mask is 3 for joy1, 12 for joy2
				 // and 15 for both

int raw_joystick_read(int mask); /* reads joystick to above variables */
				 /* returns 0 if read successful      */
				 /* else try repeating it later       */

/*********** TIMER ROUTINES ************/

unsigned read_timer();    // reads current timer count: scale varies

long current_time(); 	  // returns time in msec

/************ KEYBOARD MONITOR ROUTINES *********/

extern int init_key_monitor();	// enables key monitor
	// useful to turn it off, cause debuggers hate it!
	// returns 0 if already on, else 1

extern int is_key_down(int keycode);	// tests if key(keycode) is down
				// some useful keycodes:

#define UP_CURSOR_KEYCODE	0x48
#define DOWN_CURSOR_KEYCODE	0x50
#define LEFT_CURSOR_KEYCODE	0x4B
#define RIGHT_CURSOR_KEYCODE	0x4D

#define LEFT_SHIFT_KEYCODE	0x2A
#define RIGHT_SHIFT_KEYCODE	0x36


/************* POWERGLOVE AND SEGA *********/
// mainly for pwrglvio.asm

extern int port_image;
extern int sega_port_image;

extern unsigned int timed_glove_delay(int count);
	/* returns time in 1.1925 MHZ ticks */
	/* to perform <count> delay steps   */
	/* call with timer at 18.2 Hz rate  */

extern int glove_delay(int count);  /* performs <count> delay steps   */

extern int get_glove_byte(void);  /* reads a byte from glove */

extern void set_glove_bits(int data);  /* sets glove clock, data lines */
				       /* and does a bit delay         */

extern void glove_int_handler();	// powerglove isr routine


// more stuff for Sega

extern int left_page;      /* left image */
extern int right_page;     /* right image */
extern volatile int has_switched;   /* = 3 once both switched in */

extern int sega_left;	// LCD driver config fdata
extern int sega_right;
extern int sega_address;
extern int sega_mask;
extern int sega_doff;


extern void select_sega_port(int port);  /* sets up default Sega data */

extern void switch_sega(int to_go);   // LCD ISR routine

extern void sega_off(); 	// disable LCD to prolong life


#define SW_INIT        0	// commands to switch ptr driver
#define SW_QUIT        1
#define SW_ADV_SWITCH  2
#define SW_SYNC_SWITCH 3


extern int (*switch_driver)();   // if NULL, use internal driver




