/* Prototypes for low-level graphics routines */

// ALL ROUTINES BY DAVE STAMPE
// These serve for both loadable and linked video drivers

/*
 This code is part of the VR-386 project, created by Dave Stampe.
 VR-386 is a desendent of REND386, created by Dave Stampe and
 Bernie Roehl.  Almost all the code has been rewritten by Dave
 Stampre for VR-386.

 Copyright (c) 1994 by Dave Stampe:
 May be freely used to write software for release into the public domain
 or for educational use; all commercial endeavours MUST contact Dave Stampe
 (dstampe@psych.toronto.edu) for permission to incorporate any part of
 this software or source code into their products!  Usually there is no
 charge for under 50-100 items for low-cost or shareware products, and terms
 are reasonable.  Any royalties are used for development, so equipment is
 often acceptable payment.

 ATTRIBUTION:  If you use any part of this source code or the libraries
 in your projects, you must give attribution to VR-386 and Dave Stampe,
 and any other authors in your documentation, source code, and at startup
 of your program.  Let's keep the freeware ball rolling!

 DEVELOPMENT: VR-386 is a effort to develop the process started by
 REND386, improving programmer access by rewriting the code and supplying
 a standard API.  If you write improvements, add new functions rather
 than rewriting current functions.  This will make it possible to
 include you improved code in the next API release.  YOU can help advance
 VR-386.  Comments on the API are welcome.

 CONTACT: dstampe@psych.toronto.edu
*/



#define MAIN_VGA  1  /* for multi-VGA only */
#define LEFT_VGA  2
#define RIGHT_VGA 4
#define ALL_VGA   7

extern void far VGA_select(int card);	// select in multiVGA card

extern void *far screen_data(void);    // returns pointer to driver data

extern void far vsync(void);            /* pause till vert. retrace */

extern void far set_vpage(int page);    /* set video page thru BIOS */


#define PUT 0		/* defines of VGA write modes */
#define AND 1           /* for use with setup_hdwe()  */
#define OR  2           /* only 0 supported for most drivers */
#define XOR 3

extern void far setup_hdwe(int mode);  /* setup VGA for bunch of line */
				       /* or poly draws: once per set */

extern void far reset_hdwe(void);  /* reset VGA to BIOS state after drawing */

			 /* clear video page to solid color: 10 mS */
			 /* returns -1 if bad page #		 */
extern int far clr_page(int page, int color);

			/* copy one page to another for use as */
			/* background: 21 mS per call          */
			/* returns -1 if bad page #            */
extern int far copy_page(int source, int dest);

			/* fast VGA line draw: about 15600 24-pixel */
			/* vectors/sec (horizontal much faster)     */
extern void far vgaline(int x1, int y1, int x2, int y2, int color);

			/* VGA point set; no clipping */
extern void far vgapoint(int x, int y, int color);

			/* does C-S clipping and draws line   */
extern void far clipline(int x1, int y1, int x2, int y2, int color);

extern void far set_gmode(int mode);  /* enters graphics mode
		//  (some drivers accept argument), clears screen */

extern void far exit_gmode(void);     /* exits to text mode */

extern void far set_vpage(int page);   /* set page for display */

extern int far set_drawpage(int page);	/* set page for drawing on */

			/* N_SIDED POLY DRAW for up to 20-sided  */
			/* convex polygons.  Pass pointer to int */
			/* array with X, Y coords in that order  */
			/* and count.  No clipping, CCW order    */

extern void far fastpoly(int count, int far *pcoords, int color);

			/* same as fastpoly() but with color cycling */
			/* and masking (halftone).  Color cycles in  */
			/* its lowest 4 bits, up then down.  Bit 8   */
			/* has been added as a "sign" bit for the    */
			/* initial cycle direction. 0000000SHHHHCCC  */
			/* the mask is XOR'ed with the toggle every  */
			/* line for 2x8 halftone patterns            */
extern void far m_fastpoly(int count, int far *pcoords, int color, int gmask, int toggle);

			/* print text in foreground only-- */
			/* reversed = 1 for right-to-left  */
			/* with x now right side of text   */
extern void far printxyr(int x, int y, int color, char far *pstring, int reversed);

			/* draw "+" cursor on screen      */
			/* save s screen under cursor 	  */
			/* if "color" is negative, draws double cursor */
			/* "savebuff" is page number      */
extern void far draw_cursor(int x, int y, int color, int savebuff);

				 /* restores 8x8 area saved when   */
				 /* cursor was drawn               */
extern void far erase_cursor(int savebuff);

			/* copy any byte-aligned rectangle  */
			/* this is evey 4 pixels for Y mode */
			/* but every 8 for 16-color mode    */
			/* x coords (left) are truncated to */
			/* left byte boundary: x size is    */
			/* bumped up to next full byte count */
extern int far copy_block(int spage, int sx, int sy,  /* source */
		      int dpage, int dx, int dy,  /* dest   */
		      int xs, int ys);            /* # lines, pixels */

			/* clear any byte-aligned block       */
			/* 15-30% slower than full page clear */
			/* left edge rounded down, right edge */
			/* rounded up to nearest byte boundary */
extern int far clr_block(int left, int top, int right, int bottom,
		       int page, int color);

			/* 3 entries each for n colors: RGB, 0->63 */
			/* load always starts with slot 0          */
			/* set pal=NULL for default (still give n) */
			/* bw=1 will transform palette into B&W    */
			/* first is what entry to start with       */
extern void far load_DAC_colors(char far *pal, int n, int bw, int first);

extern void far read_DAC_colors(char far *pal, int n, int first);

			// sets the video segment: might be useful
			// for protected mode versions
extern void far set_video_segment(unsigned seg);

			// reads a screen line to a buffer
			// as a sequence of byte pixel-values
			// Returns buffer size: pass NULL buffer
			// to get the size.  Older drivers do not support it
extern unsigned far read_video_line(char far *buff, unsigned line);

			// writes a screen line to a buffer
			// as a sequence of byte pixel-values
			// Returns buffer size: pass NULL buffer
			// to get the size.  Older drivers do not support it
extern unsigned far write_video_line(char far *buff, unsigned line);



/* End of f3dkitd.h */
