// LOW LEVEL PC DEVICE I/O
// INCLUDES TIMER, POWERGLOVE, LCD GLASSES, JOYSTICK AND KEY MONITOR

// ALL ROUTINES BY DAVE STAMPE

/*
 This code is part of the VR-386 project, created by Dave Stampe.
 VR-386 is a desendent of REND386, created by Dave Stampe and
 Bernie Roehl.  Almost all the code has been rewritten by Dave
 Stampre for VR-386.

 Copyright (c) 1994 by Dave Stampe:
 May be freely used to write software for release into the public domain
 or for educational use; all commercial endeavours MUST contact Dave Stampe
 (dstampe@psych.toronto.edu) for permission to incorporate any part of
 this software or source code into their products!  Usually there is no
 charge for under 50-100 items for low-cost or shareware products, and terms
 are reasonable.  Any royalties are used for development, so equipment is
 often acceptable payment.

 ATTRIBUTION:  If you use any part of this source code or the libraries
 in your projects, you must give attribution to VR-386 and Dave Stampe,
 and any other authors in your documentation, source code, and at startup
 of your program.  Let's keep the freeware ball rolling!

 DEVELOPMENT: VR-386 is a effort to develop the process started by
 REND386, improving programmer access by rewriting the code and supplying
 a standard API.  If you write improvements, add new functions rather
 than rewriting current functions.  This will make it possible to
 include you improved code in the next API release.  YOU can help advance
 VR-386.  Comments on the API are welcome.

 CONTACT: dstampe@psych.toronto.edu
*/




/************ JOYSTICK LOW_LEVEL I/O *************/

extern int joystick_j1;	   /* raw joystick results */
extern int joystick_j2;       /* updates after raw_joystick_read() */
extern int joystick_j3;
extern int joystick_j4;
extern int joystick_buttons;
				 // range of 0 to 1200 on read
				 // buttons has 4 bits
				 // mask is 3 for joy1, 12 for joy2
				 // and 15 for both

int raw_joystick_read(int mask); /* reads joystick to above variables */
				 /* returns 0 if read successful      */
				 /* else try repeating it later       */

/*********** TIMER ROUTINES ************/

	    // reads current timer chip count values
extern unsigned read_timer();

	 // returns time in msec
extern long current_time();

	// sets up timer to frame-synced interrupt, using
	// speed as a guide to desired rate (see init_timer).
	// once set, the hook will be called each timer in with
	// number of calls to video scan end: at zero, it's
	// the end of frame.  Currently used by LCD (Sega) driver
	// Once set, init_timer has no effect if called.
extern int init_frame_lock(unsigned speed, void (*frame_hook)(int));

	// sets up timer to 1190000/speed ints per second
	// sets up call to timer_hook (ignored if NULL)
	// has no effect except to set hook if frame_locked hook set
extern int init_timer(unsigned speed, void (*timer_hook)(int));

	// current_time() always in msec now: returns 1000 for compatibility
extern int get_ticks_per_second(void);

	 // delay in msec: replaces delay() function!
extern void tdelay(long d);

	// call before rendering begins
extern void register_render_start();

	// call after rendering ends
extern void register_render_end();

	// returns time of last render in milliseconds
extern long last_render_time();



/************ KEYBOARD MONITOR ROUTINES *********/

extern int init_key_monitor();	// enables key monitor
	// useful to turn it off, cause debuggers hate it!
	// returns 0 if already on, else 1

extern int is_key_down(int keycode);	// tests if key(keycode) is down
				// some useful keycodes:

extern int keymon_on;

#define UP_CURSOR_KEYCODE	0x48
#define DOWN_CURSOR_KEYCODE	0x50
#define LEFT_CURSOR_KEYCODE	0x4B
#define RIGHT_CURSOR_KEYCODE	0x4D

#define LEFT_SHIFT_KEYCODE	0x2A  // use BIOS 16.2 instead as these
#define RIGHT_SHIFT_KEYCODE	0x36  // interact with keypad etc.


/************ SEGA/LCD SWITCHER DRIVER CONTROL ***********/

// turn sega driver etc. on with call to driver:
// init_switch_driver("sega");  <see pointer.h>

// these are the interface to RENDERING CONTROL

extern int left_page;  /* left image video page  */
extern int right_page; /* right image video page */

    /* clear: will = 3 once both L,R pages have been seen */
extern volatile int has_switched;

// these are for swdrv.c <switcher driver startup>

extern void switch_sega(int tf);	// sega isr
extern void switch_LCD_driver(int tf);  // loaded driver isr
extern void sega_off();   // disable LCD to prolong life

// these configure the internal Sega driver

extern void select_sega_port(int port); /* sets up default Sega data */

extern int sega_left;	// LCD driver config fdata
extern int sega_right;
extern int sega_address;
extern int sega_mask;
extern int sega_doff;
extern int sega_port_image;

/************** POWERGLOVE ****************/
// almost all are used by glovedrv.c only



#define G_NOKEY 0xFF	// glove BUTTON codes
#define G_START 0x82
#define G_SEL   0x83
#define G_AKEY  0x0A
#define G_BKEY  0x0B
#define G_UP    0x0D
#define G_DOWN  0x0E
#define G_LEFT  0x0C
#define G_RIGHT 0x0F

#define G_RECENTER 0

// ************ how glove data is read...

typedef struct glove_data {
	signed char x,y,z,rot,fingers,keys,gstat1,gstat2,rxflags;
	unsigned int nmissed;  /* number of samples missed */
	} glove_data;

	// see format below...

// ************ how to read glove...

extern void getglove(glove_data *);	/* get data packet from glove */
extern int  glove_ready(void);		/* returns 0 if not ready     */
									/*         1 if data ready    */
   /* sets up glove, enters hires mode    */									/*         2 if rxflags also valid */
   /* gdeg switches deglitching on or off */
   /* will call timer_init with 6600 and take hook */
#define DEGLITCH   1
#define NODEGLITCH 0
extern void glove_init(int gdeg);

  /* reads glove data, with de-glitching */
extern int glove_read(glove_data *g);

/************ gesture recognition */

#define G_FLAT      0      /* std. gesture classification */
#define G_THUMB_IN  1
#define G_INDEX_IN  2
#define G_MIDDLE_IN 3
#define G_RING_IN   4
#define G_PINCH     5
#define G_FIST      6
#define G_THUMB_OUT 7
#define G_POINT     8
#define G_BADFINGER 9
#define G_RING_OUT  10
#define G_UNKNOWN   11

	/* gesture debounce time in # of glove-reads (1/20 sec) */
extern long gesture_time;

	/* mapped gesture type: filled after glove read */
extern unsigned char gesture_type;
	/* use to map std. gestures to subset that's more stable */
extern unsigned char gesture_map[];
															/* so gesture_time is valid */
/***** GLOVE DATA SPECIFICATIONS **************

x =   X position, 3mm per number
y =   Y position, 3mm per number
z =   distance,  14mm per number
rot = wrist twist. 0 is up 1 is slightly CW, 5 is down,
      11 is slightly CCW.
      About 30 to 40 degrees per count.

 Note: exact scaling of all above change with distance! Closer is higher res.

 fingers = packed 2-bit values, 0 is open, 3 is (tight) fist:
    Bit format: TtIiMmRr  for Thumb, Index, Middle, and Ring fingers.

 keys: $FF or $80 is no key. Responds with 0 to 9 for keys "0" thru "9"
      $82 = START, $83 = SEL, $0A = "A", $0B = "B", 0 is "Center"
			Up,down,left,right are $0D,$0E,$0C,$0F respectively.

 gstat1, gstat2 are dummies
 rxflags is valid ONLY after glove_ready returns 2.

 nmissed is number of reads since last glove_read call

 **********************************************/


 // POWERGLOVE data for driver config

extern int glove_in_port;
extern int glove_out_port;
extern int port_image;

extern int glove_data_mask;
extern int glove_write_mask;

extern int glove_none_mask;
extern int glove_latch_mask;
extern int glove_clock_mask;
extern int glove_clock_latch;

extern int glove_bit_delay;
extern int glove_byte_delay;

