// redefineable VR-386 types
// for API, also for compiler portability
// Dave Stampe, 29/12/93


/// THESE TYPES ARE FOR COMPILER PORTABILITY
/*
 This code is part of the VR-386 project, created by Dave Stampe.
 VR-386 is a desendent of REND386, created by Dave Stampe and
 Bernie Roehl.  Almost all the code has been rewritten by Dave
 Stampre for VR-386.

 Copyright (c) 1994 by Dave Stampe:
 May be freely used to write software for release into the public domain
 or for educational use; all commercial endeavours MUST contact Dave Stampe
 (dstampe@psych.toronto.edu) for permission to incorporate any part of
 this software or source code into their products!  Usually there is no
 charge for under 50-100 items for low-cost or shareware products, and terms
 are reasonable.  Any royalties are used for development, so equipment is
 often acceptable payment.

 ATTRIBUTION:  If you use any part of this source code or the libraries
 in your projects, you must give attribution to VR-386 and Dave Stampe,
 and any other authors in your documentation, source code, and at startup
 of your program.  Let's keep the freeware ball rolling!

 DEVELOPMENT: VR-386 is a effort to develop the process started by
 REND386, improving programmer access by rewriting the code and supplying
 a standard API.  If you write improvements, add new functions rather
 than rewriting current functions.  This will make it possible to
 include you improved code in the next API release.  YOU can help advance
 VR-386.  Comments on the API are welcome.

 CONTACT: dstampe@psych.toronto.edu
*/


typedef unsigned char BYTE;   // types for compiler portability
typedef unsigned int WORD;
typedef signed char SBYTE;
typedef signed int SWORD;
typedef long DWORD;

typedef signed char BOOL;
#define TRUE  1
#define FALSE 0

typedef DWORD COORD;     // <32.0>  for position
typedef DWORD ANGLE;     // <16.16> for angle
typedef DWORD MATVAL;    // <3.29> for trig
typedef DWORD SCALE;     // <16.16> for scaling


//// THESE TYPES ARE ALSO IN 3DSTRUCT.H WHICH MAY BE INCLUDED FOR DEBUGGING

#ifndef SCRIDEF
#define SCRIDEF 1
struct Screeninfo {
	WORD xmin, ymin, xmax, ymax, xcent, ycent, colors, pages, bw;
	SCALE aspect;
	char id[80];
	};
#endif

#ifndef MATRIXDEF
typedef MATVAL MATRIX[4][3];  /* 3x3 rotate plus 3 translate para's */
#define MATRIXDEF 1           /* rotate matrix is <3.29>, translate is <32.0> */
#endif


#ifndef VIEWDEF
#define VIEWDEF 1
typedef struct {
	SCALE zoom;              /* <16.16> 1/tan(H FOV/2) 0.5 to 16     */

	DWORD left,right;        /* <25.0> clipping planes */
	DWORD top, bottom;
	DWORD hither, yon;       /* <25.0> near and far clipping planes   */
	SCALE aspect;            /* <16.16> x:y fixup factor (magnify Y by...) */

	WORD flags;         /* 16 bits of flags */

	DWORD x_offset, y_offset;   /* amount to move screen center in pixels */
	WORD  orientation;      /* used to mirror screen image */
#define NOFLIP 0x0000      /* bits used in orientation field */
#define XFLIP  0x0001
#define YFLIP  0x0002

	MATRIX eye_xform;

	DWORD spare[17];   // PRIVATE view data caching
	} VIEW;
#endif

#ifndef POLYDEF
#define POLYDEF 1
typedef void POLY;
#endif

#ifndef REPDEF
#define REPDEF 1
typedef void REP;
#endif

#ifndef OBJDEF
#define OBJDEF 1
typedef WORD *OBJECT;	// for now (generic name for SEGMENT and OBJECT)
			// this just accesses the flags field for type checks
typedef void *VISOBJ;	// special case of OBJECT
#endif

#ifndef OBJLDEF
#define OBJLDEF 1
typedef void *OBJLIST;
#endif

#ifndef SEGDEF
#define SEGDEF 1
typedef void SEGMENT;
#endif

#ifndef SPLDEF
#define SPLDEF 1
typedef void SPLIT;
#endif

typedef unsigned SURFACE;

/// THESE ARE TYPE-CONVERSION MACROS

#define XFFP 536870912.0

#define float2coord(p)  ((COORD)p)
#define coord2float(p)  ((float)p)
#define float2scale(p)  ((SCALE)(p*65536.0))
#define scale2float(p)  (p/65536.0)
#define float2angle(p)  ((ANGLE)(p*65536.0))
#define angle2float(p)  (p/65536.0)
#define float2matval(p) ((MATVAL)(p*XFFP))
#define matval2float(p) (p/XFFP)


