/* Functions related to splits and areas */
/* Splitting-tree structures: theory by Dave Stampe, initial
   implementation by Bernie Roehl */

/* Original written by Bernie Roehl, June 1992 */
/* Substantially upgraded by Dave Stampe, August '92 */

// THE AREAS, SPLITS ETC WILL BE SUBSTANTIALLY MODIFIED
// AS THE API EVOLVES


/*
 This code is part of the VR-386 project, created by Dave Stampe.
 VR-386 is a desendent of REND386, created by Dave Stampe and
 Bernie Roehl.  Almost all the code has been rewritten by Dave
 Stampre for VR-386.

 Copyright (c) 1994 by Dave Stampe:
 May be freely used to write software for release into the public domain
 or for educational use; all commercial endeavours MUST contact Dave Stampe
 (dstampe@psych.toronto.edu) for permission to incorporate any part of
 this software or source code into their products!  Usually there is no
 charge for under 50-100 items for low-cost or shareware products, and terms
 are reasonable.  Any royalties are used for development, so equipment is
 often acceptable payment.

 ATTRIBUTION:  If you use any part of this source code or the libraries
 in your projects, you must give attribution to VR-386 and Dave Stampe,
 and any other authors in your documentation, source code, and at startup
 of your program.  Let's keep the freeware ball rolling!

 DEVELOPMENT: VR-386 is a effort to develop the process started by
 REND386, improving programmer access by rewriting the code and supplying
 a standard API.  If you write improvements, add new functions rather
 than rewriting current functions.  This will make it possible to
 include you improved code in the next API release.  YOU can help advance
 VR-386.  Comments on the API are welcome.

 CONTACT: dstampe@psych.toronto.edu
*/


#ifndef SPLITDEF
#define SPLITDEF 1
typedef void SPLIT;
#endif

#ifndef AREADEF
#define AREADEF 1
typedef void AREA;
#endif

extern SPLIT *add_split(SPLIT **tree, long x, long y, long z,
			long nx, long ny, long nz, unsigned flags);
extern AREA *what_area(SPLIT *tree, long x, long y, long z);
extern char *area_name(AREA *a);
extern char *set_area_name(AREA *a, char *name);

extern void add_obj_to_area(AREA *a, OBJECT *obj);
extern void add_obj_to_split(SPLIT *tree, OBJECT *obj);

extern void split_move_handler(OBJECT *obj);
extern SPLIT *create_initial_world_split();

extern OBJLIST *which_area_objlist(SPLIT *tree, long x, long y, long z);
extern void add_obj_to_split_area(SPLIT *tree, OBJECT *obj);
extern void add_obj_to_split_center(SPLIT *tree, OBJECT *obj);

extern void render_monitor_point(int x, int y);
extern OBJECT *render_check_monitor(int *poly, int *vert);
extern void render_objlist(OBJLIST *objlist);
extern void render_area(AREA *a);
extern void render_subtree(int type, SPLIT *ptr, VIEW *view);
extern void render_split(SPLIT *tree, VIEW *view);
extern void render_visareas(AREA *area);
extern void walk_area(AREA *a, void (*fn)());
extern void walk_split_tree(SPLIT *tree, void (*fn)());
extern void set_area_function(AREA *a, void (*fn)());
extern void call_area_fn(AREA *a);
extern void add_floor(AREA *area, long a, long b, long c, long d);
extern void add_ceiling(AREA *area, long a, long b, long c, long d);
extern long floor_at(AREA *a, long x, long z);
extern long ceiling_at(AREA *a, long x, long z);
extern int add_visfrom(AREA *from, AREA *to);

/* End of splits.h */
