// Written by Dave Stampe, 23/12/93
// code for video/LCD switch driver interface and setup

// this code supports loadable or internal switching drivers,
// for Sega glasses, VCRs, etc etc.

// This module relies on SGSPPT.C and other parts of the PCDEVICE library.

/*
 This code is part of the VR-386 project, created by Dave Stampe.
 VR-386 is a desendent of REND386, created by Dave Stampe and
 Bernie Roehl.  Almost all the code has been rewritten by Dave
 Stampre for VR-386.

 Copyright (c) 1994 by Dave Stampe:
 May be freely used to write software for release into the public domain
 or for educational use; all commercial endeavours MUST contact Dave Stampe
 (dstampe@psych.toronto.edu) for permission to incorporate any part of
 this software or source code into their products!  Usually there is no
 charge for under 50-100 items for low-cost or shareware products, and terms
 are reasonable.  Any royalties are used for development, so equipment is
 often acceptable payment.

 ATTRIBUTION:  If you use any part of this source code or the libraries
 in your projects, you must give attribution to VR-386 and Dave Stampe,
 and any other authors in your documentation, source code, and at startup
 of your program.  Let's keep the freeware ball rolling!

 DEVELOPMENT: VR-386 is a effort to develop the process started by
 REND386, improving programmer access by rewriting the code and supplying
 a standard API.  If you write improvements, add new functions rather
 than rewriting current functions.  This will make it possible to
 include you improved code in the next API release.  YOU can help advance
 VR-386.  Comments on the API are welcome.

 CONTACT: dstampe@psych.toronto.edu
*/


#include <stdlib.h>
#include <stdio.h>
#include <dos.h>

#include "vr_api.h"
#include "pcdevice.h"


/****************** SWITCHER DRIVER INTERFACE *************/


#define SW_INIT        0
#define SW_QUIT        1
#define SW_ADV_SWITCH  2
#define SW_SYNC_SWITCH 3

int (*switch_driver)() = NULL;   // if NULL, use internal driver

static void sdriver_quit()
{
  if (switch_driver) switch_driver(SW_QUIT);
}

void init_switch_driver(char *sdname)   // setup whatever switch driver used
{
  if (!stricmp(sdname, "sega"))
    {
      init_frame_lock(6000, switch_sega);
      atexit(sega_off);
      return;
    }

  switch_driver = load_driver(sdname);

  if (switch_driver == NULL)
    {
      fprintf(stderr,"Cannot read switcher driver %s\n", sdname);
      exit(0);
    }

  init_frame_lock(0, switch_LCD_driver);
  switch_driver = MK_FP(FP_SEG(switch_driver), 16+FP_OFF(switch_driver)); /* entry point */
  switch_driver(SW_INIT);
  atexit(sdriver_quit);
}

