// This is the title screen for VRC
// By Dave Stampe, Feb. '93


/*
 This code is part of the VR-386 project, created by Dave Stampe.
 VR-386 is a desendent of REND386, created by Dave Stampe and
 Bernie Roehl.  Almost all the code has been rewritten by Dave
 Stampre for VR-386.

 Copyright (c) 1994 by Dave Stampe:
 May be freely used to write software for release into the public domain
 or for educational use; all commercial endeavours MUST contact Dave Stampe
 (dstampe@psych.toronto.edu) for permission to incorporate any part of
 this software or source code into their products!  Usually there is no
 charge for under 50-100 items for low-cost or shareware products, and terms
 are reasonable.  Any royalties are used for development, so equipment is
 often acceptable payment.

 ATTRIBUTION:  If you use any part of this source code or the libraries
 in your projects, you must give attribution to VR-386 and Dave Stampe,
 and any other authors in your documentation, source code, and at startup
 of your program.  Let's keep the freeware ball rolling!

 DEVELOPMENT: VR-386 is a effort to develop the process started by
 REND386, improving programmer access by rewriting the code and supplying
 a standard API.  If you write improvements, add new functions rather
 than rewriting current functions.  This will make it possible to
 include you improved code in the next API release.  YOU can help advance
 VR-386.  Comments on the API are welcome.

 CONTACT: dstampe@psych.toronto.edu
*/


#include <stdio.h>
#include <dos.h>     /* delay() */
#include <conio.h>

static char *title[] = {
	"",
	"                                   VR-386",
	"",
	"           a port of REND386 V5.0, identical in operation to the",
	"",
	"           Virtual Reality Creations release in function. but massively",
	"            rewritten internally to make programming simpler.",
	"",
	"                VR-386 written and (c) 1994 by Dave Stampe",
	"                REND386 (c) 1993 by Dave Stampe and Bernie Roehl",
	"",
	"             This program is free for non-commercial, non-profit,",
	"              non-promotional use.  Any other use requires prior",
	"                    written permission from the authors",
	"",
	"                  Note: a 386 or 486 PC and VGA card are",
	"                      required to run this software.",
	"",
	"                           Version date: 9/1/94",
	"",
	"Loading files...",
	"",
	NULL
	};

void title_screen()
{
	int i;
	textattr((BLUE<<4)+WHITE);
	directvideo = 0;
	clrscr();

	for (i = 0; title[i]; ++i) {
		cputs(title[i]);
		cputs("\r\n");
		}
	directvideo = 1;
}

void wait_for_title()
{
  int i;
  cputs("\n\r Ready- Press a key to start.\n\r");
  for (i = 0; i < 100; i++)
    {
      delay(100);
      if (kbhit()) break;
    }
  while (kbhit()) getch();
}
