// FOR API: ONLY SPECIAL DEFINES
// for: keys, joysticks, etc


/*
 This code is part of the VR-386 project, created by Dave Stampe.
 VR-386 is a desendent of REND386, created by Dave Stampe and
 Bernie Roehl.  Almost all the code has been rewritten by Dave
 Stampre for VR-386.

 Copyright (c) 1994 by Dave Stampe:
 May be freely used to write software for release into the public domain
 or for educational use; all commercial endeavours MUST contact Dave Stampe
 (dstampe@psych.toronto.edu) for permission to incorporate any part of
 this software or source code into their products!  Usually there is no
 charge for under 50-100 items for low-cost or shareware products, and terms
 are reasonable.  Any royalties are used for development, so equipment is
 often acceptable payment.

 ATTRIBUTION:  If you use any part of this source code or the libraries
 in your projects, you must give attribution to VR-386 and Dave Stampe,
 and any other authors in your documentation, source code, and at startup
 of your program.  Let's keep the freeware ball rolling!

 DEVELOPMENT: VR-386 is a effort to develop the process started by
 REND386, improving programmer access by rewriting the code and supplying
 a standard API.  If you write improvements, add new functions rather
 than rewriting current functions.  This will make it possible to
 include you improved code in the next API release.  YOU can help advance
 VR-386.  Comments on the API are welcome.

 CONTACT: dstampe@psych.toronto.edu
*/


////////// GLOVE/POINTER POSITION

   // offsets of wrist from body
#define Y_PTR_OFFSET  100      /* needed as "body" is at neck level */
#define PTR_DIST      1000



/********** MODE FLAGS FOR JOYSTICK POINTERS *********/

			// mouse joy switch
#define MJOY_ENABLE   0x1000 // even if off, it works while ALT key down
			// acceleration mode (NOT all yet)
#define MJOY_VELOCITY 0x2000 // mouse sets velocity not position



/************************ KEY DEFINES **************/
//
// THESE ARE RETURNED BY getkey();
// AND ENCODE SHIFT, ALT, ETC.

#define F1  0x3B00
#define F2  0x3C00
#define F3  0x3D00
#define F4  0x3E00
#define F5  0x3F00
#define F6  0x4000
#define F7  0x4100
#define F8  0x4200
#define F9  0x4300
#define F10 0x4400

#define HOME      0x4700
#define END       0x4F00
#define PGUP      0x4900
#define PGDN      0x5100

#define LEFT      0x4B00
#define RIGHT     0x4D00
#define UP        0x4800
#define DOWN      0x5000

#define SHLEFT    0x4B01
#define SHRIGHT   0x4D01
#define SHUP      0x4801
#define SHDOWN    0x5001
#define ASHLEFT   0x3401
#define ASHRIGHT  0x3601
#define ASHUP     0x3801
#define ASHDOWN   0x3201

#define LSHLEFT   0x4B02
#define LSHRIGHT  0x4D02
#define LSHUP     0x4802
#define LSHDOWN   0x5002
#define ALSHLEFT  0x3402
#define ALSHRIGHT 0x3602
#define ALSHUP    0x3802
#define ALSHDOWN  0x3202

#define SHPGUP    0x4901
#define SHPGDN    0x5101

#define CTRLLEFT  0x7300
#define CTRLRIGHT 0x7400

#define CTRLHOME  0x7700
#define CTRLEND   0x7500
#define CTRLPGUP  0x8400
#define CTRLPGDN  0x7600

#define ESC       0x001B
#define TAB       0x0009

/* End of userint.h */

/* Depth-sorting control: */
#define DEEPEST 0x0000          /* sort polys by deepest point */
#define ATBACK  0x0001          /* push this object's poly's waaaay back */
#define AVERAGE 0x0002          /* sort polys by average depth */

#define BYOBJECT   0x0100       /* sort by object */
#define BYPOLY     0x0000       /* put polys in world before sort */

/* Values for object flags */
#define OBJ_NONSEL       0x0800 /* can't be selected (i.e. pointer) */
#define OBJ_INVIS        0x1000
#define OBJ_HIGHLIGHTED  0x2000
#define OBJLIST_HEADER   0x4000
#define IS_VISOBJ        0x8000 /* required by renderer: it will set */


