// redefineable REND386 types
// for API, also for compiler portability
// Dave Stampe, 29/12/93

/*
 This code is part of the VR-386 project, created by Dave Stampe.
 VR-386 is a desendent of REND386, created by Dave Stampe and
 Bernie Roehl.  Almost all the code has been rewritten by Dave
 Stampre for VR-386.

 Copyright (c) 1994 by Dave Stampe:
 May be freely used to write software for release into the public domain
 or for educational use; all commercial endeavours MUST contact Dave Stampe
 (dstampe@psych.toronto.edu) for permission to incorporate any part of
 this software or source code into their products!  Usually there is no
 charge for under 50-100 items for low-cost or shareware products, and terms
 are reasonable.  Any royalties are used for development, so equipment is
 often acceptable payment.

 ATTRIBUTION:  If you use any part of this source code or the libraries
 in your projects, you must give attribution to VR-386 and Dave Stampe,
 and any other authors in your documentation, source code, and at startup
 of your program.  Let's keep the freeware ball rolling!

 DEVELOPMENT: VR-386 is a effort to develop the process started by
 REND386, improving programmer access by rewriting the code and supplying
 a standard API.  If you write improvements, add new functions rather
 than rewriting current functions.  This will make it possible to
 include you improved code in the next API release.  YOU can help advance
 VR-386.  Comments on the API are welcome.

 CONTACT: dstampe@psych.toronto.edu
*/



/// THESE TYPES ARE FOR COMPILER PORTABILITY

typedef unsigned char BYTE;   // types for compiler portability
typedef unsigned int WORD;
typedef signed char SBYTE;
typedef signed int SWORD;
typedef long DWORD;

typedef signed char BOOL;
#define TRUE  1
#define FALSE 0

typedef DWORD COORD;     // <32.0>  for position
typedef DWORD ANGLE;     // <16.16> for angle
typedef DWORD MATVAL;    // <3.29> for trig
typedef DWORD SCALE;     // <16.16> for scaling


//// THESE TYPES ARE ALSO IN 3DSTRUCT.H WHICH MAY BE INCLUDED FOR DEBUGGING

#ifndef SCRIDEF
#define SCRIDEF 1
struct Screeninfo {
	WORD xmin, ymin, xmax, ymax, xcent, ycent, colors, pages, bw;
	SCALE aspect;
	char id[80];
	};
#endif

#ifndef MATRIXDEF
typedef MATVAL MATRIX[4][3];  /* 3x3 rotate plus 3 translate para's */
#define MATRIXDEF 1           /* rotate matrix is <3.29>, translate is <32.0> */
#endif


#ifndef VIEWDEF
#define VIEWDEF 1
typedef struct {
	SCALE zoom;              /* <16.16> 1/tan(H FOV/2) 0.5 to 16     */

	DWORD left,right;        /* <25.0> clipping planes */
	DWORD top, bottom;
	DWORD hither, yon;       /* <25.0> near and far clipping planes   */
	SCALE aspect;            /* <16.16> x:y fixup factor (magnify Y by...) */

	WORD flags;         /* 16 bits of flags */

	DWORD x_offset, y_offset;   /* amount to move screen center in pixels */
	WORD  orientation;      /* used to mirror screen image */
#define NOFLIP 0x0000      /* bits used in orientation field */
#define XFLIP  0x0001
#define YFLIP  0x0002

	MATRIX eye_xform;

	DWORD spare[17];   // PRIVATE view data caching
	} VIEW;
#endif

#ifndef POLYDEF
#define POLYDEF 1
typedef void POLY;
#endif

#ifndef REPDEF
#define REPDEF 1
typedef void REP;
#endif

#ifndef OBJDEF
#define OBJDEF 1
typedef WORD *OBJECT;	// for now (generic name for SEGMENT and OBJECT)
			// this just accesses the flags field for type checks
typedef void *VISOBJ;	// special case of OBJECT
#endif

#ifndef OBJLDEF
#define OBJLDEF 1
typedef void *OBJLIST;
#endif

#ifndef SEGDEF
#define SEGDEF 1
typedef void SEGMENT;
#endif

#ifndef SPLDEF
#define SPLDEF 1
typedef void SPLIT;
#endif

/// THESE ARE TYPE-CONVERSION MACROS

#define XFFP 536870912.0

#define float2coord(p)  ((COORD)p)
#define coord2float(p)  ((float)p)
#define float2scale(p)  ((SCALE)(p*65536.0))
#define scale2float(p)  (p/65536.0)
#define float2angle(p)  ((ANGLE)(p*65536.0))
#define angle2float(p)  (p/65536.0)
#define float2matval(p) ((MATVAL)(p*XFFP))
#define matval2float(p) (p/XFFP)


/// THESE TYPES ARE FOR API AND INTERNAL USE

typedef unsigned SURFACE;	// surface type: may be long later
typedef struct 	{               // pair for surface remapping
		SURFACE old;
		SURFACE new;
		} SURFACEPAIR;

typedef struct { COORD x, y, z; } POINT3D;  // 3D point
typedef struct { ANGLE rx, ry, rz; } ROT3D;  // 3D rotation

#define DONTCARE 0x80000000L  // when used, does not affect old value

// pose: used to set/return object etc. pose (position and angle)

typedef struct  { COORD x,y,z;  ANGLE rx,ry,rz; } POSE;

// example of use:
// POSE p = DONTCARE_POSE;

#define DONTCARE_POSE { DONTCARE,DONTCARE,DONTCARE,DONTCARE,DONTCARE,DONTCARE }
#define ZERO_POSE { 0,0,0,0,0,0 }

typedef struct  {               // light source
		  void *seg;
		  unsigned type;
		  unsigned intensity;
		} LIGHT;

#define AMBIENT_LIGHT 0   // types of lights
#define POINT_LIGHT   1   // a "positioned" light: only light location used
#define SPOT_LIGHT    2	  // an "angled" light: only LIGHT angle used

	// a stereo view window: two in each STEREO
typedef struct {
		  WORD  l,t,r,b;	// the window bounds
		  ANGLE rx,ry,rz;       // rotations of window
		  SWORD xoff, yoff;	// offset of window
		  WORD	orientation;	// mirroring of window
		  MATRIX mat;
	       } STWINDOW;


typedef struct {   	/* stereoscopic view factors */
	DWORD phys_screen_dist;  /* eye-to-screen distance (mm); keep < 32000  */
	DWORD phys_screen_width; /* viewport width on screen (mm)              */
	DWORD pixel_width;       /* width of viewport in pixels                */
	DWORD phys_eye_spacing;  /* spacing of eyes (mm) [usually 63]          */
	DWORD phys_convergence;  /* convergence dist. (usually screen) (mm)    */
	SCALE world_scaling;     /* world units per physical mm                */
	STWINDOW window[2];	/* the windows for display 		      */
	} STEREO ;

#define MONOSCOPIC 0 		/* stereo types */
#define SWITCHED   1
#define SPLITLR    3
#define SEPARATE   5

#define LEFT_EYE   0
#define RIGHT_EYE  1

typedef struct {
		  VIEW *mono;    	// central/mono view
		  VIEW *left;           // left eye view
		  VIEW *right;          // right eye view
		  BOOL is_stereo;       // stereo view?
		  STEREO *stereo;       // data to create stereo views
		  SEGMENT *seg;		// segment to move camera
		} CAMERA;


typedef struct { BYTE r, g, b; } RGBCOLOR;  // RGB color

#define structtype(p) (*((WORD *)(p))	// retrives structure type label

//other uses of flags: for segments and object:

#define IS_VISOBJ     0x8000
#define IS_SEGMENT    0x0080
#define IS_MOVEABLE   0x0010

#define SYSTEM_OWNED  0x0040    // segment flags
#define HAS_OBJECT    0x0020
#define SEG_MODIFIED  1

typedef struct {                          // more later
		CAMERA  *current_camera;
		POSE    initial_body_pose;
		POSE    *body_pose;
		POSE    *home_pose;
		SPLIT   *world_root;
		OBJLIST *inactive_objects;
	       } WORLD;

typedef struct {
		POSE current_pose;
		OBJECT *vehicle;
		char * vehicle_name;	// in case reloading needed
		WORLD *world;
	       } TELEPORT;


// memory alloc/dealloc lists: not yet tested

#ifndef DEFMB
struct _mb_ {
	      struct _mb_ *prev;    // header of memory
	      struct _mb_ *next;
	  } ;

typedef struct _mb_ MEMBLOCK;

typedef struct {                    // head of memory list
		 MEMBLOCK *prev;    // USUALLY STATIC MEMORY
		 MEMBLOCK *next;
	       } MEMLIST;
#endif
#define DEFMB 1

#define INIT_MEMLIST { NULL,NULL }	// store in new memlist header
// example:
// MEMLIST env_memlist = INIT_MEMLIST;

#define ptr2memblock(p) MK_FP(FP_SEG(p),FP_OFF(p)-(2*sizeof(MEMBLOCK *)))
#define memblock2ptr(p) MK_FP(FP_SEG(p),FP_OFF(p)+(2*sizeof(MEMBLOCK *)))

