// WORLD management (just a beginning)
// 7/1/94 by Dave Stampe


/*
 This code is part of the VR-386 project, created by Dave Stampe.
 VR-386 is a desendent of REND386, created by Dave Stampe and
 Bernie Roehl.  Almost all the code has been rewritten by Dave
 Stampre for VR-386.

 Copyright (c) 1994 by Dave Stampe:
 May be freely used to write software for release into the public domain
 or for educational use; all commercial endeavours MUST contact Dave Stampe
 (dstampe@psych.toronto.edu) for permission to incorporate any part of
 this software or source code into their products!  Usually there is no
 charge for under 50-100 items for low-cost or shareware products, and terms
 are reasonable.  Any royalties are used for development, so equipment is
 often acceptable payment.

 ATTRIBUTION:  If you use any part of this source code or the libraries
 in your projects, you must give attribution to VR-386 and Dave Stampe,
 and any other authors in your documentation, source code, and at startup
 of your program.  Let's keep the freeware ball rolling!

 DEVELOPMENT: VR-386 is a effort to develop the process started by
 REND386, improving programmer access by rewriting the code and supplying
 a standard API.  If you write improvements, add new functions rather
 than rewriting current functions.  This will make it possible to
 include you improved code in the next API release.  YOU can help advance
 VR-386.  Comments on the API are welcome.

 CONTACT: dstampe@psych.toronto.edu
*/



#include <stdio.h>
#include <stdlib.h>  /* for atol(), only for debugging! */
#include <dos.h>
#include <string.h>
#include <alloc.h>

#include "vr_api.h"
#include "intmath.h"
#include "splits.h"
#include "segment.h"



////////////////////////////////////////////////////
/// CURRENT WORLD STATE VARIABLES
/// accessed by many functions

WORLD *default_world = NULL;
WORLD *current_world = NULL;

SPLIT *global_world_root = NULL;	// the root of visibility tree
SPLIT *current_split = NULL;		// used to add objects to splits

OBJLIST *default_objlist = NULL;       // used for loading objects
OBJLIST *inactive_object_list = NULL;  // all objects not currently in world

CAMERA *default_camera = NULL;	  // the "basis" camara for world
CAMERA *current_camera = NULL;   // the current camera used for rendering

POSE initial_body_pose = {0,0,-8000,0,0,0}; // start position
POSE *body_pose = &initial_body_pose;       // current "teleport" used
POSE *home_pose = &initial_body_pose;	    // current "teleport <home>

extern OBJECT *body_vehicle_object;


////////////////////////////////////////////////////
/// WORLD MANAGEMENT:
/// eventually will allow suspension, resumption, freeing of memory
/// also loading (some)


//typedef struct {                          // more later
//		CAMERA  *current_camera;
//		POSE    initial_body_pose;
//		POSE    *body_pose;
//		POSE    *home_pose;
//		SPLIT   *world_root;
//		OBJLIST *inactive_objects;
//	       } WORLD;
//

void save_world_state(WORLD *w)
{
  w->home_pose = home_pose;
  w->body_pose = body_pose;
  w->initial_body_pose = *body_pose;
  w->world_root = global_world_root;
  w->inactive_objects = inactive_object_list;
}

void restore_world_state(WORLD *w)
{
//  home_pose = w->home_pose;
//  body_pose = w->body_pose;
//  *body_pose = w->initial_body_pose;
  global_world_root = w->world_root;
  inactive_object_list = w->inactive_objects;
  current_world = w;
}


WORLD *create_world(WORLD * template)  // arg not yet used
{
  WORLD *w = malloc(sizeof(WORLD));
  if(!w) return NULL;
  current_world = w;
  save_world_state(w);
}

void release_world(WORLD *w)   // NOT YET FUNCTIONAL
{
//  delete_objlist(w->inactive_objects);
//  do_for_all_objlists(w->world_root, delete_objlist);
  free(w);
  current_world = default_world;
}


void create_default_world()
{
  if(!default_objlist) default_objlist = new_objlist();
  inactive_object_list = new_objlist();
  if(!default_camera)
      default_camera = create_camera(stereo_type, NULL); // create BASIS camera
  current_camera = default_camera;
  global_world_root = create_initial_world_split();

  current_world = create_world(NULL);
}


void load_world(FILE *in, WORLD *w)
{
}  // use load_wld_file for now


/////// WORLD OBJECT SUPPORT


void add_object_to_world(OBJECT *obj)
{
  mark_object_visible(obj);    // allow to place in world
  if (current_split)
    add_obj_to_split_center(current_split, obj);
  else
    add_obj_to_split_area(global_world_root, obj);
}


void add_objlist_to_world(OBJLIST *olist)
{
  OBJECT *obj;

  obj = first_in_objlist(olist);
  add_object_to_world(obj);          // auto. remove from objlist
  while((obj=first_in_objlist(olist))!=NULL)  // cause it's removed!
     add_object_to_world(obj);      // auto. remove from objlist
}

void remove_object_from_world(OBJECT *obj)
{
  mark_object_invisible(obj);
  add_to_objlist(inactive_object_list, obj);
}


BOOL add_split_to_world(COORD x, COORD y, COORD z,
			COORD nx, COORD ny, COORD nz, WORD flags)
{
  current_split = add_split(&global_world_root,x,y,z,nx,ny,nz,flags);
}


BOOL end_of_world_splits()
{
  current_split = NULL;
}


///////////// TELEPORTS

//typedef struct {
//		POSE current_pose;
//		OBJECT *vehicle;
//		char * vehicle_name;	// in case reloading needed
//		WORLD *world;
//	       } TELEPORT;


TELEPORT *create_teleport();
void delete_teleport(TELEPORT *t);
void teleport_set_here(TELEPORT *t, POSE *p);
void teleport_set_vehicle(TELEPORT *t, OBJECT *vehicle, char *vname);
void teleport_to(TELEPORT *t);



TELEPORT *create_teleport()
{
  TELEPORT *t = calloc(sizeof(TELEPORT),1);
  if(!t) return NULL;
  t->current_pose = *body_pose;
  t->world = current_world;
  t->vehicle = body_vehicle_object;
  t->vehicle_name = NULL;
  return t;
}

void delete_teleport(TELEPORT *t)
{
  if(t->vehicle_name) free(t->vehicle_name);
  free(t);
}

void teleport_set_here(TELEPORT *t, POSE *p)
{
  t->current_pose = *p;
}

void teleport_set_vehicle(TELEPORT *t, OBJECT *vehicle, char *vname)
{
  t->vehicle = vehicle;
  if(vname) t->vehicle_name = strdup(vname);
}

void teleport_to(TELEPORT *t)
{
// if(world != current_world) ....	NOT YET IMPLEMENTED

  if(t->vehicle) connect_body(t->vehicle);
  else disconnect_body();
  *body_pose = t->current_pose;
}






