	TITLE   GSDWSPPT - 320x400x256 mode support (split sideways)


	COMMENT $

		Written  by Dave Stampe
		Copyright (c) 1993
		Not for commercial use, so get permission
		before marketing code using this stuff!

		$

include vdmodel.inc	; sets memory model

		.CODE vdriver
		.386

include vdefside.inc    ; defines constants, tables



 ;
 ; void set_video_segment(unsigned seg); // sets video segment
 ;

	PUBLIC _set_video_segment

_set_video_segment proc far

	push	bp
	mov	bp,sp

	mov	ax,[bp+6]
	mov 	videoseg,ax

	pop     bp
	ret

_set_video_segment  endp




 ;
 ; unsigned read_video_line(char *buff, unsigned line);
 ;
 ; if buff is NULL, returns number of bytes required
 ; else, it will fill the buffer with the line contents
 ; this is the assembler part-- rest is C
 ;
 ; void get_line(char far *buff, unsigned line, unsigned pixels);

	PUBLIC _get_line

buff	equ	DWORD PTR [bp+6]
line	equ	WORD PTR [bp+10]
pixels	equ	WORD PTR [bp+12]

_get_line proc far

	push	bp
	mov	bp,sp

	push	cx
	push	dx                  ; SIDEWAYS!
	push	si                  ;
	push	di                  ; SO IT READS A COLUMN
	push	ds

	mov 	videoseg,ax     ; set up pointers:
	mov	es,ax		; es:si for video, ds:di for buffer
	lds	di,buff
	mov	si,_dpaddr	; page to use
	mov	ax,line
	shr	ax,2
	add	si,ax

	mov	cx,pixels	; number of pixels to read

	mov	dx,03ceh	; graphics controller
	mov	ax,0105h	; read mode 0
	out	dx,ax

	mov	ax,line
	and	ax,3
	xor	ax,3
	shl	ax,8
	mov	al,04h		; plane to read bit from
	out	dx,ax
looppr:
	mov	bh,es:[si]	     ; get byte
	mov	BYTE PTR ds:[di],bh  ; write pixel to buffer
	add	si,bypitch	     ; nextline
	add	di,1
	dec	cx
	jne	looppr

doneread:
	pop	ds
	pop	di
	pop	si
	pop	dx
	pop	cx

	pop     bp
	ret

_get_line  endp




 ;
 ; void vsync();                /* waits for vert. sync pulse */
 ;
		PUBLIC  _vsync

_vsync  proc    far

	push    bp
	push    dx
	pushf
	mov     bp,sp
	mov     dx,03DAh
	cli
	in      al,dx           ; test if 0
	test    al,8
	je      short @11@218
@11@122:
	popf
	pushf
	cli
	in      al,dx
	nop
	test    al,8            ; wait for 0
	jne     short @11@122
@11@218:
	popf
	pushf
	cli
	in      al,dx
	nop
	test    al,8            ; wait for 1
	je      short @11@218
	popf
	pop     dx
	pop     bp
	ret

_vsync  endp

 ;
 ; void setup_hdwe(int mode);   /* sets up VGA for line, poly draw */
 ;                              /* modes are: 0=PUT, 1=OR,         */
 ;                              /*            2=AND, 3=XOR         */
 ;                              /* only PUT for X-mode             */

		PUBLIC  _setup_hdwe

_setup_hdwe     proc    far

	push    bp
	mov     bp,sp
	push    dx
	mov     dx,03CEH
	mov     ax,00008h               ; all display copy bits
	out     dx,ax

	mov     dx,03c4h                ; prepare plane mask reg. for access
	mov     ax,0f02h
	out     dx,ax
	pop     dx
	pop     bp
	ret

_setup_hdwe     endp

 ;
 ; void reset_hdwe()
 ;

		PUBLIC  _reset_hdwe

_reset_hdwe     proc    far

	push    bp
	mov     bp,sp
	push    dx
	mov     dx,03CEH
	mov     ax,0FF08h               ; all CPU data bits
	out     dx,ax

	mov     dx,03c4h                ; prepare plane mask reg. for access
	mov     ax,0f02h
	out     dx,al
	pop     dx
	pop     bp
	ret

_reset_hdwe     endp

 ;
 ; int clr_page(int page, int color);   /* clear page to color */
 ;
 ;  /* returns 0 if OK, 1 if bad page */

		PUBLIC  _clr_page

_clr_page       proc    far

	push    bp
	mov     bp,sp
	sub     sp,10
	push    di
	push    cx
	push    dx
	cld
	mov     cx,word ptr [bp+6]
	cmp     cx,npages                      ; check for valid page
	jl      gdpage
	mov     ax,-1
	jmp     abbort
gdpage:
	call    far ptr _setup_hdwe     ; reset to default VGA mode
	cld
	mov     ax,videoseg
	mov     es,ax
	mov     bx,colortable
	add     bx,WORD PTR [bp+8]
	mov     al,es:[bx]              ; read entry into latches

	mov     bx,word ptr [bp+6]
	add     bx,bx
	mov     di,pageoff[bx]

	mov     cx,pgwords

	rep     stosw

	call    far ptr _reset_hdwe
	xor     ax,ax
abbort:
	pop     dx
	pop     cx
	pop     di
	mov     sp,bp
	pop     bp
	ret

_clr_page       endp

   ;
   ;    int copy_page(int source, int dest)
   ;
   ;    /* returns 0 if OK, 1 if bad page */

		PUBLIC  _copy_page

_copy_page      proc    far

	push    bp
	mov     bp,sp
	sub     sp,4
	push    si
	push    di
	push    cx
	push    dx
	mov     ax,word ptr [bp+6]
	cmp     ax,npages
	jge     short @15@74            ; check for valid page #'s
	mov     ax,word ptr [bp+8]
	cmp     ax,npages
	jl      short @15@98
@15@74:
	mov     ax,-1
	jmp     short @15@506
@15@98:
	call    far ptr _setup_hdwe       ; write VGA state
	push    ds
	cld
	mov     ax,videoseg
	mov     es,ax
	mov     ds,ax
	mov     bx,word ptr [bp+6]      ; compute source address
	add     bx,bx
	mov     si,pageoff[bx]
	mov     bx,word ptr [bp+8]      ; compute dest. address
	add     bx,bx
	mov     di,pageoff[bx]

	mov     cx,pgbytes

	rep     movsb

	call    far ptr _reset_hdwe
	pop     ds
	xor     ax,ax
@15@506:
	pop     dx
	pop     cx
	pop     di
	pop     si
	mov     sp,bp
	pop     bp
	ret

_copy_page      endp


 ;
 ; void vga_reg(int reg)        /* integer: lsby=reg(0=color), msby=value */
 ;

		PUBLIC  _vga_reg

_vga_reg        proc    far

	push    bp
	mov     bp,sp
	push    dx
	mov     dx,03CEH
	mov     ax,WORD PTR [bp+6]
	out     dx,ax
	pop     dx
	pop     bp
	ret

_vga_reg        endp



 ;
 ; void load_color(int color)    /* integer: loads latches with color */
 ;

		PUBLIC  _load_color

_load_color     proc    far

	push    bp
	mov     bp,sp
	mov     ax,videoseg
	mov     es,ax
	mov     bx,colortable
	mov     bl,BYTE PTR [bp+6]      ; figure what entry to read
	mov     al,es:[bx]      ; read entry into latches
	pop     bp
	ret

_load_color     endp


  PUBLIC _vid_char_table_

_vid_char_table_        dd ?    ; is seen as chartable


 ;
 ; void _set_vmode(int mode)    /* enters video mode thru BIOS */
 ;                              /* mode: clear if MSB not 0    */
 ;                              /* mode 14h = X-mode           */

		PUBLIC  _set_vmode

_set_vmode      proc    far

	push    bp
	mov     bp,sp

	mov     ah,0
	mov     al,BYTE PTR [bp+6]
	mov     bl,al
	and     bl,07fh
	cmp     bl,14h
	jz      setxmode
	int     10h
	pop     bp
	ret

setxmode:
	push    si
	push    di
	push    cx
	push    dx
	mov     ah,0            ; set 256-color mode
	mov     al,13h
	int     10h

	xor     bx,bx           ; get small character table
	mov     es,bx
	mov     bx,43h*4
	mov     eax,es:[bx]
	mov     DWORD PTR chartable,eax

	call    rotate_font     ; create sideways font copy

	mov     dx,03c4h        ; convert to X-mode addressing
	mov     ax,0604h        ; chain mode off
	out     dx,ax

	mov     dx,03d4h
	mov     ax,0014h        ; doubleword off
	out     dx,ax
	mov     ax,0E317h       ; byte mode on
	out     dx,ax

	mov     al,09h          ; reset double-scan for 400 lines
	out     dx,al
	inc     dx
	xchg    ah,al
	in      al,dx
	and     al,0feh
	xchg    ah,al
	dec     dx
	out     dx,ax

	call    far ptr _reset_hdwe

	mov     ax,WORD PTR[bp+6]
	test    al,080h
	jnz     dontclear

	mov     ax,0f02h
	out     dx,ax           ; clear all planes at once
	mov     ax,videoseg
	mov     es,ax
	xor     di,di
	mov     cx,0ffffh
	xor     ax,ax
	rep     stosb

	mov     di,colortable   ; setup latch color table
	mov     cx,100h
	xor     al,al
ctloop: stosb
	inc     al
	loop    ctloop

dontclear:
	pop     dx
	pop     cx
	pop     di
	pop     si
	pop     bp
	ret

_set_vmode      endp

 ;
 ; void _set_vpage(int page)    /* sets video page */
 ;

		PUBLIC  _set_vpage

_set_vpage      proc    far

	push    bp
	mov     bp,sp
	push    si
	push    di
	push    cx
	push    dx

	mov     al,BYTE PTR [bp+6]
	xor     ah,ah
	cmp     ax,npages               ; check page #
	jae     badpage

	mov     bx,ax
	add     bx,bx
	mov     ax,pageoff[bx]

	mov     bh,ah
	mov     ah,al           ; page # -> address
	mov     al,0dh
	mov     bl,0ch

	mov     dx,03d4h        ; set CRTC address
	out     dx,ax
	mov     ax,bx
	out     dx,ax
badpage:
	pop     dx
	pop     cx
	pop     di
	pop     si
	pop     bp
	ret

_set_vpage      endp

 ;
 ; void _set_drawpage(int page)    /* sets drawing page */
 ;

	extrn   _dpaddr         ; page base address
	PUBLIC  _set_drawpage

_set_drawpage   proc    far

	push    bp
	mov     bp,sp

	mov     al,BYTE PTR [bp+6]
	xor     ah,ah
	cmp     ax,npages               ; check page #
	jl      okpage
	mov     ax,-1
	pop     bp
	ret
okpage:
	mov     bx,ax
	add     bx,bx
	mov     bx,pageoff[bx]
	mov     _dpaddr,bx
	xor     ax,ax
	pop     bp
	ret

_set_drawpage   endp


sidefont db 8*256 dup (?)       ; stores rotated character set

rotate_font:
	xor     bx,bx
	mov     es,bx
	mov     bx,43h*4        ; pointer to VGA 8x8 font table
	les     si,es:[bx]      ; 8 bytes per char

	mov     di,OFFSET sidefont     ; for each char:
	mov     bx,256
charrloop:
	mov     cx,8           ; for each byte out:
byterloop:
	mov     ah,es:[si]     ; sample 1 bit from each source byte
	shl     ax,cl
	rcr     dx,1
	mov     ah,es:[si+1]
	shl     ax,cl
	rcr     dx,1
	mov     ah,es:[si+2]
	shl     ax,cl
	rcr     dx,1
	mov     ah,es:[si+3]
	shl     ax,cl
	rcr     dx,1
	mov     ah,es:[si+4]
	shl     ax,cl
	rcr     dx,1
	mov     ah,es:[si+5]
	shl     ax,cl
	rcr     dx,1
	mov     ah,es:[si+6]
	shl     ax,cl
	rcr     dx,1
	mov     ah,es:[si+7]
	shl     ax,cl
	rcr     dx,1

	mov     cs:[di],dh ; store byte
	inc     di
	dec     cx              ; next bit
	jne     byterloop

	add     si,8            ; next character
	dec     bx
	jne     charrloop
	ret


				; bit reversal (plane mask) lookup table

bytrev: db      000h,080h,040h,0c0h,020h,0a0h,060h,0e0h,010h,090h,050h,0d0h,030h,0b0h,070h,0f0h
	db      008h,088h,048h,0c8h,028h,0a8h,068h,0e8h,018h,098h,058h,0d8h,038h,0b8h,078h,0f8h
	db      004h,084h,044h,0c4h,024h,0a4h,064h,0e4h,014h,094h,054h,0d4h,034h,0b4h,074h,0f4h
	db      00ch,08ch,04ch,0cch,02ch,0ach,06ch,0ech,01ch,09ch,05ch,0dch,03ch,0bch,07ch,0fch
	db      002h,082h,042h,0c2h,022h,0a2h,062h,0e2h,012h,092h,052h,0d2h,032h,0b2h,072h,0f2h
	db      00ah,08ah,04ah,0cah,02ah,0aah,06ah,0eah,01ah,09ah,05ah,0dah,03ah,0bah,07ah,0fah
	db      006h,086h,046h,0c6h,026h,0a6h,066h,0e6h,016h,096h,056h,0d6h,036h,0b6h,076h,0f6h
	db      00eh,08eh,04eh,0ceh,02eh,0aeh,06eh,0eeh,01eh,09eh,05eh,0deh,03eh,0beh,07eh,0feh
	db      001h,081h,041h,0c1h,021h,0a1h,061h,0e1h,011h,091h,051h,0d1h,031h,0b1h,071h,0f1h
	db      009h,089h,049h,0c9h,029h,0a9h,069h,0e9h,019h,099h,059h,0d9h,039h,0b9h,079h,0f9h
	db      005h,085h,045h,0c5h,025h,0a5h,065h,0e5h,015h,095h,055h,0d5h,035h,0b5h,075h,0f5h
	db      00dh,08dh,04dh,0cdh,02dh,0adh,06dh,0edh,01dh,09dh,05dh,0ddh,03dh,0bdh,07dh,0fdh
	db      003h,083h,043h,0c3h,023h,0a3h,063h,0e3h,013h,093h,053h,0d3h,033h,0b3h,073h,0f3h
	db      00bh,08bh,04bh,0cbh,02bh,0abh,06bh,0ebh,01bh,09bh,05bh,0dbh,03bh,0bbh,07bh,0fbh
	db      007h,087h,047h,0c7h,027h,0a7h,067h,0e7h,017h,097h,057h,0d7h,037h,0b7h,077h,0f7h
	db      00fh,08fh,04fh,0cfh,02fh,0afh,06fh,0efh,01fh,09fh,05fh,0dfh,03fh,0bfh,07fh,0ffh

xchar   equ     [bp+6]          ; arguments to _xprintc
x       equ     [bp+8]
y       equ     [bp+10]

   ;
   ;    xprintc(int character)  ; ADDRESS FIXUP IS EXTERNAL
   ;

		PUBLIC  _f_xprintc

_f_xprintc      proc    far

	.386

	push    bp
	mov     bp,sp

	push    ds
	push    di
	push    si
	push    cx
	push    dx

	mov     ax,videoseg
	mov     es,ax

	mov     ax,y       ; setup video address
	imul    ax,bypitch
	mov     bx,x
	shr     bx,2
	add     ax,bx
	add     ax,_dpaddr
	mov     di,ax

	xor     ah,ah
	mov     al,xchar
	shl     ax,3
	mov     si,OFFSET sidefont
	add     si,ax

	mov     cx,3
	sub     cx,x
	and     cx,3

	mov     dx,03c4h      ; setup for plane mask access
	mov     al,2
	out     dx,al
	inc     dx

	mov     WORD PTR xchar,8

nxtline:
	mov     bh,cs:[si]              ; get,flip,shift pattern
	xor     bl,bl
	shr     bx,cl

	mov     al,bh              ; first 4 bits
	shr     al,4
	and     al,15
	out     dx,al
	mov     es:[di+2],al

	mov     al,bh              ; second 4 bits
	and     al,15
	out     dx,al
	mov     es:[di+1],al

	mov     al,bl              ; last 4 bits
	shr     al,4
	and     al,15
	out     dx,al
	mov     es:[di],al

	inc     si
	add     di,bypitch
	dec     WORD PTR xchar
	jnz     nxtline

	pop     dx
	pop     cx
	pop     si
	pop     di
	pop     ds

	pop     bp
	ret

_f_xprintc      endp


xchar   equ     [bp+6]          ; arguments to _xprintc
x       equ     [bp+8]
y       equ     [bp+10]

	 ;
   ;    xrprintc(int character) ; reversed: col. = right end
   ;

		PUBLIC  _f_xrprintc

_f_xrprintc     proc    far     ; ADDRESS FIXUP IS EXTERNAL
				; now completely turned 180 deg
	.386

	push    bp
	mov     bp,sp

	push    ds
	push    si
	push    di
	push    cx
	push    dx

	mov     ax,videoseg
	mov     es,ax

	mov     ax,y       ; setup video address
;	add     ax,7
	imul    ax,bypitch
	mov     bx,x
	shr     bx,2
	sub     bx,2              ; make it left side of rtmost char
	add     ax,bx
	add     ax,_dpaddr
	mov     di,ax

	xor     ah,ah
	mov     al,xchar
	shl     ax,3
	mov     si,OFFSET sidefont
	add     si,ax

	mov     cx,3
	sub     cx,x
	and     cx,3

	mov     dx,03c4h      ; setup for plane mask access
	mov     al,2
	out     dx,al
	inc     dx

	mov     WORD PTR xchar,8

rnxtline:
	mov     bl,cs:[si]              ; get,flip,shift pattern
	xor     bh,bh
	mov     bh,BYTE PTR cs:bytrev[bx]
	xor     bl,bl
	shr     bx,cl

	mov     al,bh              ; first 4 bits
	shr     al,4
	and     al,15
	out     dx,al
	mov     es:[di+2],al

	mov     al,bh              ; second 4 bits
	and     al,15
	out     dx,al
	mov     es:[di+1],al

	mov     al,bl              ; last 4 bits
	shr     al,4
	and     al,15
	out     dx,al
	mov     es:[di],al

	inc     si
	sub     di,bypitch
	dec     WORD PTR xchar
	jnz     rnxtline

	pop     dx
	pop     cx
	pop     di
	pop     si
	pop     ds

	pop     bp
	ret

_f_xrprintc     endp



 ;
 ; int save_8x8(int h, int y, int buffer, int address); /* save 8x8 at x,y */
 ;                                                      /* returns address */
		PUBLIC  _save_8x8

xcoord equ [bp+6]                 ; ADDRESS FIXUP IS EXTERNAL
ycoord equ [bp+8]
buffer equ [bp+10]

_save_8x8       proc    far

	push    bp
	mov     bp,sp
	push    di
	push    si
	push    cx
	push    dx

	mov     ax,ycoord
	imul    ax,bypitch
	mov     si,xcoord
	shr     si,2
	add     si,ax
	add     si,WORD PTR _dpaddr
	push    si        ; will be returned

	mov     bx,buffer
	add     bx,bx
	mov     di,cursoff[bx]
	mov     ax,videoseg
	mov     es,ax
	mov     cx,8

nxsl:   mov     al,es:[si]      ; move 12 so it always does 8
	mov     BYTE PTR es:[di],0
	mov     al,es:[si+1]
	mov     BYTE PTR es:[di+1],0
	mov     al,es:[si+2]
	mov     BYTE PTR es:[di+2],0
	add     si,bypitch
	add     di,3
	loop    nxsl

	pop     ax      ; returns address
	pop     dx
	pop     cx
	pop     si
	pop     di
	mov     sp,bp
	pop     bp
	ret

_save_8x8       endp

 ;
 ; void rest_8x8(int buffer, int address);      /* restore 8x8 at x,y */
 ;
		PUBLIC  _rest_8x8

buffer  equ [bp+6]
address equ [bp+8]

_rest_8x8       proc    far

	push    bp
	mov     bp,sp
	push    di
	push    si
	push    cx
	push    dx

	mov     bx,buffer
	add     bx,bx
	mov     si,cursoff[bx]
	mov     di,address
	mov     ax,videoseg
	mov     es,ax
	mov     cx,8

nxrl:   mov     al,es:[si]      ; move 12 so it always does 8
	mov     BYTE PTR es:[di],0
	mov     al,es:[si+1]
	mov     BYTE PTR es:[di+1],0
	mov     al,es:[si+2]
	mov     BYTE PTR es:[di+2],0
	add     si,3
	add     di,bypitch
	loop    nxrl

	pop     dx
	pop     cx
	pop     si
	pop     di
	mov     sp,bp
	pop     bp
	ret

_rest_8x8       endp


 ;
 ; int clr_block(int l, int t, int r, int b, int page, int color);
 ;  /* 8-pixel granularity  (next biggest) */
 ;  /* returns 0 if OK, 1 if bad page      */

cbl     equ WORD PTR [bp+6]
cbt     equ WORD PTR [bp+8]
cbr     equ WORD PTR [bp+10]
cbb     equ WORD PTR [bp+12]
cbpage  equ WORD PTR [bp+14]
cbcolor equ WORD PTR [bp+16]

bbyte   equ     [bp-2]          ; video base addr. of line
abyte   equ     [bp-4]          ; number of lines to fill
l_incr  equ     [bp-6]

		PUBLIC  _f_clr_block

_f_clr_block    proc    far

	push    bp
	mov     bp,sp
	sub     sp,10
	push    di
	push    cx
	push    dx

	cld
	call    far ptr _setup_hdwe     ; reset to default VGA mode
	mov     ax,videoseg
	mov     es,ax
	mov     bx,cbcolor
	add     bh,0ffh                 ; figure what entry to read
	mov     al,es:[bx]              ; read entry into latches

	mov     bx,cbpage
	add     bx,bx
	mov     di,pageoff[bx]

	mov     bx,cbb
	sub     bx,cbt                  ; bx = line count
	jb      badcb

	mov     ax,cbt
	imul    ax,bypitch
	add     di,ax
	mov     ax,cbl
	shr     ax,3
	shl     ax,1
	add     di,ax                   ; start address

	mov     cx,cbl
	and     cx,0FFFCh
	sub     cx,cbr
	neg     cx
	js      badcb
	shr     cx,3
	inc     cx
	mov     ax,cx                   ; count per line
	shl     cx,1
	sub     cx,bypitch
	jg      badcb
	neg     cx
	mov     dx,cx                   ; fixup factor

cbloop: mov     cx,ax
	rep     stosw
	add     di,dx
	dec     bx
	jge     cbloop

	call    far ptr _reset_hdwe
	xor     ax,ax
	jmp     cbexit

badcb:  mov     ax,-1

cbexit: pop     dx
	pop     cx
	pop     di
	mov     sp,bp
	pop     bp
	ret


_f_clr_block    endp

   ;
   ;    int copy_block(int spage, int sx, int sy,
   ;                   int dpage, int dx, int dy,
   ;                   int xsize, int vsize )
   ;
   ;    /* returns 0 if OK, 1 if bad page */

copsp    equ WORD PTR [bp+6]
copsx    equ WORD PTR [bp+8]
copsy    equ WORD PTR [bp+10]
copdp    equ WORD PTR [bp+12]
copdx    equ WORD PTR [bp+14]
copdy    equ WORD PTR [bp+16]
copxs    equ WORD PTR [bp+18]
copys    equ WORD PTR [bp+20]

		PUBLIC  _f_copy_block

_f_copy_block   proc    far

	push    bp
	mov     bp,sp
	sub     sp,4
	push    si
	push    di
	push    cx
	push    dx

	call    far ptr _setup_hdwe       ; write VGA state
	push    ds
	cld
	mov     ax,videoseg
	mov     es,ax
	mov     ds,ax

	mov     bx,copsp                ; compute source address
	add     bx,bx
	mov     si,pageoff[bx]
	mov     bx,copdp                ; compute dest. address
	add     bx,bx
	mov     di,pageoff[bx]

	mov     bx,copys                ; bx = line count

	mov     ax,copsy
	imul    ax,bypitch
	add     si,ax
	mov     ax,copsx
	shr     ax,1
	shr     ax,1
	add     si,ax                   ; start address

	mov     ax,copdy
	imul    ax,bypitch
	add     di,ax
	mov     ax,copdx
	shr     ax,1
	shr     ax,1
	add     di,ax                   ; start address

	mov     cx,copxs
	add     cx,3
	shr     cx,1
	shr     cx,1
	inc     cx
	mov     ax,cx                   ; count per line
	sub     cx,bypitch
	neg     cx
	mov     dx,cx                   ; fixup factor

coplop: mov     cx,ax
	rep     movsb
	add     si,dx
	add     di,dx
	dec     bx
	jg      coplop

	call    far ptr _reset_hdwe
	pop     ds
	xor     ax,ax

	pop     dx
	pop     cx
	pop     di
	pop     si
	mov     sp,bp
	pop     bp
	ret

_f_copy_block   endp


 ;
 ; void load_DAC(char far *data, int count);
 ;                      /* loads DAC             */


 count   equ [bp+10]
 dacdata equ [bp+6]

	PUBLIC  _load_DAC

_load_DAC       proc    far

	push    bp
	mov     bp,sp
	push    dx
	push    cx

	les     bx,DWORD PTR dacdata
	mov     ax,0
	mov     dx,03C8h
	out     dx,al
	mov     cx,WORD PTR count
	mov     dx,03C9h

mvp:    mov     al,BYTE PTR es:[bx]
	out     dx,al
	inc     bx
	nop
	nop
	nop
	mov     al,BYTE PTR es:[bx]
	out     dx,al
	inc     bx
	nop
	nop
	nop
	mov     al,BYTE PTR es:[bx]
	out     dx,al
	inc     bx
	loop    mvp

	pop     cx
	pop     dx
	pop     bp
	ret

_load_DAC       endp

 ;
 ; void read_DAC(char far *data, int count);
 ;                      /* reads DAC             */


 count   equ [bp+10]
 dacdata equ [bp+6]

	PUBLIC  _read_DAC

_read_DAC       proc    far

	push    bp
	mov     bp,sp
	push    dx
	push    cx

	les     bx,DWORD PTR dacdata
	mov     ax,0
	mov     dx,03C7h
	out     dx,al
	mov     cx,WORD PTR count
	mov     dx,03C9h

mvpr:
	in      al,dx
	mov     BYTE PTR es:[bx],al
	inc     bx
	nop
	nop
	nop
	in      al,dx
	mov     BYTE PTR es:[bx],al
	inc     bx
	nop
	nop
	nop
	in      al,dx
	mov     BYTE PTR es:[bx],al
	inc     bx
	loop    mvpr

	pop     cx
	pop     dx
	pop     bp
	ret

_read_DAC       endp


		end

