	TITLE   GSPPT16 - general 16-color support

	COMMENT $

		Written  by Dave Stampe
		Copyright (c) 1993
		Not for commercial use, so get permission
		before marketing code using this stuff!

		$

include vdmodel.inc	; sets memory model

		.CODE vdriver
		.386

include videfs.inc      ; defines constants, tables


 ;
 ; void set_video_segment(unsigned seg); // sets video segment
 ;

	PUBLIC _set_video_segment

_set_video_segment proc far

	push	bp
	mov	bp,sp

	mov	ax,[bp+6]
	mov 	videoseg,ax

	pop     bp
	ret

_set_video_segment  endp


 ;
 ; unsigned read_video_line(char *buff, unsigned line);
 ;
 ; if buff is NULL, returns number of bytes required
 ; else, it will fill the buffer with the line contents
 ; this is the assembler part-- rest is C
 ;
 ; void get_line(char far *buff, unsigned line, unsigned pixels);

	PUBLIC _get_line

buff	equ	DWORD PTR [bp+6]
line	equ	WORD PTR [bp+10]
pixels	equ	WORD PTR [bp+12]

_get_line proc far

	push	bp
	mov	bp,sp

	push	cx
	push	dx
	push	si
	push	di
	push	ds

	mov 	ax,videoseg     ; set up pointers:
	mov	es,ax		; es:si for video, ds:di for buffer
	lds	di,buff
	mov	ax,line
	imul	ax,bypitch
	add	ax,_dpaddr	; page to use
	mov	si,ax

	mov	cx,pixels	; number of pixels to read

	mov	dx,03ceh	; graphics controller
	mov	ax,0305h	; read mode 0
	out	dx,ax
loopnr:
	mov	bx,080h		; bit mask
loopr:
	mov	BYTE PTR ds:[di],0  ; initialize pixel in buffer
	mov	ax,0304h	; plane to read bit from
loopbr:
	out	dx,ax
	mov	bh,es:[si]	; get, mask byte
	and	bh,bl
	neg	bh
	rcl	BYTE PTR ds:[di],1  ; write bit to pixel in buffer
	dec	ah
	jge	loopbr

	dec	cx             ; next pixel
	je	doneread
	inc	di
	shr	bl,1
	jne	loopr
	inc	si
	jmp	loopnr

doneread:
	pop	ds
	pop	di
	pop	si
	pop	dx
	pop	cx

	pop     bp
	ret

_get_line  endp


 ; unsigned write_video_line(char *buff, unsigned line);
 ;
 ; if buff is NULL, returns number of bytes required
 ; else, it will fill the line with buffer contents
 ; this is the assembler part-- rest is C
 ;
 ; void put_line(char far *buff, unsigned line, unsigned pixels);

	PUBLIC _put_line

buff	equ	DWORD PTR [bp+6]
line	equ	WORD PTR [bp+10]
pixels	equ	WORD PTR [bp+12]

_put_line proc far

	push	bp
	mov	bp,sp

	push	cx
	push	dx
	push	si
	push	di
	push	ds

	mov	dx,03ceh	; graphics controller
	mov	ax,0005h	; write mode 0

	mov	dx,03c4h	; sequencer
	mov	cl,1		; starting bit in pixel
	mov	bh,1		; starting plane

nxtplane:
	mov	ax,0102h	; plane write sel
	mov	ah,bh
	out	dx,ax

	mov 	ax,videoseg     ; set up pointers:
	mov	es,ax		; es:si for video, ds:di for buffer
	mov	ax,line
	imul	ax,bypitch
	add	ax,_dpaddr	; page to use
	mov	si,ax

	lds	di,buff
	mov	ax,pixels	; number of pixels to read
	add	ax,7
	shr	ax,3		; number of bytes
	mov	ch,al

contwline:
	mov	al,ds:[di]      ; assemble a byte
	shr	al,cl
	rcl	ah,1
	mov	al,ds:[di+1]
	shr	al,cl
	rcl	ah,1
	mov	al,ds:[di+2]
	shr	al,cl
	rcl	ah,1
	mov	al,ds:[di+3]
	shr	al,cl
	rcl	ah,1
	mov	al,ds:[di+4]
	shr	al,cl
	rcl	ah,1
	mov	al,ds:[di+5]
	shr	al,cl
	rcl	ah,1
	mov	al,ds:[di+6]
	shr	al,cl
	rcl	ah,1
	mov	al,ds:[di+7]
	shr	al,cl
	rcl	ah,1

	mov	es:[si],ah      ; next byte
	add	si,1
	add	di,8
	dec	ch
	jne	contwline

	add	cl,1            ; next plane
	shl     bh,1
	and	bh,15
	jne	nxtplane

	pop	ds
	pop	di
	pop	si
	pop	dx
	pop	cx

	pop     bp
	ret

_put_line  endp



 ;
 ; void vsync();                /* waits for vert. sync pulse */
 ;
		PUBLIC  _vsync

_vsync  proc    far

	push    bp
	mov     bp,sp
	mov             dx,03DAh
	in              al,dx           ; test if 0
	test            al,8
	je      short @11@218
@11@122:
	in              al,dx
	nop
	test            al,8            ; wait for 0
	jne     short @11@122
@11@218:
	in              al,dx
	nop
	test            al,8            ; wait for 1
	je      short @11@218
	pop     bp
	ret

_vsync  endp

 ;
 ; void setup_hdwe(int mode);   /* sets up VGA for line, poly draw */
 ;                              /* modes are: 0=PUT, 1=OR,         */
 ;                              /*            2=AND, 3=XOR         */

		PUBLIC  _setup_hdwe

_setup_hdwe     proc    far

	push    bp
	mov     bp,sp
	mov     dx,03CEH
	mov     ah,BYTE PTR [bp+6]      ; set write logic mode
	sal     ah,1
	sal     ah,1
	sal     ah,1
	mov     al,03h
	out     dx,ax
	mov     ax,0B05h                ; write mode = 3 (CPU byte is mask)
	out     dx,ax
	mov     ax,0007h                ; setup for FFh returned by read
	out     dx,ax
	mov     ax,0FF08h               ; all bits enabled
	out     dx,ax
	mov     ax,0FF01h
	out     dx,ax
	pop     bp
	ret

_setup_hdwe     endp

 ;
 ; void reset_hdwe()
 ;

		PUBLIC  _reset_hdwe

_reset_hdwe     proc    far

	push    bp
	mov     bp,sp
	mov     dx,03CEH
	mov     ax,0000         ; reset VGA to mode BIOS expects
	out     dx,ax
	mov     ax,0001
	out     dx,ax
	mov     ax,0003
	out     dx,ax
	mov     ax,0005
	out     dx,ax
	mov	dx,03c4h	; enable all planes
	mov     ax,0FF02h
	out     dx,ax
	pop     bp
	ret

_reset_hdwe     endp

 ;
 ; int clr_page(int page, int color);   /* clear page to color */
 ;
 ;  /* returns 0 if OK, 1 if bad page */

		PUBLIC  _clr_page

_clr_page       proc    far

	push    bp
	mov     bp,sp
	push    di
	push    cx
	push    dx
	cld
	mov     cx,word ptr [bp+6]
	cmp     cx,npages                      ; check for valid page
	jl      gdpage
	mov     ax,-1
	jmp     abbort
gdpage:
	call    far ptr _reset_hdwe     ; reset to default VGA mode
	cld
	mov     dx,03CEh
	mov     al,0                    ; set write color
	mov     ah,BYTE PTR [bp+8]
	and     ah,15
	out     dx,ax
	mov     ax,0F01h
	out     dx,ax
	mov     ax,videoseg
	mov     es,ax

	mov     bx,word ptr [bp+6]
	add     bx,bx
	mov     di,pageoff[bx]

	mov     cx,pgwords

	rep     stosw

	mov     ax,0001h                ; reset VGA mode
	out     dx,ax
	xor     ax,ax
abbort:
	pop     dx
	pop     cx
	pop     di
	mov     sp,bp
	pop     bp
	ret

_clr_page       endp

   ;
   ;    int copy_page(int source, int dest)
   ;
   ;    /* returns 0 if OK, 1 if bad page */

		PUBLIC  _copy_page

_copy_page      proc    far

	push    bp
	mov     bp,sp
	sub     sp,4

	push    si
	push    di
	push    dx
	push    cx

	mov     ax,word ptr [bp+6]      ; compute source address
	cmp     ax,npages
	jge     short @15@74            ; check for valid page #'s
	mov     ax,word ptr [bp+8]
	cmp     ax,npages
	jl      short @15@98
@15@74:
	mov     ax,-1
	jmp     short @15@506
@15@98:
	call    far ptr _reset_hdwe     ; default VGA state
	push    ds
	cld
	mov     dx,03CEh                ; read mode 0, write mode 1 (copy)
	mov     ax,0105h
	out     dx,ax
	mov     ax,videoseg
	mov     es,ax
	mov     ds,ax

	mov     bx,word ptr [bp+6]      ; compute source address
	add     bx,bx
	mov     si,pageoff[bx]
	mov     bx,word ptr [bp+8]      ; compute dest. address
	add     bx,bx
	mov     di,pageoff[bx]

	mov     cx,pgbytes

	rep     movsb

	mov     ax,0005h
	out     dx,ax
	pop     ds
	xor     ax,ax
@15@506:
	pop     cx
	pop     dx
	pop     di
	pop     si

	mov     sp,bp
	pop     bp
	ret

_copy_page      endp


 ;
 ; void vga_reg(int reg)        /* integer: lsby=reg(0=color), msby=value */
 ;

		PUBLIC  _vga_reg

_vga_reg        proc    far

	push    bp
	mov     bp,sp
	mov     dx,03CEH
	mov     ax,WORD PTR [bp+6]
	out     dx,ax
	pop     bp
	ret

_vga_reg        endp



 ;
 ; void load_color(int color)    /* integer: color reg. load */
 ;

		PUBLIC  _load_color

_load_color     proc    far

	push    bp
	mov     bp,sp
	mov     dx,03CEH
	xor     al,al
	mov     ah,BYTE PTR [bp+6]
	and     ah,15
	out     dx,ax
	pop     bp
	ret

_load_color     endp



 ;
 ; int save_8x8(int h, int y, int buffer, int address); /* save 8x8 at x,y */
 ;                                                      /* returns address */
		PUBLIC  _save_8x8

xcoord equ [bp+6]
ycoord equ [bp+8]
buffer equ [bp+10]

_save_8x8       proc    far

	push    bp
	mov     bp,sp
	push    di
	push    si
	push    cx
	push    dx

	mov     ax,ycoord
	imul    ax,bypitch
	mov     si,xcoord
	shr     si,3
	add     si,ax
	add     si,WORD PTR _dpaddr
	push    si

	mov     bx,buffer
	add     bx,bx
	mov     di,cursoff[bx]

	mov     ax,videoseg
	mov     es,ax
	mov     cx,8

nxsl:   mov     al,es:[si]      ; move 16 so it always does 8
	mov     BYTE PTR es:[di],0
	mov     al,es:[si+1]
	mov     BYTE PTR es:[di+1],0
	add     si,bypitch
	add     di,2
	loop    nxsl

	pop     ax
	pop     dx
	pop     cx
	pop     si
	pop     di
	mov     sp,bp
	pop     bp
	ret

_save_8x8       endp

 ;
 ; void rest_8x8(int buffer, int address);      /* restore 8x8 at x,y */
 ;
		PUBLIC  _rest_8x8

buffer  equ [bp+6]
address equ [bp+8]

_rest_8x8       proc    far

	push    bp
	mov     bp,sp
	push    di
	push    si
	push    cx

	mov     bx,buffer
	add     bx,bx
	mov     si,cursoff[bx]
	mov     di,address

	mov     ax,videoseg
	mov     es,ax
	mov     cx,8

nxrl:   mov     al,es:[si]      ; move 16 so it always does 8
	mov     BYTE PTR es:[di],0
	mov     al,es:[si+1]
	mov     BYTE PTR es:[di+1],0
	add     si,2
	add     di,bypitch
	loop    nxrl

	pop     cx
	pop     si
	pop     di
	mov     sp,bp
	pop     bp
	ret

_rest_8x8       endp



 ;
 ; int clr_block(int l, int t, int r, int b, int page, int color);
 ;
 ;  /* returns 0 if OK, 1 if bad page */

cbl     equ WORD PTR [bp+6]
cbt     equ WORD PTR [bp+8]
cbr     equ WORD PTR [bp+10]
cbb     equ WORD PTR [bp+12]
cbpage  equ WORD PTR [bp+14]
cbcolor equ BYTE PTR [bp+16]

		PUBLIC  _clr_block

_clr_block      proc    far

	push    bp
	mov     bp,sp
	push    di
	push    cx
	push    dx
	cld

	call    far ptr _reset_hdwe     ; reset to default VGA mode

	mov     ax,0F01h               ; setup for big writes
	out     dx,ax
	mov     ax,videoseg
	mov     es,ax

	mov     dx,03CEH                ; load color
	xor     al,al
	mov     ah,cbcolor
	and     ah,15
	out     dx,ax

	mov     bx,cbpage
	add     bx,bx
	mov     di,pageoff[bx]

	mov     bx,cbb
	sub     bx,cbt                  ; bx = line count
	jb      badcb

	mov     ax,cbt
	imul    ax,bypitch
	add     di,ax
	mov     ax,cbl
	shr     ax,3
	add     di,ax                   ; start address

	mov     cx,cbl
	and     cx,0FFF8h
	sub     cx,cbr
	neg     cx
	js      badcb
	shr     cx,3
	inc     cx
	mov     ax,cx                   ; count per line
	sub     cx,bypitch
	neg     cx
	mov     dx,cx                   ; fixup factor

cbloop: mov     cx,ax
	rep     stosb
	add     di,dx
	dec     bx
	jge     cbloop

	mov     ax,0001h                ; reset VGA mode
	out     dx,ax
	xor     ax,ax
	jmp     cbexit

badcb:  mov     ax,-1

cbexit: pop     dx
	pop     cx
	pop     di
	mov     sp,bp
	pop     bp
	ret


_clr_block      endp

   ;
   ;    int copy_block(int spage, int sx, int sy,
   ;                   int dpage, int dx, int dy,
   ;                   int xsize, int vsize )
   ;
   ;    /* returns 0 if OK, 1 if bad page */

copsp    equ WORD PTR [bp+6]
copsx    equ WORD PTR [bp+8]
copsy    equ WORD PTR [bp+10]
copdp    equ WORD PTR [bp+12]
copdx    equ WORD PTR [bp+14]
copdy    equ WORD PTR [bp+16]
copxs    equ WORD PTR [bp+18]
copys    equ WORD PTR [bp+20]

		PUBLIC  _copy_block

_copy_block     proc    far

	push    bp
	mov     bp,sp
	sub     sp,4
	push    si
	push    di
	push    cx
	push    dx

	call    far ptr _reset_hdwe     ; write VGA state
	push    ds
	cld
	mov     dx,03CEh                ; read mode 0, write mode 1 (copy)
	mov     ax,0105h
	out     dx,ax

	mov     ax,videoseg
	mov     es,ax
	mov     ds,ax

	mov     bx,copsp                ; compute source address
	add     bx,bx
	mov     si,pageoff[bx]
	mov     bx,copdp                ; compute dest. address
	add     bx,bx
	mov     di,pageoff[bx]

	mov     bx,copys                ; bx = line count

	mov     ax,copsy
	imul    ax,bypitch
	add     si,ax
	mov     ax,copsx
	shr     ax,3
	add     si,ax                   ; start address

	mov     ax,copdy
	imul    ax,bypitch
	add     di,ax
	mov     ax,copdx
	shr     ax,3
	add     di,ax                   ; start address

	mov     cx,copxs
	add     cx,7
	shr     cx,3
	inc     cx
	mov     ax,cx                   ; count per line
	sub     cx,bypitch
	neg     cx
	mov     dx,cx                   ; fixup factor

coplop: mov     cx,ax
	rep     movsb
	add     si,dx
	add     di,dx
	dec     bx
	jg      coplop

	mov     ax,0005h
	out     dx,ax
	pop     ds
	xor     ax,ax

	pop     dx
	pop     cx
	pop     di
	pop     si
	mov     sp,bp
	pop     bp
	ret

_copy_block     endp


 ;
 ; void load_DAC(char far *data, int count);
 ;                      /* loads DAC             */


 count   equ [bp+10]
 dacdata equ [bp+6]

	PUBLIC  _load_DAC

		; maps DAC load for std. palette reg. set

pal_map: db     0,1,2,3,4,5,20,7,56,57,58,59,60,61,62,63,0


_load_DAC       proc    far

	push    bp
	mov     bp,sp
	push    dx
	push    cx
	push    si

	mov     ax,cs
	mov     es,ax
	mov     dx,offset pal_map
	mov     ax,1009h
	int     10h

	les     bx,DWORD PTR dacdata
	mov     si,offset pal_map
	mov     cx,WORD PTR count

mvp:    mov     al,BYTE PTR cs:[si]
	inc     si
	mov     dx,03C8h
	out     dx,al

	mov     dx,03C9h

	mov     al,BYTE PTR es:[bx]
	out     dx,al
	inc     bx
	nop
	nop
	mov     al,BYTE PTR es:[bx]
	out     dx,al
	inc     bx
	nop
	nop
	mov     al,BYTE PTR es:[bx]
	out     dx,al
	inc     bx
	loop    mvp

	pop     si
	pop     cx
	pop     dx
	pop     bp
	ret

_load_DAC       endp

 ;
 ; void read_DAC(char far *data, int count);
 ;                      /* reads DAC             */


 count   equ [bp+10]
 dacdata equ [bp+6]

	PUBLIC  _read_DAC

_read_DAC       proc    far

	push    bp
	mov     bp,sp
	push    dx
	push    cx
	push    si

	mov     ax,cs
	mov     es,ax
	mov     dx,offset pal_map
	mov     ax,1009h
	int     10h

	les     bx,DWORD PTR dacdata
	mov     si,offset pal_map
	mov     cx,WORD PTR count

mvpr:   mov     al,BYTE PTR cs:[si]
	inc     si
	mov     dx,03C7h
	out     dx,al

	mov     dx,03C9h

	in      al,dx
	mov     BYTE PTR es:[bx],al
	inc     bx
	nop
	nop
	in      al,dx
	mov     BYTE PTR es:[bx],al
	inc     bx
	nop
	nop
	in      al,dx
	mov     BYTE PTR es:[bx],al
	inc     bx
	loop    mvpr

	pop     si
	pop     cx
	pop     dx
	pop     bp
	ret

_read_DAC       endp


		end


