	TITLE   392x200x256 mode support

	COMMENT $

		Written  by Dave Stampe
		Copyright (c) 1993
		Not for commercial use, so get permission
		before marketing code using this stuff!

		$

include vdmodel.inc	; sets memory model

		.DATA

drop    dw      0

		.CODE  vdriver
		.386


include vdef200t.inc    ; defines constants, tables

  PUBLIC _vid_char_table_

_vid_char_table_        dd ?    ; is seen as chartable

extrn   _setup_hdwe
extrn   _reset_hdwe

 ;
 ; void _set_vmode(int mode)    /* enters video mode thru BIOS */
 ;                              /* mode: clear if MSB not 0    */
 ;                              /* mode 14h = X-mode           */

		PUBLIC  _set_vmode
		EXTRN   _set_crt_vmode

_set_vmode      proc    far

	.386
	push    bp
	mov     bp,sp

	mov     ax,0013h       ; get small character table
	int     10h

	xor     bx,bx
	mov     es,bx
	mov     bx,43h*4
	mov     eax,es:[bx]
	mov     DWORD PTR chartable,eax

	mov     ax,WORD PTR [bp+6]

	cmp     al,3
	jnz     domode
	int     10h
	pop     bp
	ret

domode:

	push    si
	push    di
	push    cx
	push    dx

	mov     si,ax
	and     si,0FFh

	and     ax,0100h
	mov     WORD PTR drop,ax   ; mark if vert. pos'n offset used

	mov     dx,03c4h        ; convert to X-mode addressing
	mov     ax,0604h        ; chain mode off
	out     dx,ax

	cmp     si,0014h        ; tweek mode clock?
	je      noct
	mov     dx,03c2h        ; 28 MHz dot clock
	mov     al,67h
	out     dx,al
noct:
	mov     dx,03d4h
	mov     ax,0e11h        ; unlock CRTC
	out     dx,ax

	mov     ax,0014h        ; doubleword off
	out     dx,ax
	mov     ax,0E317h       ; byte mode on
	out     dx,ax
	cmp     si,0014h
	je      notweek
	cmp     si,0015h
	je      tweek360

	mov     ax,07000h       ; set H parameters  (392 H)
	out     dx,ax
	mov     ax,06201h
	out     dx,ax
	mov     ax,06102h
	out     dx,ax
	mov     ax,06604h
	out     dx,ax
	mov     ax,08205h
	out     dx,ax
	jmp     notweek
tweek360:
	mov     ax,06a00h       ; set H parameters  (360 H)
	out     dx,ax
	mov     ax,05901h
	out     dx,ax
	mov     ax,05a02h
	out     dx,ax
	mov     ax,05f04h
	out     dx,ax
	mov     ax,08205h
	out     dx,ax
notweek:
	mov     si,0c712h             ; 200 lines
	test    WORD PTR drop, 0FFFFh
	jz      nodrop                ; dropped down
	mov     si,0f012h
	mov     ax,02816h   ; offset by 41 lines to get away from top of screen
	out     dx,ax
nodrop:
	mov     ax,04009h   ; single-scan
	out     dx,ax
	mov     ax,si       ; set bottom blank
	out     dx,ax
	mov     ax,03213h   ; logical line length
	out     dx,ax
	mov     ax,01d07h
	out     dx,ax

	mov     ax,8e11h    ; relock CRTC (or else some cards won't work)
	out     dx,ax

	call far ptr _reset_hdwe

	mov     ax,WORD PTR[bp+6]
	test    al,080h
	jnz     dontclear

	mov     ax,0f02h
	out     dx,ax           ; clear all planes at once
	mov     ax,videoseg
	mov     es,ax
	xor     di,di
	mov     cx,0ffffh
	xor     ax,ax
	rep     stosb

	mov     di,0ff00h       ; setup latch color table
	mov     cx,100h
	xor     al,al
ctloop: stosb
	inc     al
	loop    ctloop

dontclear:
	pop     dx
	pop     cx
	pop     di
	pop     si
	pop     bp
	ret

_set_vmode      endp


 ;
 ; void _set_vpage(int page)    /* sets video page */
 ;

		PUBLIC  _set_vpage

_set_vpage      proc    far

	push    bp
	mov     bp,sp
	push    si
	push    di
	push    cx
	push    dx

	mov     al,BYTE PTR [bp+6]
	xor     ah,ah
	cmp     ax,npages               ; check page #
	jae     badpage

	mov     bx,ax
	add     bx,bx
	mov     ax,pageoff[bx]

	test    WORD PTR drop, 0FFFFh
	jz      nodropa
	sub     ax,4100         ; fixup for vertical offset
nodropa:
	mov     bh,ah
	mov     ah,al           ; page # -> address
	mov     al,0dh
	mov     bl,0ch

	mov     dx,03d4h        ; set CRTC address
	out     dx,ax
	mov     ax,bx
	out     dx,ax
badpage:
	pop     dx
	pop     cx
	pop     di
	pop     si
	pop     bp
	ret

_set_vpage      endp


 ;
 ; void _set_drawpage(int page)    /* sets drawing page */
 ;

	extrn   _dpaddr         ; page base address
	PUBLIC  _set_drawpage

_set_drawpage   proc    far

	push    bp
	mov     bp,sp

	mov     al,BYTE PTR [bp+6]
	xor     ah,ah
	cmp     ax,npages               ; check page #
	jl      okpage
	mov     ax,-1
	pop     bp
	ret
okpage:
	mov     bx,ax
	add     bx,bx
	mov     bx,pageoff[bx]
	mov     _dpaddr,bx
	xor     ax,ax
	pop     bp
	ret

_set_drawpage   endp




		end

