	TITLE   GXSPPT - 320x200x256 mode support


	COMMENT $

		Written  by Dave Stampe
		Copyright (c) 1993
		Not for commercial use, so get permission
		before marketing code using this stuff!

		$

include vdmodel.inc

		.CODE vdriver
		.386


include vdef200x.inc    ; defines constants, tables


  PUBLIC _vid_char_table_

_vid_char_table_        dd ?    ; is seen as chartable

extrn _reset_hdwe
extrn _setup_hdwe


 ;
 ; void _set_vmode(int mode)    /* enters video mode thru BIOS */
 ;                              /* mode: clear if MSB not 0    */
 ;                              /* mode 14h = X-mode           */

		PUBLIC  _set_vmode

_set_vmode      proc    far

	push    bp
	mov     bp,sp

	mov     ah,0
	mov     al,BYTE PTR [bp+6]
	mov     bl,al
	and     bl,07fh
	cmp     bl,14h
	jz      setxmode
	int     10h
	pop     bp
	ret

setxmode:
	push    si
	push    di
	push    cx
	push    dx
	mov     ah,0            ; set 256-color mode
	mov     al,13h
	int     10h

	xor     bx,bx           ; get small character table
	mov     es,bx
	mov     bx,43h*4
	mov     eax,es:[bx]
	mov     DWORD PTR chartable,eax

	mov     dx,03c4h        ; convert to X-mode addressing
	mov     ax,0604h        ; chain mode off
	out     dx,ax

	mov     dx,03d4h
	mov     ax,0014h        ; doubleword off
	out     dx,ax
	mov     ax,0E317h       ; byte mode on
	out     dx,ax

	call    far ptr _reset_hdwe

	mov     ax,WORD PTR[bp+6]
	test    al,080h
	jnz     dontclear

	mov     ax,0f02h
	out     dx,ax           ; clear all planes at once
	mov     ax,videoseg
	mov     es,ax
	xor     di,di
	mov     cx,0ffffh
	xor     ax,ax
	rep     stosb

	mov     di,colortable   ; setup latch color table
	mov     cx,100h
	xor     al,al
ctloop: stosb
	inc     al
	loop    ctloop

dontclear:
	pop     dx
	pop     cx
	pop     di
	pop     si
	pop     bp
	ret

_set_vmode      endp


 ;
 ; void _set_vpage(int page)    /* sets video page */
 ;

		PUBLIC  _set_vpage

_set_vpage      proc    far

	push    bp
	mov     bp,sp
	push    si
	push    di
	push    cx
	push    dx

	mov     al,BYTE PTR [bp+6]
	xor     ah,ah
	cmp     ax,npages               ; check page #
	jae     badpage

	mov     bx,ax
	add     bx,bx
	mov     ax,pageoff[bx]

	mov     bh,ah
	mov     ah,al           ; page # -> address
	mov     al,0dh
	mov     bl,0ch

	mov     dx,03d4h        ; set CRTC address
	out     dx,ax
	mov     ax,bx
	out     dx,ax
badpage:
	pop     dx
	pop     cx
	pop     di
	pop     si
	pop     bp
	ret

_set_vpage      endp



 ;
 ; void _set_drawpage(int page)    /* sets drawing page */
 ;

	extrn   _dpaddr         ; page base address
	PUBLIC  _set_drawpage

_set_drawpage   proc    far

	push    bp
	mov     bp,sp

	mov     al,BYTE PTR [bp+6]
	xor     ah,ah
	cmp     ax,npages               ; check page #
	jl      okpage
	mov     ax,-1
	pop     bp
	ret
okpage:
	mov     bx,ax
	add     bx,bx
	mov     bx,pageoff[bx]
	mov     _dpaddr,bx
	xor     ax,ax
	pop     bp
	ret

_set_drawpage   endp


		end

