;----------------------------------------------------------------------------:
; FILES 																	 :
; Code to read files into memory Uses DOS 3.0 + calls						 :
; (C) John Connors							1993							 :
;----------------------------------------------------------------------------:
	    

		.286
		IDEAL
		MODEL	HUGE,C					    
	    
; equates for int 21h calls

DOS_Open		EQU 03dh
DOS_Read		EQU 03fh
DOS_Close		EQU 03eh
DOS_Seek		EQU 042h
DOS_File_Search EQU 04eh
DOS_Next_File	EQU 04fh
DOS_Set_DTA 	EQU 01ah

; call an int 21h service

MACRO	DOS_Call Service
		MOV 	AH,Service
		INT 	21h
ENDM

		DATASEG
	    
STRUC	DOS_DTA 			    
					db 21 dup (0)				; DTA, used by DOS as
	file_attributes db 0						; scratchpad for file info
	File_Time		dw 0
	File_Date		dw 0
	File_Size		dd 0
	File_Name		db 13 dup (0)

ENDS	DOS_DTA

DTA DOS_DTA 	<>
					db 128 dup (0)				; for safety
		CODESEG

;----------------------------------------------------------------------------:
;			CODE SEGMENT													 :
;----------------------------------------------------------------------------:

		PUBLIC get_file
		PUBLIC get_file_size

;----------------------------------------------------------------------------:
; Get file - suck file into memory. 										 :
; Enter with EAX pointing to entry in file name list						 :
; Exit	with ECX is size of file in bytes or 0 for an error 				 :
;		file is read into File_Segment at offset File_Data					 :
;----------------------------------------------------------------------------:

PROC	get_file    
		USES	ES,DS,SI,DI
		ARG 	file_name:DATAPTR,file_buffer:DATAPTR

		LDS 	SI,[file_name]					; DS:SI points to file name list
		PUSH	DS
		PUSH	SI
		CALL	PROC get_file_size				; get the size of the file
		ADD 	SP,4
	    
		OR		AX,AX
		JZ		SHORT @@Error					; something went wrong
		PUSH	AX								; save file size
	    
		MOV 	DX,SI							; point to file name
		MOV 	AL,11000000b					; file open code

		DOS_Call	DOS_Open					; open file 

		POP 	CX
		JC		SHORT @@Error					; something went wrong
	    
		MOV 	BX,AX							; BX = file handle
		LDS 	DX,[file_buffer]

		DOS_Call	DOS_Read	    

		JC		SHORT @@Error					; ok? no - oh, balls..
		MOV 	CX,AX							; EAX = bytes read

		DOS_Call	DOS_Close

		JC		SHORT @@Error					; oh, dammn..
		JMP 	SHORT @@get_exit				; okay
@@Error:    
		XOR 	CX,CX 
@@get_exit: 
		MOV 	AX,CX
	    
		RET
ENDP	get_file
	    
;----------------------------------------------------------------------------:
; File Size - return file size												 :
; Enter with DS:SI pointing to ASCIIZ file name 							 :
; Exit with EAX holding size of file in bytes								 :
;----------------------------------------------------------------------------:

PROC get_file_size  
		USES	BX,DX,CX,SI,DI,DS,ES
		ARG 	File_Name:DATAPTR
    
		LES 	SI,[File_Name]
		PUSH	SEG DTA
		POP 	DS
		MOV 	DX,OFFSET DTA					; DS:DX = Dta address
		DOS_Call	DOS_Set_DTA 				; set DTA to DS:DX
	    
		PUSH	ES								; set DS to filename segment
		POP 	DS
	    
		MOV 	DX,SI							; DS:DX == file name
		XOR 	CX,CX							; CX = search attributes 
		DOS_Call	DOS_File_Search 			; look for file
		JC		SHORT @@Error

		PUSH	SEG DTA 						; get the length from DTA
		POP 	DS
		ASSUME	DS:SEG DTA  
		MOV 	SI,OFFSET DTA
		MOV 	AX,[WORD (DOS_DTA PTR SI).File_Size]
		JMP 	SHORT @@fil_exit
	    
@@Error:    
		XOR 	AX,AX
	    
@@fil_exit:
	    
		RET     

ENDP	get_file_size

		END
