                                                        
/*
**  Joystick Emulation Functions.
**
**  Copyright 1993-2000 by Paul D. Burgin. All rights reserved.
*/

#include "dos.h"
#include "conio.h"
#include "stdlib.h"	/* min macro */

#include "build.h"
#include "types.h"
#include "extern.h"
#include "key.h"

/* Mouse sensitivity in digital joysticks mode. */
#define X_SENS	16
#define Y_SENS	5

boolean digital_joysticks = FALSE;
boolean mouse_disabled    = FALSE;
boolean mouse_installed   = FALSE;
boolean realjoy			  = FALSE;

/* Configuration variables for PC joystick (auto-adjusted). */
#define DEF_MIN 0xffffffff
#define DEF_MAX 0x00000000
unsigned long x_min = DEF_MIN, y_min = DEF_MIN;
unsigned long x_max = DEF_MAX, y_max = DEF_MAX;

/* Current position of emulated joystick. */
unsigned int joy_x = 63, joy_y = 63;

/* Check for mouse driver and initialise it. */
boolean mouse_okay(void)
{
	if (!mouse_disabled && !mouse_installed)
	{
		regs.x.ax = 0; /* reset the mouse */
		int86(MOUSE_INT, &regs, &regs);
		mouse_installed = ((signed int)regs.x.ax == -1);
		mouse_disabled  = !mouse_installed;
		if (mouse_installed)
		{
			regs.x.ax = 7;
			regs.x.cx = 0; /* set x resolution */
			regs.x.dx = 639;
			int86(MOUSE_INT, &regs, &regs);
			regs.x.ax = 8;
			regs.x.cx = 0; /* set y resolution */
			regs.x.dx = 199;
			int86(MOUSE_INT, &regs, &regs);
		}
	}
	return(mouse_installed);
}

/* Update joystick positions. */
void update_joysticks(unsigned int where_to)
{
	/* Joystick emulation using the 'Real Mode' keyboard. */
	if (new_int9_set && (keys[kUARROW] || keys[kRARROW] || keys[kDARROW]
		|| keys[kLARROW] || keys[kKEYPAD8] || keys[kKEYPAD2]
		|| keys[kKEYPAD4]|| keys[kKEYPAD6]))
	{
		if (keys[kRARROW] || keys[kKEYPAD6])
			joy_x = 63;
		else if (keys[kLARROW] || keys[kKEYPAD4])
			joy_x = 0;
		else
			joy_x = 32;
		if (keys[kDARROW] || keys[kKEYPAD2])
			joy_y = 63;
		else if (keys[kUARROW] || keys[kKEYPAD8])
			joy_y = 0;
		else
			joy_y = 32;
	}

	/* Joystick emulation using the PC joystick. */
	else if (realjoy)
	{
		/* Call bios to read stick positions (this is SLOW)! */
		regs.h.ah = 0x84;
		regs.x.dx = 1;
		int86(JOYSTICK_INT, &regs, &regs);

		/* Auto-configure range if necessary. */
		if ((regs.x.ax < x_min) || (x_min == DEF_MIN))
			x_min = regs.x.ax;
		if ((regs.x.ax > x_max) || (x_max == DEF_MAX))
			x_max = regs.x.ax;
		if ((regs.x.bx < y_min) || (y_min == DEF_MIN))
			y_min = regs.x.bx;
		if ((regs.x.bx > y_max) || (y_max == DEF_MAX))
			y_max = regs.x.bx;

		/* Work out the equivalent Dragon values. */
		if (x_max != x_min)
			joy_x = min(63,((regs.x.ax - x_min) * 64) / (x_max - x_min));
		else
			joy_x = 32;
		if (y_max != y_min)
			joy_y = min(63,((regs.x.bx - y_min) * 64) / (y_max - y_min));
		else
			joy_y = 32;

		/* Translate to digital values if required. */
		if (digital_joysticks)
		{
			if (joy_x > 49)
				joy_x = 63;
			else if (joy_x < 13)
				joy_x = 0;
			else
				joy_x = 32;
			if (joy_y > 49)
				joy_y = 63;
			else if (joy_y < 13)
				joy_y = 0;
			else
				joy_y = 32;
		}
	}

	/* Joystick emulation using the mouse. */
	else if (mouse_okay())
	{
		if (digital_joysticks)
		{
			/* Just read direction of motion for digital emulation. */
			regs.x.ax = 11;
			int86(MOUSE_INT, &regs, &regs);

			if ((signed int)regs.x.cx > X_SENS)
				joy_x = 63;
			else if((signed int)regs.x.cx < -X_SENS)
				joy_x = 0;
			else
				joy_x = 32;

			if ((signed int)regs.x.dx > Y_SENS)
				joy_y = 63;
			else if((signed int)regs.x.dx < -Y_SENS)
				joy_y = 0;
			else
				joy_y = 32;
		}
		else
		{
			/* Read mouse position for analogue emulation. */
			regs.x.ax = 3;
			int86(MOUSE_INT, &regs, &regs);

			/* Scale down from 640 x 200. */
			regs.x.cx /= 9;
			if (regs.x.cx > 63)
				regs.x.cx = 63;
			regs.x.dx /= 3;
			if (regs.x.dx > 63)
				regs.x.dx = 63;
			joy_x = (unsigned int)regs.x.cx;
			joy_y = (unsigned int)regs.x.dx;
		}
	}
	memory[where_to]	= memory[where_to+2] = (unsigned char)joy_x;
	memory[where_to+1]	= memory[where_to+3] = (unsigned char)joy_y;
}

/* Update fire buttons into address JOY_BUTTON bits 0 and 1. */
void update_fire_buttons(void)
{
	/* Check for keyboard as fire buttons if 'Real Mode' keyboard used. */
	if (new_int9_set && keys[kKEYPAD5])
	{
		memory[JOY_BUTTON] = 0xfc;
	}
	else if (new_int9_set && keys[kKEYPAD1])
	{
		memory[JOY_BUTTON] = 0xfe;
	}
	else if (new_int9_set && keys[kKEYPAD3])
	{
		memory[JOY_BUTTON] = 0xfd;
	}
	else if (realjoy)
	{
		/* Read PC joystick fire button by calling the bios. */
		regs.h.ah = 0x84;
		regs.x.dx = 0;
		int86(JOYSTICK_INT, &regs, &regs);
		memory[JOY_BUTTON] = ((((regs.h.al) >> 4) & 0x03) | 0xfc);
	}
	else
	{
		/* Read mouse buttons. */
		regs.x.ax = 3;
		int86(MOUSE_INT, &regs, &regs);
		memory[JOY_BUTTON] = ~(regs.x.bx & 0x03);
	}
}
